/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.statistics;

import java.util.Set;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.analytics.statistics.MinMaxStatsCollector;

public class NumericStatsCollector
extends MinMaxStatsCollector {
    protected double sum = 0.0;
    protected double sumOfSquares = 0.0;
    protected double mean = 0.0;
    protected double stddev = 0.0;

    public NumericStatsCollector(ValueSource source, Set<String> statsList) {
        super(source, statsList);
    }

    @Override
    public void collect(int doc) {
        super.collect(doc);
        double value = this.function.doubleVal(doc);
        this.sum += value;
        this.sumOfSquares += value * value;
    }

    @Override
    public Comparable getStat(String stat) {
        if (stat.equals("sum")) {
            return new Double(this.sum);
        }
        if (stat.equals("sumofsquares")) {
            return new Double(this.sumOfSquares);
        }
        if (stat.equals("mean")) {
            return new Double(this.mean);
        }
        if (stat.equals("stddev")) {
            return new Double(this.stddev);
        }
        return super.getStat(stat);
    }

    @Override
    public void compute() {
        super.compute();
        this.mean = this.valueCount == 0L ? 0.0 : this.sum / (double)this.valueCount;
        this.stddev = this.valueCount <= 1L ? 0.0 : Math.sqrt(this.sumOfSquares / (double)this.valueCount - this.mean * this.mean);
    }
}

