/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.s9api.BuildingStreamWriterImpl;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.saxon.XMLInputFactoryCreator;
import org.kitesdk.morphline.saxon.XMLStreamCopier;
import org.kitesdk.morphline.stdio.AbstractParser;

abstract class SaxonCommand
extends AbstractParser {
    protected final XMLInputFactory inputFactory = new XMLInputFactoryCreator().getXMLInputFactory();
    protected final DocumentBuilder documentBuilder;
    protected final Processor processor;
    protected final boolean isTracing;

    public SaxonCommand(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
        super(builder, config, parent, child, context);
        this.isTracing = this.getConfigs().getBoolean(config, "isTracing", false);
        boolean isLicensedSaxonEdition = this.getConfigs().getBoolean(config, "isLicensedSaxonEdition", false);
        this.processor = new Processor(isLicensedSaxonEdition);
        this.documentBuilder = this.processor.newDocumentBuilder();
        Config features = this.getConfigs().getConfig(config, "features", ConfigFactory.empty());
        for (Map.Entry entry : new Configs().getEntrySet(features)) {
            this.processor.setConfigurationProperty((String)entry.getKey(), entry.getValue());
        }
    }

    protected final boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
        try {
            return this.doProcess2(inputRecord, stream);
        }
        catch (SaxonApiException e) {
            throw new MorphlineRuntimeException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new MorphlineRuntimeException((Throwable)e);
        }
    }

    protected abstract boolean doProcess2(Record var1, InputStream var2) throws IOException, SaxonApiException, XMLStreamException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XdmNode parseXmlDocument(File file) throws XMLStreamException, SaxonApiException, IOException {
        InputStream stream = new FileInputStream(file);
        try {
            if (file.getName().endsWith(".gz")) {
                stream = new GZIPInputStream(new BufferedInputStream(stream));
            }
            XdmNode xdmNode = this.parseXmlDocument(stream);
            return xdmNode;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    protected XdmNode parseXmlDocument(InputStream stream) throws XMLStreamException, SaxonApiException {
        XMLStreamReader reader = this.inputFactory.createXMLStreamReader(null, stream);
        BuildingStreamWriterImpl writer = this.documentBuilder.newBuildingStreamWriter();
        new XMLStreamCopier(reader, (XMLStreamWriter)writer).copy(false);
        reader.close();
        writer.close();
        XdmNode document = writer.getDocumentNode();
        return document;
    }

    final class DefaultErrorListener
    implements ErrorListener {
        DefaultErrorListener() {
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            SaxonCommand.this.LOG.error("Error: " + e.getMessageAndLocation(), (Throwable)e);
            throw e;
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            SaxonCommand.this.LOG.error("Fatal error: " + e.getMessageAndLocation(), (Throwable)e);
            throw e;
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            SaxonCommand.this.LOG.warn("Warning: " + e.getMessageAndLocation(), (Throwable)e);
        }
    }
}

