/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.hadoop.AlphaNumericComparator;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ZooKeeperInspector {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperInspector.class);

    ZooKeeperInspector() {
    }

    public List<List<String>> extractShardUrls(String zkHost, String collection) {
        DocCollection docCollection = this.extractDocCollection(zkHost, collection);
        List<Slice> slices = this.getSortedSlices(docCollection.getSlices());
        ArrayList<List<String>> solrUrls = new ArrayList<List<String>>(slices.size());
        for (Slice slice : slices) {
            if (slice.getLeader() == null) {
                throw new IllegalArgumentException("Cannot find SolrCloud slice leader. It looks like not all of your shards are registered in ZooKeeper yet");
            }
            Collection replicas = slice.getReplicas();
            ArrayList<String> urls = new ArrayList<String>(replicas.size());
            for (Replica replica : replicas) {
                ZkCoreNodeProps props = new ZkCoreNodeProps((ZkNodeProps)replica);
                urls.add(props.getCoreUrl());
            }
            solrUrls.add(urls);
        }
        return solrUrls;
    }

    public DocCollection extractDocCollection(String zkHost, String collection) {
        if (collection == null) {
            throw new IllegalArgumentException("collection must not be null");
        }
        try (SolrZkClient zkClient = this.getZkClient(zkHost);){
            ZkStateReader zkStateReader = new ZkStateReader(zkClient);
            try {
                collection = this.checkForAlias(zkClient, collection);
                zkStateReader.createClusterStateWatchersAndUpdate();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find expected information for SolrCloud in ZooKeeper: " + zkHost, e);
            }
            try {
                DocCollection e = zkStateReader.getClusterState().getCollection(collection);
                return e;
            }
            catch (SolrException e) {
                throw new IllegalArgumentException("Cannot find collection '" + collection + "' in ZooKeeper: " + zkHost, e);
            }
        }
    }

    public SolrZkClient getZkClient(String zkHost) {
        SolrZkClient zkClient;
        if (zkHost == null) {
            throw new IllegalArgumentException("zkHost must not be null");
        }
        try {
            zkClient = new SolrZkClient(zkHost, 30000);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot connect to ZooKeeper: " + zkHost, e);
        }
        return zkClient;
    }

    public List<Slice> getSortedSlices(Collection<Slice> slices) {
        ArrayList<Slice> sorted = new ArrayList<Slice>(slices);
        Collections.sort(sorted, new Comparator<Slice>(){

            @Override
            public int compare(Slice slice1, Slice slice2) {
                AlphaNumericComparator c = new AlphaNumericComparator();
                return c.compare(slice1.getName(), slice2.getName());
            }
        });
        LOG.trace("Sorted slices: {}", sorted);
        return sorted;
    }

    public String readConfigName(SolrZkClient zkClient, String collection) throws KeeperException, InterruptedException {
        byte[] data;
        if (collection == null) {
            throw new IllegalArgumentException("collection must not be null");
        }
        String configName = null;
        collection = this.checkForAlias(zkClient, collection);
        String path = "/collections/" + collection;
        if (LOG.isInfoEnabled()) {
            LOG.info("Load collection config from:" + path);
        }
        if ((data = zkClient.getData(path, null, null, true)) != null) {
            ZkNodeProps props = ZkNodeProps.load((byte[])data);
            configName = props.getStr("configName");
        }
        if (configName != null && !zkClient.exists("/configs/" + configName, true).booleanValue()) {
            LOG.error("Specified config does not exist in ZooKeeper:" + configName);
            throw new IllegalArgumentException("Specified config does not exist in ZooKeeper:" + configName);
        }
        return configName;
    }

    private String checkForAlias(SolrZkClient zkClient, String collection) throws KeeperException, InterruptedException {
        byte[] aliasData = zkClient.getData("/aliases.json", null, null, true);
        Aliases aliases = ClusterState.load((byte[])aliasData);
        String alias = aliases.getCollectionAlias(collection);
        if (alias != null) {
            List aliasList = StrUtils.splitSmart((String)alias, (String)",", (boolean)true);
            if (aliasList.size() > 1) {
                throw new IllegalArgumentException("collection cannot be an alias that maps to multiple collections");
            }
            collection = (String)aliasList.get(0);
        }
        return collection;
    }

    public File downloadConfigDir(SolrZkClient zkClient, String configName) throws IOException, InterruptedException, KeeperException {
        File dir = Files.createTempDir();
        dir.deleteOnExit();
        ZkConfigManager configManager = new ZkConfigManager(zkClient);
        configManager.downloadConfigDir(configName, dir.toPath());
        File confDir = new File(dir, "conf");
        if (!confDir.isDirectory()) {
            confDir = new File(Files.createTempDir().getAbsolutePath(), "conf");
            confDir.getParentFile().deleteOnExit();
            Files.move((File)dir, (File)confDir);
            dir = confDir.getParentFile();
        }
        FileUtils.writeStringToFile((File)new File(dir, "solr.xml"), (String)"<solr><solrcloud></solrcloud></solr>", (String)"UTF-8");
        this.verifyConfigDir(confDir);
        return dir;
    }

    private void verifyConfigDir(File confDir) throws IOException {
        File solrConfigFile = new File(confDir, "solrconfig.xml");
        if (!solrConfigFile.exists()) {
            throw new IOException("Detected invalid Solr config dir in ZooKeeper - Reason: File not found: " + solrConfigFile.getName());
        }
        if (!solrConfigFile.isFile()) {
            throw new IOException("Detected invalid Solr config dir in ZooKeeper - Reason: Not a file: " + solrConfigFile.getName());
        }
        if (!solrConfigFile.canRead()) {
            throw new IOException("Insufficient permissions to read file: " + solrConfigFile);
        }
    }
}

