/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.Language;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DetectedLanguage;
import org.apache.solr.update.processor.LanguageIdentifierUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class LangDetectLanguageIdentifierUpdateProcessor
extends LanguageIdentifierUpdateProcessor {
    public LangDetectLanguageIdentifierUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(req, rsp, next);
    }

    @Override
    protected List<DetectedLanguage> detectLanguage(SolrInputDocument doc) {
        try {
            Detector detector = DetectorFactory.create();
            detector.setMaxTextLength(this.maxTotalChars);
            for (String fieldName : this.inputFields) {
                Collection fieldValues;
                log.debug("Appending field " + fieldName);
                if (!doc.containsKey((Object)fieldName) || (fieldValues = doc.getFieldValues(fieldName)) == null) continue;
                for (Object content : fieldValues) {
                    if (content instanceof String) {
                        String stringContent = (String)content;
                        if (stringContent.length() > this.maxFieldValueChars) {
                            detector.append(stringContent.substring(0, this.maxFieldValueChars));
                        } else {
                            detector.append(stringContent);
                        }
                        detector.append(" ");
                        continue;
                    }
                    log.warn("Field " + fieldName + " not a String value, not including in detection");
                }
            }
            ArrayList langlist = detector.getProbabilities();
            ArrayList<DetectedLanguage> solrLangList = new ArrayList<DetectedLanguage>();
            for (Language l : langlist) {
                solrLangList.add(new DetectedLanguage(l.lang, l.prob));
            }
            return solrLangList;
        }
        catch (LangDetectException e) {
            log.debug("Could not determine language, returning empty list: ", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

