/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.LangDetectLanguageIdentifierUpdateProcessor;
import org.apache.solr.update.processor.LangIdParams;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.SolrCoreAware;

public class LangDetectLanguageIdentifierUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware,
LangIdParams {
    protected SolrParams defaults;
    protected SolrParams appends;
    protected SolrParams invariants;
    static boolean loaded;
    static final String[] languages;

    public void inform(SolrCore core) {
    }

    public void init(NamedList args) {
        try {
            LangDetectLanguageIdentifierUpdateProcessorFactory.loadData();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't load profile data, will return empty languages always!", e);
        }
        if (args != null) {
            Object o = args.get("defaults");
            this.defaults = o != null && o instanceof NamedList ? SolrParams.toSolrParams((NamedList)((NamedList)o)) : SolrParams.toSolrParams((NamedList)args);
            o = args.get("appends");
            if (o != null && o instanceof NamedList) {
                this.appends = SolrParams.toSolrParams((NamedList)((NamedList)o));
            }
            if ((o = args.get("invariants")) != null && o instanceof NamedList) {
                this.invariants = SolrParams.toSolrParams((NamedList)((NamedList)o));
            }
        }
    }

    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        if (req != null) {
            SolrPluginUtils.setDefaults((SolrQueryRequest)req, (SolrParams)this.defaults, (SolrParams)this.appends, (SolrParams)this.invariants);
        }
        return new LangDetectLanguageIdentifierUpdateProcessor(req, rsp, next);
    }

    public static synchronized void loadData() throws IOException, LangDetectException {
        if (loaded) {
            return;
        }
        loaded = true;
        ArrayList<String> profileData = new ArrayList<String>();
        for (String language : languages) {
            InputStream stream = LangDetectLanguageIdentifierUpdateProcessor.class.getResourceAsStream("langdetect-profiles/" + language);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            profileData.add(new String(IOUtils.toCharArray((Reader)reader)));
            reader.close();
        }
        DetectorFactory.loadProfile(profileData);
        DetectorFactory.setSeed((long)0L);
    }

    static {
        languages = new String[]{"af", "ar", "bg", "bn", "cs", "da", "de", "el", "en", "es", "et", "fa", "fi", "fr", "gu", "he", "hi", "hr", "hu", "id", "it", "ja", "kn", "ko", "lt", "lv", "mk", "ml", "mr", "ne", "nl", "no", "pa", "pl", "pt", "ro", "ru", "sk", "sl", "so", "sq", "sv", "sw", "ta", "te", "th", "tl", "tr", "uk", "ur", "vi", "zh-cn", "zh-tw"};
    }
}

