/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.LimitInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public final class DevURandomSeedGenerator
implements SeedGenerator {
    private static final File DEV_URANDOM = new File("/dev/urandom");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] generateSeed(int length) throws SeedException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(DEV_URANDOM);
            byArray = ByteStreams.toByteArray((InputStream)new LimitInputStream((InputStream)in, (long)length));
        }
        catch (IOException ex) {
            try {
                throw new SeedException("Failed reading from " + DEV_URANDOM.getName(), (Throwable)ex);
                catch (SecurityException ex2) {
                    throw new SeedException("SecurityManager prevented access to " + DEV_URANDOM.getName(), (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        return byArray;
    }

    public String toString() {
        return "/dev/urandom";
    }
}

