/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class NonnegativeMatrixFactorizationED
extends IterativeMatrixFactorizationBase {
    public NonnegativeMatrixFactorizationED(DoubleMatrix2D A) {
        super(A);
    }

    @Override
    public void compute() {
        double eps = 1.0E-9;
        this.U = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        this.V = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        this.seedingStrategy.seed(this.A, this.U, this.V);
        DenseDoubleMatrix2D T = new DenseDoubleMatrix2D(this.k, this.k);
        DenseDoubleMatrix2D UT1 = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        DenseDoubleMatrix2D UT2 = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        DenseDoubleMatrix2D VT1 = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        DenseDoubleMatrix2D VT2 = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        DoubleFunction plusEps = Functions.plus((double)eps);
        if (this.stopThreshold >= 0.0) {
            this.updateApproximationError();
        }
        for (int i = 0; i < this.maxIterations; ++i) {
            this.U.zMult(this.U, (DoubleMatrix2D)T, 1.0, 0.0, true, false);
            this.A.zMult(this.U, (DoubleMatrix2D)VT1, 1.0, 0.0, true, false);
            this.V.zMult((DoubleMatrix2D)T, (DoubleMatrix2D)VT2, 1.0, 0.0, false, false);
            VT1.assign(plusEps);
            VT2.assign(plusEps);
            VT1.assign((DoubleMatrix2D)VT2, Functions.DIV);
            this.V.assign((DoubleMatrix2D)VT1, Functions.MULT);
            this.V.zMult(this.V, (DoubleMatrix2D)T, 1.0, 0.0, true, false);
            this.A.zMult(this.V, (DoubleMatrix2D)UT1, 1.0, 0.0, false, false);
            this.U.zMult((DoubleMatrix2D)T, (DoubleMatrix2D)UT2, 1.0, 0.0, false, false);
            UT1.assign(plusEps);
            UT2.assign(plusEps);
            UT1.assign((DoubleMatrix2D)UT2, Functions.DIV);
            this.U.assign((DoubleMatrix2D)UT1, Functions.MULT);
            ++this.iterationsCompleted;
            if (this.stopThreshold >= 0.0 && this.updateApproximationError()) break;
        }
        if (this.ordered) {
            this.order();
        }
    }

    public String toString() {
        return "NMF-ED-" + this.seedingStrategy.toString();
    }
}

