/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.pool;

import com.google.common.collect.Maps;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.carrot2.util.Pair;
import org.carrot2.util.pool.IActivationListener;
import org.carrot2.util.pool.IDisposalListener;
import org.carrot2.util.pool.IInstantiationListener;
import org.carrot2.util.pool.IParameterizedPool;
import org.carrot2.util.pool.IPassivationListener;

public final class SoftUnboundedPool<T, P>
implements IParameterizedPool<T, P> {
    private Map<Pair<Class<? extends T>, P>, List<SoftReference<T>>> instances = Maps.newHashMap();
    private IInstantiationListener<T, P> instantiationListener;
    private IActivationListener<T, P> activationListener;
    private IPassivationListener<T, P> passivationListener;
    private IDisposalListener<T, P> disposalListener;

    @Override
    public void init(IInstantiationListener<T, P> objectInstantiationListener, IActivationListener<T, P> objectActivationListener, IPassivationListener<T, P> objectPassivationListener, IDisposalListener<T, P> objectDisposalListener) {
        this.instantiationListener = objectInstantiationListener;
        this.activationListener = objectActivationListener;
        this.passivationListener = objectPassivationListener;
        this.disposalListener = objectDisposalListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I extends T> I borrowObject(Class<I> clazz, P parameter) throws InstantiationException, IllegalAccessException {
        Object instance = null;
        SoftUnboundedPool softUnboundedPool = this;
        synchronized (softUnboundedPool) {
            if (this.instances == null) {
                throw new IllegalStateException("The pool has already been disposed of");
            }
            Pair<Class<Class<I>>, P> key = new Pair<Class<Class<I>>, P>(clazz, parameter);
            List<SoftReference<T>> list = this.instances.get(key);
            if (list == null) {
                list = new ArrayList<SoftReference<T>>();
                this.instances.put(key, list);
            }
            while (list.size() > 0 && instance == null) {
                instance = list.remove(0).get();
            }
        }
        if (instance == null) {
            instance = clazz.newInstance();
            if (this.instantiationListener != null) {
                this.instantiationListener.objectInstantiated(instance, parameter);
            }
        }
        if (this.activationListener != null) {
            this.activationListener.activate(instance, parameter);
        }
        return (I)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(T object, P parameter) {
        if (object == null) {
            return;
        }
        if (this.passivationListener != null) {
            this.passivationListener.passivate(object, parameter);
        }
        SoftUnboundedPool softUnboundedPool = this;
        synchronized (softUnboundedPool) {
            if (this.instances == null) {
                return;
            }
            Pair key = new Pair(object.getClass(), parameter);
            List<SoftReference<T>> list = this.instances.get(key);
            if (list == null) {
                throw new IllegalStateException("Returning an object that was never borrowed: " + object);
            }
            for (SoftReference<T> reference : list) {
                T o = reference.get();
                if (o == null || o != object) continue;
                throw new IllegalStateException("Object has not been borrowed");
            }
            list.add(new SoftReference<T>(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        SoftUnboundedPool softUnboundedPool = this;
        synchronized (softUnboundedPool) {
            if (this.instances == null) {
                return;
            }
            Map<Pair<Class<T>, P>, List<SoftReference<T>>> instancesRef = this.instances;
            this.instances = null;
            for (Map.Entry<Pair<Class<T>, P>, List<SoftReference<T>>> entry : instancesRef.entrySet()) {
                for (SoftReference<T> reference : entry.getValue()) {
                    T instance = reference.get();
                    if (instance == null || this.disposalListener == null) continue;
                    this.disposalListener.dispose(instance, entry.getKey().objectB);
                }
            }
        }
    }
}

