/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBaseExtendedShape;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoMembershipShape;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoConvexPolygon
extends GeoBaseExtendedShape
implements GeoMembershipShape {
    protected final List<GeoPoint> points;
    protected final BitSet isInternalEdges;
    protected SidedPlane[] edges = null;
    protected boolean[] internalEdges = null;
    protected GeoPoint[][] notableEdgePoints = null;
    protected GeoPoint[] edgePoints = null;
    protected double fullDistance = 0.0;

    public GeoConvexPolygon(List<GeoPoint> pointList) {
        this.points = pointList;
        this.isInternalEdges = null;
        this.donePoints(false);
    }

    public GeoConvexPolygon(List<GeoPoint> pointList, BitSet internalEdgeFlags, boolean returnEdgeInternal) {
        this.points = pointList;
        this.isInternalEdges = internalEdgeFlags;
        this.donePoints(returnEdgeInternal);
    }

    public GeoConvexPolygon(double startLatitude, double startLongitude) {
        this.points = new ArrayList<GeoPoint>();
        this.isInternalEdges = new BitSet();
        if (startLatitude > 1.5707963267948966 || startLatitude < -1.5707963267948966) {
            throw new IllegalArgumentException("Latitude out of range");
        }
        if (startLongitude < -Math.PI || startLongitude > Math.PI) {
            throw new IllegalArgumentException("Longitude out of range");
        }
        GeoPoint p = new GeoPoint(startLatitude, startLongitude);
        this.points.add(p);
    }

    public void addPoint(double latitude, double longitude, boolean isInternalEdge) {
        if (latitude > 1.5707963267948966 || latitude < -1.5707963267948966) {
            throw new IllegalArgumentException("Latitude out of range");
        }
        if (longitude < -Math.PI || longitude > Math.PI) {
            throw new IllegalArgumentException("Longitude out of range");
        }
        GeoPoint p = new GeoPoint(latitude, longitude);
        this.isInternalEdges.set(this.points.size(), isInternalEdge);
        this.points.add(p);
    }

    public void donePoints(boolean isInternalReturnEdge) {
        if (this.points.size() < 3) {
            throw new IllegalArgumentException("Polygon needs at least three points.");
        }
        this.edges = new SidedPlane[this.points.size()];
        this.notableEdgePoints = new GeoPoint[this.points.size()][];
        this.internalEdges = new boolean[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            SidedPlane sp;
            GeoPoint start = this.points.get(i);
            boolean isInternalEdge = this.isInternalEdges != null ? (i == this.isInternalEdges.size() ? isInternalReturnEdge : this.isInternalEdges.get(i)) : false;
            GeoPoint end = this.points.get(this.legalIndex(i + 1));
            double distance = start.arcDistance(end);
            if (distance > this.fullDistance) {
                this.fullDistance = distance;
            }
            GeoPoint check = this.points.get(this.legalIndex(i + 2));
            this.edges[i] = sp = new SidedPlane((Vector)check, (Vector)start, end);
            this.notableEdgePoints[i] = new GeoPoint[]{start, end};
            this.internalEdges[i] = isInternalEdge;
        }
        this.createCenterPoint();
    }

    protected void createCenterPoint() {
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            for (int pointIndex = 0; pointIndex < this.points.size(); ++pointIndex) {
                if (pointIndex == edgeIndex || pointIndex == this.legalIndex(edgeIndex + 1) || edge.isWithin(this.points.get(pointIndex))) continue;
                throw new IllegalArgumentException("Polygon is not convex: Point " + this.points.get(pointIndex) + " Edge " + edge);
            }
        }
        this.edgePoints = new GeoPoint[]{this.points.get(0)};
    }

    protected int legalIndex(int index) {
        while (index >= this.points.size()) {
            index -= this.points.size();
        }
        return index;
    }

    @Override
    public boolean isWithin(Vector point) {
        for (SidedPlane edge : this.edges) {
            if (edge.isWithin(point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (SidedPlane edge : this.edges) {
            if (edge.isWithin(x, y, z)) continue;
            return false;
        }
        return true;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            GeoPoint[] points = this.notableEdgePoints[edgeIndex];
            if (this.internalEdges[edgeIndex]) continue;
            Membership[] membershipBounds = new Membership[this.edges.length - 1];
            int count = 0;
            for (int otherIndex = 0; otherIndex < this.edges.length; ++otherIndex) {
                if (otherIndex == edgeIndex) continue;
                membershipBounds[count++] = this.edges[otherIndex];
            }
            if (!edge.intersects(p, notablePoints, points, bounds, membershipBounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        bounds = super.getBounds(bounds);
        for (GeoPoint point : this.points) {
            bounds.addPoint(point);
        }
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            Membership[] membershipBounds = new Membership[this.edges.length - 1];
            int count = 0;
            for (int otherIndex = 0; otherIndex < this.edges.length; ++otherIndex) {
                if (otherIndex == edgeIndex) continue;
                membershipBounds[count++] = this.edges[otherIndex];
            }
            edge.recordBounds(bounds, membershipBounds);
        }
        if (this.fullDistance >= Math.PI) {
            bounds.noLongitudeBound();
        }
        return bounds;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoConvexPolygon)) {
            return false;
        }
        GeoConvexPolygon other = (GeoConvexPolygon)o;
        if (other.points.size() != this.points.size()) {
            return false;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            if (other.points.get(i).equals(this.points.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public String toString() {
        StringBuilder edgeString = new StringBuilder("{");
        for (int i = 0; i < this.edges.length; ++i) {
            edgeString.append(this.edges[i]).append(" internal? ").append(this.internalEdges[i]).append("; ");
        }
        edgeString.append("}");
        return "GeoConvexPolygon: {points=" + this.points + " edges=" + edgeString + "}";
    }
}

