/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import javax.script.ScriptException;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.base.Fields;
import org.kitesdk.morphline.scriptengine.java.ScriptEvaluator;
import org.slf4j.Logger;

public final class JavaBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("java");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        try {
            return new Java(this, config, parent, child, context);
        }
        catch (ScriptException e) {
            throw new MorphlineCompilationException("Cannot compile script", config, e);
        }
    }

    private static final class Java
    extends AbstractCommand {
        private final ScriptEvaluator<Boolean> script;
        private static final String DEFAULT_IMPORTS = "import java.util.*;\nimport java.io.*;\nimport java.text.*;\nimport com.google.common.base.*;\nimport com.google.common.collect.*;\nimport " + Record.class.getPackage().getName() + ".*;\n" + "import " + Fields.class.getName() + ";\n" + "import " + Configs.class.getName() + ";\n" + "";

        public Java(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) throws ScriptException {
            super(builder, config, parent, child, context);
            String javaImports = this.getConfigs().getString(config, "imports", DEFAULT_IMPORTS);
            String javaCodeBlock = this.getConfigs().getString(config, "code");
            this.script = new ScriptEvaluator<Boolean>(javaImports, javaCodeBlock, Boolean.class, new String[]{"record", "config", "parent", "child", "context", "logger"}, new Class[]{Record.class, Config.class, Command.class, Command.class, MorphlineContext.class, Logger.class}, javaCodeBlock);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            try {
                return this.script.evaluate(record, this.getConfig(), this, this.getChild(), this.getContext(), this.LOG);
            }
            catch (ScriptException e) {
                throw new MorphlineRuntimeException("Cannot execute script", e);
            }
        }
    }
}

