/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.modify.UpdateEngine;
import com.hp.hpl.jena.sparql.modify.UpdateEngineFactory;
import com.hp.hpl.jena.sparql.modify.UpdateSink;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import org.apache.jena.atlas.iterator.Iter;

public class UpdateProcessorBase
implements UpdateProcessor {
    protected final UpdateRequest request;
    protected final GraphStore graphStore;
    protected final Binding inputBinding;
    protected final UpdateEngineFactory factory;
    protected final Context context;

    public UpdateProcessorBase(UpdateRequest request, GraphStore graphStore, Binding inputBinding, Context context, UpdateEngineFactory factory) {
        this.request = request;
        this.graphStore = graphStore;
        this.inputBinding = inputBinding;
        this.context = Context.setupContext(context, graphStore);
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        UpdateEngine uProc = this.factory.create(this.graphStore, this.inputBinding, this.context);
        uProc.startRequest();
        try {
            UpdateSink sink = uProc.getUpdateSink();
            Iter.sendToSink(this.request, sink);
        }
        finally {
            uProc.finishRequest();
        }
    }

    @Override
    public GraphStore getGraphStore() {
        return this.graphStore;
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

