/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.bookkeeper.api.Customer;
import org.dataone.bookkeeper.config.DataONEConfiguration;
import org.dataone.bookkeeper.jdbi.CustomerStore;
import org.dataone.client.auth.AuthTokenSession;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.jdbi.v3.core.Jdbi;

public class DataONEAuthHelper {
    private Log log = LogFactory.getLog(DataONEAuthHelper.class);
    private String cnBaseUrl;
    private String cnIdentityServiceEndpoint;
    private CustomerStore customerStore;
    private Environment environment;
    private DataONEConfiguration configuration;
    private CNode cn;
    private RSAPublicKey cnPublicKey;

    public DataONEAuthHelper() {
    }

    public DataONEAuthHelper(Environment environment, Jdbi database, DataONEConfiguration configuration) {
        this.environment = environment;
        this.customerStore = (CustomerStore)database.onDemand(CustomerStore.class);
        this.configuration = configuration;
    }

    public String getCnBaseUrl() {
        return this.cnBaseUrl;
    }

    public void setCnBaseUrl(String cnBaseUrl) {
        this.cnBaseUrl = cnBaseUrl;
    }

    public String getCnIdentityServiceEndpoint() {
        return this.cnIdentityServiceEndpoint;
    }

    public void setCnIdentityServiceEndpoint(String cnIdentityServiceEndpoint) {
        this.cnIdentityServiceEndpoint = cnIdentityServiceEndpoint;
    }

    public CustomerStore getCustomerStore() {
        return this.customerStore;
    }

    public void setCustomerStore(CustomerStore customerStore) {
        this.customerStore = customerStore;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public DataONEConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DataONEConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean verify(String token) throws AuthenticationException {
        boolean verified = false;
        try {
            D1Client.setCN((String)this.configuration.getCnBaseUrl());
            URL cnBaseUrl = new URL(D1Client.getCN().getNodeBaseServiceUrl());
            HttpsURLConnection connection = (HttpsURLConnection)cnBaseUrl.openConnection();
            connection.connect();
            Certificate cnCertificate = connection.getServerCertificates()[0];
            if (cnCertificate != null) {
                this.log.debug((Object)("Verifying token with CN certificate: " + cnCertificate.toString()));
                this.cnPublicKey = (RSAPublicKey)cnCertificate.getPublicKey();
                SignedJWT signedJWT = SignedJWT.parse((String)token);
                RSASSAVerifier jwsVerifier = new RSASSAVerifier(this.cnPublicKey);
                if (!signedJWT.verify((JWSVerifier)jwsVerifier)) {
                    this.log.debug((Object)("Verifying token with public key: " + this.cnPublicKey));
                    this.log.warn((Object)("Couldn't verify token with CN public key: " + token));
                    return verified;
                }
                ZonedDateTime now = ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("UTC"));
                this.log.debug((Object)now);
                ZonedDateTime expiration = ZonedDateTime.ofInstant(signedJWT.getJWTClaimsSet().getExpirationTime().toInstant(), ZoneId.of("UTC"));
                this.log.debug((Object)expiration);
                if (now.isAfter(expiration)) {
                    this.log.warn((Object)("The token has expired: " + expiration));
                } else {
                    verified = true;
                }
            } else {
                this.log.error((Object)"Couldn't verify token.  The CN certificate is null.");
            }
        }
        catch (NotImplemented notImplemented) {
            String message = "Couldn't verify the token. The CN returned a NotImplemented: " + notImplemented.getMessage();
            this.log.warn((Object)message);
            throw new AuthenticationException(message);
        }
        catch (ServiceFailure serviceFailure) {
            String message = "Couldn't verify the token. The CN returned a ServiceFailure: " + serviceFailure.getMessage();
            this.log.warn((Object)message);
            throw new AuthenticationException(message);
        }
        catch (MalformedURLException mue) {
            String message = "Couldn't verify the token. The CN URL is malformed: " + mue.getMessage();
            this.log.warn((Object)message);
            throw new AuthenticationException(message);
        }
        catch (IOException ioe) {
            String message = "Couldn't verify the token. The CN returned connection failed: " + ioe.getMessage();
            this.log.warn((Object)message);
            throw new AuthenticationException(message);
        }
        catch (ParseException e) {
            String message = "Couldn't verify the token. The JWT library returned a parse exception: " + e.getMessage();
            this.log.warn((Object)message);
            throw new AuthenticationException(message);
        }
        catch (JOSEException je) {
            String message = "Couldn't verify the token. The JWT library returned an exception: " + je.getMessage();
            this.log.warn((Object)message);
            throw new AuthenticationException(message);
        }
        this.log.debug((Object)("Token is verified: " + verified));
        return verified;
    }

    public SubjectInfo getSubjectInfo(String token, String subject) throws BaseException {
        SubjectInfo subjectInfo = null;
        AuthTokenSession session = new AuthTokenSession(token);
        Subject d1Subject = new Subject();
        d1Subject.setValue(subject);
        session.setSubject(d1Subject);
        D1Client.setCN((String)this.configuration.getCnBaseUrl());
        this.cn = D1Client.getCN();
        subjectInfo = this.cn.getSubjectInfo((Session)session, session.getSubject());
        return subjectInfo;
    }

    public String getTokenSubject(String token) throws ParseException {
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        return signedJWT.getJWTClaimsSet().getSubject();
    }

    public Customer createCustomerFromSubject(String subject) throws AuthenticationException {
        Customer customer = null;
        String errorMessage = "Couldn't get subject information from the Coordinating Node: ";
        customer = new Customer();
        customer.setSubject(subject);
        SubjectInfo subjectInfo = null;
        try {
            subjectInfo = this.getSubjectInfo(null, customer.getSubject());
        }
        catch (BaseException e) {
            errorMessage = "Couldn't retrieve subject from DataONE: '" + customer.getSubject() + "'.";
            AuthenticationException ae = new AuthenticationException(errorMessage);
            ae.initCause((Throwable)e);
            throw ae;
        }
        customer.setSubjectInfo(subjectInfo);
        return customer;
    }

    public Customer getCustomerWithSubjectInfo(String token) throws AuthenticationException {
        Customer customer = null;
        String errorMessage = "Couldn't get subject information from the Coordinating Node: ";
        String subject = null;
        try {
            subject = this.getTokenSubject(token);
            customer = this.getCustomerStore().findCustomerBySubject(subject);
            if (customer == null) {
                this.log.info((Object)("A customer record doesn't exist yet for " + subject + ". Creating a new customer."));
                customer = new Customer();
                customer.setSubject(subject);
            }
        }
        catch (ParseException e) {
            errorMessage = "Couldn't parse the given token: ";
            throw new AuthenticationException(errorMessage + e.getMessage());
        }
        SubjectInfo subjectInfo = null;
        try {
            subjectInfo = this.getSubjectInfo(token, customer.getSubject());
        }
        catch (BaseException e) {
            errorMessage = "Couldn't retrieve subject from DataONE: '" + customer.getSubject() + "'.";
            AuthenticationException ae = new AuthenticationException(errorMessage);
            ae.initCause((Throwable)e);
            throw ae;
        }
        customer.setSubjectInfo(subjectInfo);
        return customer;
    }

    public boolean isAdmin(String subject) {
        return this.getConfiguration().getAdminSubjects().contains(subject);
    }

    public boolean isBookkeeperAdmin(String subject) {
        return this.getConfiguration().getBookkeeperAdminSubjects().contains(subject);
    }

    public Set<String> filterByAssociatedSubjects(Customer customer, Set<String> subjects) {
        SubjectInfo subjectInfo = customer.getSubjectInfo();
        HashSet<String> associatedSubjects = new HashSet<String>();
        if (subjectInfo != null) {
            List groups = subjectInfo.getGroupList();
            List persons = subjectInfo.getPersonList();
            block0: for (String subject : subjects) {
                for (Group group : groups) {
                    if (!group.getSubject().getValue().equals(subject)) continue;
                    associatedSubjects.add(subject);
                    break;
                }
                for (Person person : persons) {
                    if (!person.getSubject().getValue().equals(subject)) continue;
                    associatedSubjects.add(subject);
                    continue block0;
                }
            }
        }
        return associatedSubjects;
    }

    public Set<String> getAssociatedSubjects(Customer customer) {
        SubjectInfo subjectInfo = customer.getSubjectInfo();
        HashSet<String> associatedSubjects = new HashSet<String>();
        if (subjectInfo != null) {
            List groups = subjectInfo.getGroupList();
            List persons = subjectInfo.getPersonList();
            for (Group group : groups) {
                associatedSubjects.add(group.getSubject().getValue());
            }
            for (Person person : persons) {
                associatedSubjects.add(person.getSubject().getValue());
            }
        }
        return associatedSubjects;
    }
}

