/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.download;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ecoinformatics.datamanager.download.ArchivedDataHandler;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.parser.Entity;

public class TarDataHandler
extends ArchivedDataHandler {
    protected TarDataHandler(Entity entity, String url, EcogridEndPointInterface endPoint) {
        super(entity, url, endPoint);
    }

    protected TarDataHandler(String url, EcogridEndPointInterface endPoint) {
        super(url, endPoint);
    }

    public static TarDataHandler getTarHandlerInstance(Entity entity, String url, EcogridEndPointInterface endPoint) {
        TarDataHandler tarHandler = (TarDataHandler)TarDataHandler.getHandlerFromHash(url);
        if (tarHandler == null) {
            tarHandler = new TarDataHandler(entity, url, endPoint);
        }
        return tarHandler;
    }

    @Override
    protected boolean writeRemoteInputStreamIntoDataStorage(InputStream in) throws IOException {
        boolean success = false;
        TarInputStream tarInputStream = null;
        if (in == null) {
            return success;
        }
        try {
            tarInputStream = new TarInputStream(in);
            TarEntry entry = tarInputStream.getNextEntry();
            int index = 0;
            while (entry != null && index < 1) {
                if (entry.isDirectory()) {
                    entry = tarInputStream.getNextEntry();
                    continue;
                }
                success = super.writeRemoteInputStreamIntoDataStorage((InputStream)tarInputStream);
                ++index;
            }
        }
        catch (IOException e) {
            String errorMsg = String.format("%s %s: %s", "Error reading from the data source.", "Error downloading tar file", e.getMessage());
            throw new IOException(errorMsg);
        }
        return success;
    }

    @Override
    protected boolean getContentFromEcoGridSource(String endPoint, String ecogridIdentifier) {
        boolean success = false;
        File zipTmp = this.writeEcoGridArchivedDataIntoTmp(endPoint, ecogridIdentifier, ".tar");
        try {
            if (zipTmp != null) {
                FileInputStream stream = new FileInputStream(zipTmp);
                success = this.writeRemoteInputStreamIntoDataStorage(stream);
            }
        }
        catch (Exception e) {
            System.out.println("Error is " + e.getMessage());
        }
        return success;
    }
}

