/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.XMLNamespaceConfig;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.IPostProcessor;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementAdd;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathDocumentParser {
    public String index = null;
    private String solrBaseUri = null;
    private String solrindexUri = null;
    private String solrQueryUri = null;
    private List<SolrField> fields = null;
    private List<IDocumentSubprocessor> subprocessors = null;
    private XMLNamespaceConfig xmlNamespaceConfig = null;
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder builder = null;
    private static XPathFactory xpathFactory = null;
    private static XPath xpath = null;
    private static final String OUTPUT_ENCODING = "UTF-8";
    private static final String INPUT_ENCODING = "UTF-8";
    private HTTPService httpService = null;
    Log log = LogFactory.getLog(XPathDocumentParser.class);
    private List<IPostProcessor> postProcessors = new ArrayList<IPostProcessor>();
    long startTime = 0L;

    public XPathDocumentParser(XMLNamespaceConfig xmlNamespaceConfig, List<SolrField> fields) throws XPathExpressionException, ParserConfigurationException {
        this.xmlNamespaceConfig = xmlNamespaceConfig;
        this.fields = fields;
        this.init();
    }

    public void init() throws ParserConfigurationException, XPathExpressionException {
        xpath.setNamespaceContext(this.xmlNamespaceConfig);
        this.initExpressions();
    }

    private void initExpressions() throws XPathExpressionException {
        for (SolrField field : this.getFields()) {
            field.initExpression(xpath);
        }
    }

    public SolrDoc processID(String id, String sysMetaPath, String objectPath) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException {
        Document sysMetaDoc = this.loadDocument(sysMetaPath, "UTF-8");
        if (sysMetaDoc == null) {
            this.log.error((Object)("Could not load System metadata for ID: " + id));
            return null;
        }
        List<SolrElementField> sysSolrFields = this.processFields(sysMetaDoc, id);
        SolrDoc indexDocument = new SolrDoc(sysSolrFields);
        Map<String, SolrDoc> docs = new HashMap<String, SolrDoc>();
        docs.put(id, indexDocument);
        if (this.subprocessors != null) {
            for (IDocumentSubprocessor subprocessor : this.subprocessors) {
                if (!subprocessor.canProcess(sysMetaDoc)) continue;
                try {
                    Document docObject = this.loadDocument(objectPath, "UTF-8");
                    if (docObject == null) {
                        this.log.error((Object)("Could not load OBJECT file for ID,Path=" + id + ", " + objectPath));
                        continue;
                    }
                    docs = subprocessor.processDocument(id, docs, docObject);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getStackTrace().toString());
                }
            }
        }
        for (SolrDoc mergeDoc : docs.values()) {
            if (mergeDoc.isMerged()) continue;
            this.mergeWithIndexedDocument(mergeDoc);
        }
        SolrElementAdd addCommand = this.getAddCommand(new ArrayList<SolrDoc>(docs.values()));
        if (this.log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            addCommand.serialize((OutputStream)baos, "UTF-8");
            this.log.trace((Object)baos.toString());
        }
        this.sendCommand(addCommand);
        if (docs.size() > 0) {
            docs.clear();
        }
        return indexDocument;
    }

    public SolrDoc process(String id, InputStream systemMetaDataStream, String objectPath) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException {
        Document sysMetaDoc = this.generateSystemMetadataDoc(systemMetaDataStream);
        if (sysMetaDoc == null) {
            this.log.error((Object)("Could not load System metadata for ID: " + id));
            return null;
        }
        List<SolrElementField> sysSolrFields = this.processFields(sysMetaDoc, id);
        SolrDoc indexDocument = new SolrDoc(sysSolrFields);
        Map<String, SolrDoc> docs = new HashMap<String, SolrDoc>();
        docs.put(id, indexDocument);
        if (this.subprocessors != null) {
            for (IDocumentSubprocessor subprocessor : this.subprocessors) {
                if (!subprocessor.canProcess(sysMetaDoc)) continue;
                try {
                    Document docObject = this.loadDocument(objectPath, "UTF-8");
                    if (docObject == null) {
                        this.log.error((Object)("Could not load OBJECT file for ID,Path=" + id + ", " + objectPath));
                        continue;
                    }
                    docs = subprocessor.processDocument(id, docs, docObject);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getStackTrace().toString());
                }
            }
        }
        for (SolrDoc mergeDoc : docs.values()) {
            if (mergeDoc.isMerged()) continue;
            this.mergeWithIndexedDocument(mergeDoc);
        }
        SolrElementAdd addCommand = this.getAddCommand(new ArrayList<SolrDoc>(docs.values()));
        if (this.log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            addCommand.serialize((OutputStream)baos, "UTF-8");
            this.log.trace((Object)baos.toString());
        }
        this.sendCommand(addCommand);
        return indexDocument;
    }

    private SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        SolrDoc indexedDocument;
        if (this.httpService == null) {
            return indexDocument;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(indexDocument.getIdentifier());
        List<SolrDoc> indexedDocuments = this.httpService.getDocuments(this.solrQueryUri, ids);
        SolrDoc solrDoc = indexedDocument = indexedDocuments == null || indexedDocuments.size() <= 0 ? null : indexedDocuments.get(0);
        if (indexedDocument == null || indexedDocument.getFieldList().size() <= 0) {
            return indexDocument;
        }
        for (SolrElementField field : indexedDocument.getFieldList()) {
            if (!field.getName().equals("isDocumentedBy") && !field.getName().equals("documents") && !field.getName().equals("resourcemap") || indexDocument.hasFieldWithValue(field.getName(), field.getValue())) continue;
            indexDocument.addField(field);
        }
        indexDocument.setMerged(true);
        return indexDocument;
    }

    private void sendCommand(SolrElementAdd addCommand) throws IOException {
        HTTPService service = this.getHttpService();
        try {
            service.sendUpdate(this.getSolrindexUri(), addCommand, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SolrElementAdd getAddCommand(List<SolrDoc> docs) {
        return new SolrElementAdd(docs);
    }

    private List<SolrElementField> processFields(Document doc, String identifier) {
        ArrayList<SolrElementField> fieldList = new ArrayList<SolrElementField>();
        List<SolrField> solrFields = this.getFields();
        for (SolrField field : solrFields) {
            try {
                fieldList.addAll(field.getFields(doc, identifier));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fieldList;
    }

    public Document loadDocument(String filePath) throws ParserConfigurationException, IOException, SAXException {
        return this.loadDocument(filePath, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadDocument(String filePath, String input_encoding) throws ParserConfigurationException, IOException, SAXException {
        Document doc = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(filePath);
            isr = new InputStreamReader((InputStream)fis, input_encoding);
            InputSource source = new InputSource(isr);
            doc = builder.parse(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)("Error parsing file: " + filePath));
        }
        finally {
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return doc;
    }

    public Document generateSystemMetadataDoc(InputStream smdStream) {
        Document doc = null;
        try {
            doc = builder.parse(smdStream);
        }
        catch (SAXException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return doc;
    }

    public XMLNamespaceConfig getXmlNamespaceConfig() {
        return this.xmlNamespaceConfig;
    }

    public void setXmlNamespaceConfig(XMLNamespaceConfig xmlNamespaceConfig) {
        this.xmlNamespaceConfig = xmlNamespaceConfig;
    }

    public List<SolrField> getFields() {
        return this.fields;
    }

    public void setFields(List<SolrField> fields) {
        this.fields = fields;
    }

    public String getSolrindexUri() {
        return this.solrindexUri;
    }

    public void setSolrindexUri(String solrindexUri) {
        this.solrindexUri = solrindexUri;
    }

    public void setHttpService(HTTPService service) {
        this.httpService = service;
    }

    public HTTPService getHttpService() {
        return this.httpService;
    }

    public String getSolrQueryUri() {
        return this.solrQueryUri;
    }

    public void setSolrQueryUri(String solrQueryUri) {
        this.solrQueryUri = solrQueryUri;
    }

    public void setSolrBaseUri(String solrBaseUri) {
        this.solrBaseUri = solrBaseUri;
        this.setSolrQueryUri(solrBaseUri + "/select/");
        this.setSolrindexUri(solrBaseUri + "/update?commit=true");
    }

    public String getSolrBaseUri() {
        return this.solrBaseUri;
    }

    public List<IDocumentSubprocessor> getSubprocessors() {
        return this.subprocessors;
    }

    public void setSubprocessors(List<IDocumentSubprocessor> subprocessorList) {
        for (IDocumentSubprocessor subprocessor : subprocessorList) {
            subprocessor.initExpression(xpath);
        }
        this.subprocessors = subprocessorList;
    }

    public static DocumentBuilder getDocumentBuilder() {
        return builder;
    }

    public void setPostProcessors(List<IPostProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    static {
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        xpathFactory = XPathFactory.newInstance();
        xpath = xpathFactory.newXPath();
    }
}

