/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class FifoCache {
    private static int DEFAULT_CAPACITY = 8;
    private int capacity = 0;
    private List keys;
    private Hashtable objects;

    public FifoCache() {
        this(DEFAULT_CAPACITY);
    }

    public FifoCache(int capacity) {
        this.capacity = capacity;
        this.keys = new ArrayList(capacity);
        this.objects = new Hashtable();
    }

    public void add(String identifier, Object o) {
        if (this.objects.containsKey(identifier)) {
            this.objects.put(identifier, o);
            return;
        }
        if (this.keys.size() >= this.capacity) {
            this.remove();
        }
        this.keys.add(identifier);
        this.objects.put(identifier, o);
    }

    public Object get() {
        return this.objects.get(this.keys.get(0));
    }

    public Object get(String identifier) {
        return this.objects.get(identifier);
    }

    public void remove() {
        String identifier = (String)this.keys.remove(0);
        this.objects.remove(identifier);
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }
}

