/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.jdbi;

import java.util.List;
import org.dataone.bookkeeper.api.Customer;
import org.dataone.bookkeeper.jdbi.mappers.CustomerMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindMethods;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface CustomerStore {
    public static final String SELECT_CLAUSE = "SELECT c.id AS c_id, c.object AS c_object, c.subject AS c_subject, c.balance AS c_balance, c.address AS c_address, date_part('epoch', c.created)::int AS c_created, c.currency AS c_currency, c.delinquent AS c_delinquent, c.description AS c_description, c.discount::json AS c_discount, c.email AS c_email, c.invoicePrefix AS c_invoicePrefix, c.invoiceSettings::json AS c_invoiceSettings, c.metadata::json AS c_metadata, c.givenName AS c_givenName, c.surName AS c_surName, c.phone AS c_phone FROM customers c ";
    public static final String ORDER_CLAUSE = "ORDER BY c.surName, c.givenName ";
    public static final String SELECT_ALL = "SELECT c.id AS c_id, c.object AS c_object, c.subject AS c_subject, c.balance AS c_balance, c.address AS c_address, date_part('epoch', c.created)::int AS c_created, c.currency AS c_currency, c.delinquent AS c_delinquent, c.description AS c_description, c.discount::json AS c_discount, c.email AS c_email, c.invoicePrefix AS c_invoicePrefix, c.invoiceSettings::json AS c_invoiceSettings, c.metadata::json AS c_metadata, c.givenName AS c_givenName, c.surName AS c_surName, c.phone AS c_phone FROM customers c ORDER BY c.surName, c.givenName ";
    public static final String SELECT_ONE = "SELECT c.id AS c_id, c.object AS c_object, c.subject AS c_subject, c.balance AS c_balance, c.address AS c_address, date_part('epoch', c.created)::int AS c_created, c.currency AS c_currency, c.delinquent AS c_delinquent, c.description AS c_description, c.discount::json AS c_discount, c.email AS c_email, c.invoicePrefix AS c_invoicePrefix, c.invoiceSettings::json AS c_invoiceSettings, c.metadata::json AS c_metadata, c.givenName AS c_givenName, c.surName AS c_surName, c.phone AS c_phone FROM customers c WHERE c.id = :id";
    public static final String SELECT_SUBJECT = "SELECT c.id AS c_id, c.object AS c_object, c.subject AS c_subject, c.balance AS c_balance, c.address AS c_address, date_part('epoch', c.created)::int AS c_created, c.currency AS c_currency, c.delinquent AS c_delinquent, c.description AS c_description, c.discount::json AS c_discount, c.email AS c_email, c.invoicePrefix AS c_invoicePrefix, c.invoiceSettings::json AS c_invoiceSettings, c.metadata::json AS c_metadata, c.givenName AS c_givenName, c.surName AS c_surName, c.phone AS c_phone FROM customers c WHERE c.subject = :subject";
    public static final String SELECT_EMAIL = "SELECT c.id AS c_id, c.object AS c_object, c.subject AS c_subject, c.balance AS c_balance, c.address AS c_address, date_part('epoch', c.created)::int AS c_created, c.currency AS c_currency, c.delinquent AS c_delinquent, c.description AS c_description, c.discount::json AS c_discount, c.email AS c_email, c.invoicePrefix AS c_invoicePrefix, c.invoiceSettings::json AS c_invoiceSettings, c.metadata::json AS c_metadata, c.givenName AS c_givenName, c.surName AS c_surName, c.phone AS c_phone FROM customers c WHERE c.email = :email";

    @SqlQuery(value="SELECT c.id AS c_id, c.object AS c_object, c.subject AS c_subject, c.balance AS c_balance, c.address AS c_address, date_part('epoch', c.created)::int AS c_created, c.currency AS c_currency, c.delinquent AS c_delinquent, c.description AS c_description, c.discount::json AS c_discount, c.email AS c_email, c.invoicePrefix AS c_invoicePrefix, c.invoiceSettings::json AS c_invoiceSettings, c.metadata::json AS c_metadata, c.givenName AS c_givenName, c.surName AS c_surName, c.phone AS c_phone FROM customers c ORDER BY c.surName, c.givenName ")
    @RegisterRowMapper(value=CustomerMapper.class)
    public List<Customer> listCustomers();

    @SqlQuery(value="SELECT c.id AS c_id, c.object AS c_object, c.subject AS c_subject, c.balance AS c_balance, c.address AS c_address, date_part('epoch', c.created)::int AS c_created, c.currency AS c_currency, c.delinquent AS c_delinquent, c.description AS c_description, c.discount::json AS c_discount, c.email AS c_email, c.invoicePrefix AS c_invoicePrefix, c.invoiceSettings::json AS c_invoiceSettings, c.metadata::json AS c_metadata, c.givenName AS c_givenName, c.surName AS c_surName, c.phone AS c_phone FROM customers c WHERE c.id = :id")
    @RegisterRowMapper(value=CustomerMapper.class)
    public Customer getCustomer(@Bind(value="id") Integer var1);

    @SqlQuery(value="SELECT c.id AS c_id, c.object AS c_object, c.subject AS c_subject, c.balance AS c_balance, c.address AS c_address, date_part('epoch', c.created)::int AS c_created, c.currency AS c_currency, c.delinquent AS c_delinquent, c.description AS c_description, c.discount::json AS c_discount, c.email AS c_email, c.invoicePrefix AS c_invoicePrefix, c.invoiceSettings::json AS c_invoiceSettings, c.metadata::json AS c_metadata, c.givenName AS c_givenName, c.surName AS c_surName, c.phone AS c_phone FROM customers c WHERE c.subject = :subject")
    @RegisterRowMapper(value=CustomerMapper.class)
    public Customer findCustomerBySubject(@Bind(value="subject") String var1);

    @SqlQuery(value="SELECT c.id AS c_id, c.object AS c_object, c.subject AS c_subject, c.balance AS c_balance, c.address AS c_address, date_part('epoch', c.created)::int AS c_created, c.currency AS c_currency, c.delinquent AS c_delinquent, c.description AS c_description, c.discount::json AS c_discount, c.email AS c_email, c.invoicePrefix AS c_invoicePrefix, c.invoiceSettings::json AS c_invoiceSettings, c.metadata::json AS c_metadata, c.givenName AS c_givenName, c.surName AS c_surName, c.phone AS c_phone FROM customers c WHERE c.email = :email")
    @RegisterRowMapper(value=CustomerMapper.class)
    public Customer findCustomerByEmail(@Bind(value="email") String var1);

    @SqlUpdate(value="INSERT INTO customers (object, subject, balance, address, created, currency, delinquent, description, discount, email, invoicePrefix, invoiceSettings, metadata, givenName, surName, phone) VALUES (:getObject, :getSubject, :getBalance, :getAddressJSON::json, to_timestamp(:getCreated), :getCurrency, :isDelinquent, :getDescription, :getDiscountJSON::json, :getEmail, :getInvoicePrefix, :getInvoiceSettingsJSON::json, :getMetadataJSON::json, :getGivenName, :getSurName, :getPhone) RETURNING id")
    @GetGeneratedKeys
    public Integer insert(@BindMethods Customer var1);

    @SqlUpdate(value="UPDATE customers SET object = :getObject, subject = :getSubject, balance = :getBalance, address = :getAddressJSON::json, created = to_timestamp(:getCreated), currency = :getCurrency, delinquent = :isDelinquent, description = :getDescription, discount = :getDiscountJSON::json, email = :getEmail, invoicePrefix = :getInvoicePrefix, invoiceSettings = :getInvoiceSettingsJSON::json, metadata = :getMetadataJSON::json, givenName = :getGivenName, surName = :getSurName, phone = :getPhone RETURNING id")
    @GetGeneratedKeys
    public Integer update(@BindMethods Customer var1);

    @SqlUpdate(value="DELETE FROM customers WHERE id = :id")
    public void delete(@Bind(value="id") Integer var1);
}

