/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.download.AuthenticatedEcogridEndPointInterface;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.AuthenticatedQueryServiceGetToStreamClient;
import org.ecoinformatics.ecogrid.queryservice.QueryServiceGetToStreamClient;

public class DocumentHandler {
    public static Log log = LogFactory.getLog(DocumentHandler.class);
    private String docId = null;
    private EcogridEndPointInterface ecogridEndPointInterface = null;
    private PipedInputStream inputStream = null;
    private PipedOutputStream outputStream = new PipedOutputStream();

    public DocumentHandler() {
        this.inputStream = new PipedInputStream();
        try {
            this.outputStream.connect(this.inputStream);
        }
        catch (IOException e1) {
            log.error((Object)("could not connect piped streams! " + e1.getMessage()));
            e1.printStackTrace();
        }
    }

    public InputStream downloadDocument() throws Exception {
        log.info((Object)"starting the download");
        boolean success = true;
        final String id = this.docId;
        final EcogridEndPointInterface endpoint = this.ecogridEndPointInterface;
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                try {
                    if (DocumentHandler.this.ecogridEndPointInterface instanceof AuthenticatedEcogridEndPointInterface) {
                        AuthenticatedQueryServiceGetToStreamClient authenticatedEcogridClient = new AuthenticatedQueryServiceGetToStreamClient(new URL(((AuthenticatedEcogridEndPointInterface)endpoint).getMetacatAuthenticatedEcogridEndPoint()));
                        authenticatedEcogridClient.get(id, ((AuthenticatedEcogridEndPointInterface)endpoint).getSessionId(), (OutputStream)DocumentHandler.this.outputStream);
                    } else {
                        QueryServiceGetToStreamClient ecogridClient = new QueryServiceGetToStreamClient(new URL(endpoint.getMetacatEcogridEndPoint()));
                        ecogridClient.get(id, (OutputStream)DocumentHandler.this.outputStream);
                    }
                    DocumentHandler.this.outputStream.close();
                    long endTime = System.currentTimeMillis();
                    log.debug((Object)(endTime - startTime + " ms to download: " + DocumentHandler.this.docId));
                    log.debug((Object)("Done downloading id=" + id));
                }
                catch (Exception e) {
                    log.error((Object)("Error getting document from ecogrid: " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        });
        service.shutdown();
        service.awaitTermination(0L, TimeUnit.SECONDS);
        return this.inputStream;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public EcogridEndPointInterface getEcogridEndPointInterface() {
        return this.ecogridEndPointInterface;
    }

    public void setEcogridEndPointInterface(EcogridEndPointInterface ecogridEndPointInterface) {
        this.ecogridEndPointInterface = ecogridEndPointInterface;
    }
}

