/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.dataone.cn.indexer.convert.SolrDateConverter;
import org.dataone.cn.indexer.parser.AbstractPostProcessor;
import org.dataone.cn.indexer.parser.IPostProcessor;
import org.dataone.cn.indexer.solrhttp.SolrDoc;

public class DecadePostProcessor
extends AbstractPostProcessor
implements IPostProcessor {
    @Override
    public Map<String, SolrDoc> process(String identifier, Map<String, SolrDoc> docMap) {
        for (SolrDoc solrDoc : docMap.values()) {
            String decadeString;
            int year;
            if (!this.match(solrDoc)) continue;
            String beginDate = solrDoc.getFirstFieldValue("beginDate");
            String endDate = solrDoc.getFirstFieldValue("endDate");
            Date beginDateValue = beginDate == null || beginDate.length() <= 0 ? null : SolrDateConverter.ParseSolrDate(beginDate);
            Date endDateValue = endDate == null || endDate.length() <= 0 ? null : SolrDateConverter.ParseSolrDate(endDate);
            Calendar beginDateCal = null;
            Calendar endDateCal = null;
            if (beginDateValue != null) {
                beginDateCal = Calendar.getInstance();
                beginDateCal.setTime(beginDateValue);
            }
            if (endDateValue != null) {
                endDateCal = Calendar.getInstance();
                endDateCal.setTime(endDateValue);
            }
            if (endDateCal != null) {
                year = endDateCal.get(1);
                decadeString = this.getDecadeString(year);
                solrDoc.updateOrAddField("decade", decadeString);
                continue;
            }
            if (beginDateValue != null) {
                year = endDateCal.get(1);
                decadeString = this.getDecadeString(year);
                solrDoc.updateOrAddField("decade", decadeString);
                continue;
            }
            solrDoc.updateOrAddField("decade", "Unknown");
        }
        return docMap;
    }

    private String getDecadeString(int year) {
        int decadeBegin = year - year % 10;
        int decadeEnd = year + 9;
        return decadeBegin + " to " + decadeEnd;
    }
}

