/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser.utility;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LeafElement {
    private String name;
    private String xPath;
    private XPathExpression xPathExpression;
    private String delimiter = " ";

    public void initXPathExpression(XPath xPathObject) {
        try {
            this.xPathExpression = xPathObject.compile(this.xPath);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public String getLeafValue(Node node) throws XPathExpressionException {
        StringBuilder value = new StringBuilder();
        NodeList nodeList = (NodeList)this.getxPathExpression().evaluate(node, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node textNode = nodeList.item(i);
            if (textNode.getNodeValue() == null) continue;
            value.append(textNode.getNodeValue().trim());
            value.append(this.getDelimiter());
        }
        return StringUtils.removeEnd((String)value.toString().trim(), (String)this.delimiter);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getxPath() {
        return this.xPath;
    }

    public void setxPath(String xPath) {
        this.xPath = xPath;
    }

    public XPathExpression getxPathExpression() {
        return this.xPathExpression;
    }

    public void setxPathExpression(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

