/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.FileSystemBased;
import org.apache.commons.configuration.Lock;
import org.apache.commons.configuration.VerifiableOutputStream;
import org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFileConfiguration
extends BaseConfiguration
implements FileConfiguration,
FileSystemBased {
    public static final int EVENT_RELOAD = 20;
    public static final int EVENT_CONFIG_CHANGED = 21;
    private static final String FILE_SCHEME = "file:";
    protected String fileName;
    protected String basePath;
    protected boolean autoSave;
    protected ReloadingStrategy strategy;
    protected Object reloadLock = new Lock("AbstractFileConfiguration");
    private String encoding;
    private URL sourceURL;
    private int noReload;
    private FileSystem fileSystem = FileSystem.getDefaultFileSystem();

    public AbstractFileConfiguration() {
        this.initReloadingStrategy();
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    public AbstractFileConfiguration(String fileName) throws ConfigurationException {
        this();
        this.setFileName(fileName);
        this.load();
    }

    public AbstractFileConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public AbstractFileConfiguration(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
        this.load();
    }

    public void setFileSystem(FileSystem fileSystem) {
        if (fileSystem == null) {
            throw new NullPointerException("A valid FileSystem must be specified");
        }
        this.fileSystem = fileSystem;
    }

    public void resetFileSystem() {
        this.fileSystem = FileSystem.getDefaultFileSystem();
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Object getReloadLock() {
        return this.reloadLock;
    }

    public void load() throws ConfigurationException {
        if (this.sourceURL != null) {
            this.load(this.sourceURL);
        } else {
            this.load(this.getFileName());
        }
    }

    public void load(String fileName) throws ConfigurationException {
        try {
            URL url = ConfigurationUtils.locate(this.fileSystem, this.basePath, fileName);
            if (url == null) {
                throw new ConfigurationException("Cannot locate configuration source " + fileName);
            }
            this.load(url);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load the configuration file " + fileName, e);
        }
    }

    public void load(File file) throws ConfigurationException {
        try {
            this.load(ConfigurationUtils.toURL(file));
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load the configuration file " + file, e);
        }
    }

    public void load(URL url) throws ConfigurationException {
        if (this.sourceURL == null) {
            if (StringUtils.isEmpty((String)this.getBasePath())) {
                this.setBasePath(url.toString());
            }
            this.sourceURL = url;
        }
        InputStream in = null;
        try {
            in = this.fileSystem.getInputStream(url);
            this.load(in);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load the configuration from the URL " + url, e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.getLogger().warn((Object)"Could not close input stream", (Throwable)e);
            }
        }
    }

    public void load(InputStream in) throws ConfigurationException {
        this.load(in, this.getEncoding());
    }

    public void load(InputStream in, String encoding) throws ConfigurationException {
        InputStreamReader reader = null;
        if (encoding != null) {
            try {
                reader = new InputStreamReader(in, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", e);
            }
        }
        if (reader == null) {
            reader = new InputStreamReader(in);
        }
        this.load(reader);
    }

    public void save() throws ConfigurationException {
        if (this.getFileName() == null) {
            throw new ConfigurationException("No file name has been set!");
        }
        if (this.sourceURL != null) {
            this.save(this.sourceURL);
        } else {
            this.save(this.fileName);
        }
        this.strategy.init();
    }

    public void save(String fileName) throws ConfigurationException {
        try {
            URL url = this.fileSystem.getURL(this.basePath, fileName);
            if (url == null) {
                throw new ConfigurationException("Cannot locate configuration source " + fileName);
            }
            this.save(url);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to save the configuration to the file " + fileName, e);
        }
    }

    public void save(URL url) throws ConfigurationException {
        OutputStream out = null;
        try {
            out = this.fileSystem.getOutputStream(url);
            this.save(out);
            if (out instanceof VerifiableOutputStream) {
                ((VerifiableOutputStream)out).verify();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not save to URL " + url, e);
        }
        finally {
            this.closeSilent(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws ConfigurationException {
        OutputStream out = null;
        try {
            out = this.fileSystem.getOutputStream(file);
            this.save(out);
        }
        finally {
            this.closeSilent(out);
        }
    }

    public void save(OutputStream out) throws ConfigurationException {
        this.save(out, this.getEncoding());
    }

    public void save(OutputStream out, String encoding) throws ConfigurationException {
        OutputStreamWriter writer = null;
        if (encoding != null) {
            try {
                writer = new OutputStreamWriter(out, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", e);
            }
        }
        if (writer == null) {
            writer = new OutputStreamWriter(out);
        }
        this.save(writer);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (fileName != null && fileName.startsWith(FILE_SCHEME) && !fileName.startsWith("file://")) {
            fileName = "file://" + fileName.substring(FILE_SCHEME.length());
        }
        this.sourceURL = null;
        this.fileName = fileName;
        this.getLogger().debug((Object)("FileName set to " + fileName));
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        if (basePath != null && basePath.startsWith(FILE_SCHEME) && !basePath.startsWith("file://")) {
            basePath = "file://" + basePath.substring(FILE_SCHEME.length());
        }
        this.sourceURL = null;
        this.basePath = basePath;
        this.getLogger().debug((Object)("Base path set to " + basePath));
    }

    public File getFile() {
        if (this.getFileName() == null && this.sourceURL == null) {
            return null;
        }
        if (this.sourceURL != null) {
            return ConfigurationUtils.fileFromURL(this.sourceURL);
        }
        return ConfigurationUtils.getFile(this.getBasePath(), this.getFileName());
    }

    public void setFile(File file) {
        this.sourceURL = null;
        this.setFileName(file.getName());
        this.setBasePath(file.getParentFile() != null ? file.getParentFile().getAbsolutePath() : null);
    }

    public String getPath() {
        return this.fileSystem.getPath(this.getFile(), this.sourceURL, this.getBasePath(), this.getFileName());
    }

    public void setPath(String path) {
        this.setFile(new File(path));
    }

    URL getSourceURL() {
        return this.sourceURL;
    }

    public URL getURL() {
        return this.sourceURL != null ? this.sourceURL : ConfigurationUtils.locate(this.fileSystem, this.getBasePath(), this.getFileName());
    }

    public void setURL(URL url) {
        this.setBasePath(ConfigurationUtils.getBasePath(url));
        this.setFileName(ConfigurationUtils.getFileName(url));
        this.sourceURL = url;
        this.getLogger().debug((Object)("URL set to " + url));
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    protected void possiblySave() {
        if (this.autoSave && this.fileName != null) {
            try {
                this.save();
            }
            catch (ConfigurationException e) {
                throw new ConfigurationRuntimeException("Failed to auto-save", (Throwable)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String key, Object value) {
        Object object = this.reloadLock;
        synchronized (object) {
            super.addProperty(key, value);
            this.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        Object object = this.reloadLock;
        synchronized (object) {
            super.setProperty(key, value);
            this.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperty(String key) {
        Object object = this.reloadLock;
        synchronized (object) {
            super.clearProperty(key);
            this.possiblySave();
        }
    }

    public ReloadingStrategy getReloadingStrategy() {
        return this.strategy;
    }

    public void setReloadingStrategy(ReloadingStrategy strategy) {
        this.strategy = strategy;
        strategy.setConfiguration(this);
        strategy.init();
    }

    public void reload() {
        this.reload(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reload(boolean checkReload) {
        Object object = this.reloadLock;
        synchronized (object) {
            if (this.noReload != 0) return true;
            try {
                this.enterNoReload();
                if (!this.strategy.reloadingRequired()) return true;
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info((Object)("Reloading configuration. URL is " + this.getURL()));
                }
                this.refresh();
                this.strategy.reloadingPerformed();
            }
            catch (Exception e) {
                this.fireError(20, null, null, e);
                if (!checkReload) return true;
                boolean bl = false;
                return bl;
            }
            finally {
                this.exitNoReload();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws ConfigurationException {
        this.fireEvent(20, null, this.getURL(), true);
        this.setDetailEvents(false);
        boolean autoSaveBak = this.isAutoSave();
        this.setAutoSave(false);
        try {
            this.clear();
            this.load();
        }
        finally {
            this.setAutoSave(autoSaveBak);
            this.setDetailEvents(true);
        }
        this.fireEvent(20, null, this.getURL(), false);
    }

    public void configurationChanged() {
        this.fireEvent(21, null, this.getURL(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enterNoReload() {
        Object object = this.reloadLock;
        synchronized (object) {
            ++this.noReload;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitNoReload() {
        Object object = this.reloadLock;
        synchronized (object) {
            if (this.noReload > 0) {
                --this.noReload;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(int type, String propName, Object propValue, boolean before) {
        this.enterNoReload();
        try {
            super.fireEvent(type, propName, propValue, before);
        }
        finally {
            this.exitNoReload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        Object object = this.reloadLock;
        synchronized (object) {
            this.reload();
            return super.getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.reload();
        Object object = this.reloadLock;
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        this.reload();
        Object object = this.reloadLock;
        synchronized (object) {
            return super.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKeys() {
        this.reload();
        LinkedList keyList = new LinkedList();
        this.enterNoReload();
        try {
            Iterator it = super.getKeys();
            while (it.hasNext()) {
                keyList.add(it.next());
            }
            Iterator iterator = keyList.iterator();
            return iterator;
        }
        finally {
            this.exitNoReload();
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Object clone() {
        AbstractFileConfiguration copy = (AbstractFileConfiguration)super.clone();
        copy.setBasePath(null);
        copy.setFileName(null);
        copy.initReloadingStrategy();
        return copy;
    }

    private void initReloadingStrategy() {
        this.setReloadingStrategy(new InvariantReloadingStrategy());
    }

    protected void closeSilent(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            this.getLogger().warn((Object)"Could not close output stream", (Throwable)e);
        }
    }
}

