/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import org.ecoinformatics.datamanager.database.GroupBy;
import org.ecoinformatics.datamanager.database.SelectionItem;
import org.ecoinformatics.datamanager.database.TableItem;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;
import org.ecoinformatics.datamanager.database.WhereClause;

public class Query {
    private SelectionItem[] selectionList = null;
    private TableItem[] tableList = null;
    private WhereClause whereClause = null;
    private GroupBy groupBy = null;
    private boolean distinct = false;
    private static final String SELECT = "SELECT";
    private static final String DISTINCT = "DISTINCT";
    private static final String FROM = "FROM";
    public static final String SEMICOLON = ";";
    public static final String COMMA = ",";

    public void addSelectionItem(SelectionItem selection) {
        if (this.selectionList == null) {
            this.selectionList = new SelectionItem[1];
            this.selectionList[0] = selection;
        } else {
            int size = this.selectionList.length;
            SelectionItem[] copy = this.selectionList;
            this.selectionList = new SelectionItem[size + 1];
            for (int i = 0; i < size; ++i) {
                this.selectionList[i] = copy[i];
            }
            this.selectionList[size] = selection;
        }
    }

    public void addTableItem(TableItem table) {
        if (this.containsTableItem(table)) {
            return;
        }
        if (this.tableList == null) {
            this.tableList = new TableItem[1];
            this.tableList[0] = table;
        } else {
            int size = this.tableList.length;
            TableItem[] copy = this.tableList;
            this.tableList = new TableItem[size + 1];
            for (int i = 0; i < size; ++i) {
                this.tableList[i] = copy[i];
            }
            this.tableList[size] = table;
        }
    }

    public boolean containsTableItem(TableItem table) {
        if (this.tableList != null) {
            int size = this.tableList.length;
            for (int i = 0; i < size; ++i) {
                if (!this.tableList[i].equals(table)) continue;
                return true;
            }
        }
        return false;
    }

    public SelectionItem[] getSelectionList() {
        return this.selectionList;
    }

    public void setWhereClause(WhereClause where) {
        this.whereClause = where;
    }

    public void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public String toSQLString() throws UnWellFormedQueryException {
        if (this.selectionList == null || this.tableList == null) {
            throw new UnWellFormedQueryException("Selection item or FROM table item is null in query");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(SELECT);
        sql.append(" ");
        if (this.distinct) {
            sql.append(DISTINCT);
            sql.append(" ");
        }
        int selectionLength = this.selectionList.length;
        boolean firstSelection = true;
        for (int i = 0; i < selectionLength; ++i) {
            SelectionItem selection = this.selectionList[i];
            if (firstSelection) {
                sql.append(selection.toSQLString());
                firstSelection = false;
                continue;
            }
            sql.append(COMMA);
            sql.append(selection.toSQLString());
        }
        sql.append(" ");
        sql.append(FROM);
        sql.append(" ");
        boolean firstFrom = true;
        for (TableItem tableItem : this.tableList) {
            if (firstFrom) {
                sql.append(tableItem.toSQLString());
                firstFrom = false;
                continue;
            }
            sql.append(COMMA);
            sql.append(tableItem.toSQLString());
        }
        if (this.whereClause != null) {
            sql.append(" ");
            sql.append(this.whereClause.toSQLString());
        }
        if (this.groupBy != null) {
            sql.append(" ");
            sql.append(this.groupBy.toSQLString());
        }
        sql.append(SEMICOLON);
        return sql.toString();
    }
}

