/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.parser;

import org.ecoinformatics.datamanager.parser.Constraint;
import org.ecoinformatics.datamanager.parser.UnWellFormedConstraintException;

public class ForeignKey
implements Constraint {
    private int type = 2;
    private String name = null;
    private String[] keys = null;
    private String entityReference = null;

    @Override
    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public String getEntityReference() {
        return this.entityReference;
    }

    public void setName(String constraintName) {
        this.name = constraintName;
    }

    public void setKeys(String[] constraintKeys) {
        this.keys = constraintKeys;
    }

    public void setEntityReference(String referencedEntity) {
        this.entityReference = referencedEntity;
    }

    @Override
    public String printString() throws UnWellFormedConstraintException {
        String sql = null;
        if (this.name == null || this.name.trim().equals("")) {
            throw new UnWellFormedConstraintException("No Constraint name assign to Primary key");
        }
        if (this.keys == null || this.keys.length == 0) {
            throw new UnWellFormedConstraintException("No key is specified in primary key");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        buffer.append("CONSTRAINT");
        buffer.append(" ");
        buffer.append(this.name);
        buffer.append(" ");
        buffer.append("FOREIGN KEY");
        buffer.append(" ");
        buffer.append("(");
        boolean firstKey = true;
        for (int i = 0; i < this.keys.length; ++i) {
            String keyName = this.keys[i];
            if (keyName == null || keyName.trim().equals("")) {
                throw new UnWellFormedConstraintException("key name empty or null in foreign key");
            }
            if (!firstKey) {
                buffer.append(",");
            }
            buffer.append(keyName);
            firstKey = false;
        }
        buffer.append(")");
        buffer.append(" ");
        buffer.append("REFERENCES");
        buffer.append(" ");
        buffer.append(this.entityReference);
        buffer.append(" ");
        sql = buffer.toString();
        return sql;
    }
}

