/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Import
extends SvnCommand {
    private ISVNClientAdapter svnClient = null;
    private SVNUrl url = null;
    private File path = null;
    private String message = null;
    private boolean recurse = true;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.validateAttributes();
        this.log("Svn : Importing to repository");
        try {
            iSVNClientAdapter.doImport(this.path, this.url, this.message, this.recurse);
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Can't import", (Throwable)sVNClientException);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.url == null || this.path == null) {
            throw new BuildException("url and path attributes must be set");
        }
        if (this.message == null) {
            throw new BuildException("message attribute must be set");
        }
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }
}

