/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.DatabaseAdapter;
import org.ecoinformatics.datamanager.database.DatabaseHandler;
import org.ecoinformatics.datamanager.parser.Entity;

public class TableMonitor {
    private DatabaseAdapter dbAdapter = null;
    private final String DATA_TABLE_REGISTRY = "DATA_TABLE_REGISTRY";
    private final int DEFAULT_DB_SIZE = 100;
    private int dbSize = 100;

    public TableMonitor(DatabaseAdapter dbAdapter) throws SQLException {
        this.dbAdapter = dbAdapter;
        if (!this.isTableInDB("DATA_TABLE_REGISTRY")) {
            this.createDataTableRegistry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addTableEntry(Entity entity) throws SQLException {
        String entityIdentifier = entity.getEntityIdentifier();
        String entityName = entity.getName();
        String packageId = entity.getPackageId();
        Date now = new Date();
        String priority = "1";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Statement stmt = null;
        String tableName = this.assignTableName(entityIdentifier, entityName);
        boolean inUse = this.isDBTableNameInUse(tableName);
        if (inUse) {
            this.setLastUsageDate(tableName, now);
        } else {
            String insertString = "INSERT INTO DATA_TABLE_REGISTRY values('" + tableName + "', '" + packageId + "', '" + entityIdentifier + "', '" + entityName + "', '" + simpleDateFormat.format(now) + "', '" + simpleDateFormat.format(now) + "', " + priority + ")";
            Connection connection = DataManager.getConnection();
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate(insertString);
            }
            catch (SQLException e) {
                System.err.println("Error inserting record for " + tableName + " into the data table registry (" + "DATA_TABLE_REGISTRY" + ")");
                System.err.println("SQLException: " + e.getMessage());
                tableName = null;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                DataManager.returnConnection(connection);
            }
        }
        entity.setDBTableName(tableName);
        return tableName;
    }

    String assignTableName(String entityIdentifier, String entityName) throws SQLException {
        Connection connection = DataManager.getConnection();
        String tableName = null;
        String selectString = "SELECT TABLE_NAME, ENTITY_IDENTIFIER, ENTITY_NAME FROM DATA_TABLE_REGISTRY WHERE ENTITY_IDENTIFIER='" + entityIdentifier + "' AND ENTITY_NAME='" + entityName + "'";
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                tableName = rs.getString("table_name");
            }
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        if (tableName == null) {
            String tableNameCandidate = DatabaseAdapter.getLegalDBTableName(entityName);
            while (tableName == null) {
                if (this.isDBTableNameInUse(tableNameCandidate)) {
                    tableNameCandidate = this.mangleName(tableNameCandidate);
                    continue;
                }
                tableName = tableNameCandidate;
            }
        }
        return tableName;
    }

    public int countRows(String tableName) throws SQLException {
        int rowCount = -1;
        if (this.isTableInDB(tableName)) {
            String selectString = this.dbAdapter.getCountingRowNumberSQL(tableName);
            Statement stmt = null;
            Connection connection = DataManager.getConnection();
            try {
                stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery(selectString);
                while (rs.next()) {
                    rowCount = rs.getInt("count");
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                System.err.println("SQLException: " + e.getMessage());
                throw e;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                DataManager.returnConnection(connection);
            }
        }
        return rowCount;
    }

    private void createDataTableRegistry() throws SQLException {
        Connection connection = DataManager.getConnection();
        String createString = "create table DATA_TABLE_REGISTRY (  TABLE_NAME varchar(64),   PACKAGE_ID varchar(64),   ENTITY_IDENTIFIER varchar(256),   ENTITY_NAME varchar(256),   CREATION_DATE date,   LAST_USAGE_DATE date,   PRIORITY int)";
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createString);
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
    }

    public boolean dropTableEntry(String tableName) throws SQLException {
        Connection connection = DataManager.getConnection();
        boolean success = false;
        int rowCount = -1;
        Statement stmt = null;
        String deleteString = "DELETE FROM DATA_TABLE_REGISTRY WHERE TABLE_NAME='" + tableName + "'";
        try {
            stmt = connection.createStatement();
            rowCount = stmt.executeUpdate(deleteString);
            success = rowCount == 1;
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        return success;
    }

    public int freeTableSpace(DatabaseHandler databaseHandler) throws SQLException {
        int freedSpace = 0;
        return freedSpace;
    }

    public Date getCreationDate(String tableName) throws SQLException {
        Connection connection = DataManager.getConnection();
        java.sql.Date creationDate = null;
        String selectString = "SELECT creation_date FROM DATA_TABLE_REGISTRY WHERE table_name='" + tableName + "'";
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                creationDate = rs.getDate("creation_date");
            }
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        return creationDate;
    }

    public String[] getDBFieldNames(String packageID, String entityName) throws SQLException {
        String catalog = null;
        String columnNamePattern = "%";
        DatabaseMetaData databaseMetaData = null;
        String[] fieldNames = null;
        String schemaPattern = null;
        String tableName = this.getDBTableName(packageID, entityName);
        if (tableName != null) {
            String fieldName;
            Vector<String> vector = new Vector<String>();
            Connection connection = DataManager.getConnection();
            String tableNamePattern = tableName.toUpperCase();
            databaseMetaData = connection.getMetaData();
            ResultSet rs = databaseMetaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            while (rs.next()) {
                fieldName = rs.getString("COLUMN_NAME");
                vector.add(fieldName);
            }
            if (vector.size() == 0) {
                if (rs != null) {
                    rs.close();
                }
                tableNamePattern = tableName.toLowerCase();
                rs = databaseMetaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
                while (rs.next()) {
                    fieldName = rs.getString("COLUMN_NAME");
                    vector.add(fieldName);
                }
            }
            fieldNames = new String[vector.size()];
            for (int i = 0; i < fieldNames.length; ++i) {
                fieldNames[i] = (String)vector.elementAt(i);
            }
            if (rs != null) {
                rs.close();
            }
            DataManager.returnConnection(connection);
            String QUOTE = "\"";
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName2 = fieldNames[i];
                if (fieldName2 == null) continue;
                if (!fieldName2.startsWith("\"")) {
                    fieldName2 = "\"" + fieldName2;
                }
                if (!fieldName2.endsWith("\"")) {
                    fieldName2 = fieldName2 + "\"";
                }
                fieldNames[i] = fieldName2;
            }
        }
        return fieldNames;
    }

    public String getDBTableName(String packageID, String entityName) throws SQLException {
        String tableName = null;
        Connection connection = DataManager.getConnection();
        String selectString = "SELECT table_name FROM DATA_TABLE_REGISTRY WHERE package_id ='" + packageID + "'   AND entity_name ='" + entityName + "'";
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            if (rs.next()) {
                tableName = rs.getString("table_name");
            }
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        return tableName;
    }

    public ArrayList<String> getDBTableNames(String packageID) throws SQLException {
        ArrayList<String> tableNames = null;
        if (packageID != null) {
            tableNames = new ArrayList<String>();
            Connection connection = DataManager.getConnection();
            String selectString = "SELECT table_name FROM DATA_TABLE_REGISTRY WHERE package_id ='" + packageID + "'";
            Statement stmt = null;
            try {
                stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery(selectString);
                while (rs.next()) {
                    String tableName = rs.getString("table_name");
                    tableNames.add(tableName);
                }
            }
            catch (SQLException e) {
                System.err.println("SQLException: " + e.getMessage());
                throw e;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                DataManager.returnConnection(connection);
            }
        }
        return tableNames;
    }

    public String getDataTableRegistryName() {
        return "DATA_TABLE_REGISTRY";
    }

    public Date getLastUsageDate(String tableName) throws SQLException {
        Connection connection = DataManager.getConnection();
        java.sql.Date lastUsageDate = null;
        String selectString = "SELECT last_usage_date FROM DATA_TABLE_REGISTRY WHERE table_name='" + tableName + "'";
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                lastUsageDate = rs.getDate("last_usage_date");
            }
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        return lastUsageDate;
    }

    String getOldestTable() throws SQLException {
        Connection connection = DataManager.getConnection();
        Date oldestDate = new Date();
        String oldestTable = null;
        String selectString = "SELECT table_name, last_usage_date FROM DATA_TABLE_REGISTRY";
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                String tableName = rs.getString("table_name");
                java.sql.Date lastUsageDate = rs.getDate("last_usage_date");
                if (!lastUsageDate.before(oldestDate)) continue;
                oldestDate = lastUsageDate;
                oldestTable = tableName;
            }
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        return oldestTable;
    }

    public String[] getTableList() throws SQLException {
        Connection connection = DataManager.getConnection();
        String selectString = "SELECT table_name FROM DATA_TABLE_REGISTRY";
        Statement stmt = null;
        Vector<String> vector = new Vector<String>();
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                String tableName = rs.getString("table_name");
                vector.add(tableName);
            }
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        String[] tableList = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            tableList[i] = (String)vector.get(i);
        }
        return tableList;
    }

    String identifierToTableName(String identifier) throws SQLException {
        Connection connection = DataManager.getConnection();
        String tableName = null;
        String selectString = "SELECT table_name FROM DATA_TABLE_REGISTRY WHERE entity_identifier='" + identifier + "'";
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                tableName = rs.getString("table_name");
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        return tableName;
    }

    boolean isDBTableNameInUse(String tableName) throws SQLException {
        boolean inUse = false;
        String[] tableNames = this.getTableList();
        for (int i = 0; i < tableNames.length; ++i) {
            if (!tableNames[i].equalsIgnoreCase(tableName)) continue;
            inUse = true;
            break;
        }
        return inUse;
    }

    public boolean isTableInDB(String tableName) throws SQLException {
        String catalog = null;
        Connection connection = DataManager.getConnection();
        DatabaseMetaData databaseMetaData = null;
        boolean isPresent = false;
        String schemaPattern = null;
        String tableNamePattern = "%";
        String[] types = new String[]{"TABLE"};
        databaseMetaData = connection.getMetaData();
        ResultSet rs = databaseMetaData.getTables(catalog, schemaPattern, tableNamePattern, types);
        while (rs.next()) {
            String TABLE_NAME = rs.getString("TABLE_NAME");
            if (!TABLE_NAME.equalsIgnoreCase(tableName)) continue;
            isPresent = true;
        }
        if (rs != null) {
            rs.close();
        }
        DataManager.returnConnection(connection);
        return isPresent;
    }

    String mangleName(String tableName) {
        int tailInt = 0;
        String patternMatch = "_XYZYX_";
        String rootName = tableName;
        int index = tableName.indexOf(patternMatch);
        if (index > -1) {
            String tail = tableName.substring(index + patternMatch.length());
            Integer tailInteger = Integer.valueOf(tail);
            tailInt = tailInteger;
            rootName = tableName.substring(0, index);
        }
        String mangledName = rootName + patternMatch + ++tailInt;
        return mangledName;
    }

    public void setDBSize(int size) {
        int minSize = 1;
        this.dbSize = size < minSize ? minSize : size;
    }

    public boolean setLastUsageDate(String tableName, Date date) throws SQLException {
        Connection connection = DataManager.getConnection();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = simpleDateFormat.format(date);
        int rowCount = 0;
        Statement stmt = null;
        boolean success = false;
        String updateString = "UPDATE DATA_TABLE_REGISTRY SET last_usage_date='" + dateString + "' WHERE table_name='" + tableName + "'";
        try {
            stmt = connection.createStatement();
            rowCount = stmt.executeUpdate(updateString);
            success = rowCount == 1;
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        return success;
    }

    public boolean setTableExpirationPolicy(String tableName, int priority) throws SQLException {
        Connection connection = DataManager.getConnection();
        int rowCount = 0;
        Statement stmt = null;
        boolean success = false;
        String updateString = "UPDATE DATA_TABLE_REGISTRY SET priority=" + priority + " WHERE table_name='" + tableName + "'";
        try {
            stmt = connection.createStatement();
            rowCount = stmt.executeUpdate(updateString);
            success = rowCount == 1;
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DataManager.returnConnection(connection);
        }
        return success;
    }
}

