/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionConfig {
    private PermissionType type;
    private String name;
    private String principal;
    private Set<String> endpoints;
    private Set<String> actions;

    public PermissionConfig() {
    }

    public PermissionConfig(PermissionType type, String name, String principal) {
        this.type = type;
        this.name = name;
        this.principal = principal;
    }

    public PermissionConfig addEndpoint(String endpoint) {
        if (this.endpoints == null) {
            this.endpoints = new HashSet<String>();
        }
        this.endpoints.add(endpoint);
        return this;
    }

    public PermissionConfig addAction(String action) {
        if (this.actions == null) {
            this.actions = new HashSet<String>();
        }
        this.actions.add(action);
        return this;
    }

    public PermissionType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Set<String> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new HashSet<String>();
        }
        return this.endpoints;
    }

    public Set<String> getActions() {
        if (this.actions == null) {
            this.actions = new HashSet<String>();
        }
        return this.actions;
    }

    public void setType(PermissionType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setActions(Set<String> actions) {
        this.actions = actions;
    }

    public void setEndpoints(Set<String> endpoints) {
        this.endpoints = endpoints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PermissionConfig");
        sb.append("{type=").append((Object)this.type);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", principal='").append(this.principal).append('\'');
        sb.append(", endpoints=").append(this.endpoints);
        sb.append(", actions=").append(this.actions);
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PermissionType {
        MAP,
        QUEUE,
        TOPIC,
        MULTIMAP,
        LIST,
        SET,
        ID_GENERATOR,
        LOCK,
        ATOMIC_NUMBER,
        COUNTDOWN_LATCH,
        SEMAPHORE,
        EXECUTOR_SERVICE,
        LISTENER,
        TRANSACTION,
        ALL;

    }
}

