/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.client;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.ServerRedirectException;
import edu.uiuc.ncsa.security.core.exceptions.ServerSideException;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.MapUtilities;
import edu.uiuc.ncsa.security.delegation.client.request.AGRequest;
import edu.uiuc.ncsa.security.delegation.client.request.AGResponse;
import edu.uiuc.ncsa.security.delegation.client.request.ATRequest;
import edu.uiuc.ncsa.security.delegation.client.request.ATResponse;
import edu.uiuc.ncsa.security.delegation.client.server.AGServer;
import edu.uiuc.ncsa.security.delegation.client.server.ATServer;
import edu.uiuc.ncsa.security.delegation.server.UnapprovedClientException;
import edu.uiuc.ncsa.security.delegation.services.AddressableServer;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.services.Response;
import edu.uiuc.ncsa.security.delegation.services.Server;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.impl.AccessTokenImpl;
import edu.uiuc.ncsa.security.delegation.token.impl.AuthorizationGrantImpl;
import edu.uiuc.ncsa.security.delegation.token.impl.VerifierImpl;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthUtilities;
import edu.uiuc.ncsa.security.oauth_1_0a.client.OAClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.client.OAuthClient;
import org.apache.commons.codec.binary.Base64;

public class AuthorizationServerImpl
implements AddressableServer,
AGServer,
ATServer {
    public static final String DEBUG_STACKTRACE_KEY = "stacktrace";
    URI address;

    public URI getAddress() {
        return this.address;
    }

    public AuthorizationServerImpl(URI address) {
        this.address = address;
    }

    public Response process(Request request) {
        return request.process((Server)this);
    }

    public AGResponse processAGRequest(AGRequest agRequest) {
        return this.getAuthorizationGrant(agRequest);
    }

    public ATResponse processATRequest(ATRequest atRequest) {
        return this.getAccessToken(atRequest);
    }

    protected ATResponse getAccessToken(ATRequest atRequest) {
        AccessTokenImpl accessToken = null;
        AuthorizationGrantImpl ag = null;
        VerifierImpl vImpl = null;
        OAClient oaClient = (OAClient)atRequest.getClient();
        OAuthAccessor accessor = OAuthUtilities.createOAuthAccessor(this, oaClient);
        if (!(atRequest.getAuthorizationGrant() instanceof AuthorizationGrantImpl)) {
            throw new GeneralException("Internal Error: Incorrect authorization grant found. Should have been a TempCred but was a " + atRequest.getAuthorizationGrant().getClass());
        }
        ag = (AuthorizationGrantImpl)atRequest.getAuthorizationGrant();
        if (atRequest.getVerifier() == null) {
            throw new GeneralException("Error: No verifier found. This is required by the OAuth spec.");
        }
        if (!(atRequest.getVerifier() instanceof VerifierImpl)) {
            throw new GeneralException("Internal Error: Incorrect verifier instance found. Should have been a VerifierImpl but was a " + atRequest.getVerifier());
        }
        vImpl = (VerifierImpl)atRequest.getVerifier();
        if (ag.getSharedSecret() != null) {
            accessor.tokenSecret = ag.getSharedSecret().toString();
        }
        if (oaClient.getSignatureMethod().equals("RSA-SHA1")) {
            accessor.setProperty("RSA-SHA1.PrivateKey", (Object)oaClient.getSecret());
            accessor.consumer.setProperty("RSA-SHA1.PrivateKey", (Object)oaClient.getSecret());
        }
        try {
            OAuthClient oauthClient = OAuthUtilities.newOAuthClient(this.getAddress());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("oauth_verifier");
            arrayList.add(vImpl.getURIToken().toString());
            for (String key : atRequest.getParameters().keySet()) {
                arrayList.add(key);
                arrayList.add((String)atRequest.getParameters().get(key));
            }
            OAuthMessage message = oauthClient.getAccessToken(accessor, "GET", (Collection)OAuth.newList((String[])arrayList.toArray(new String[arrayList.size()])));
            HashMap m = OAuthUtilities.whittleParameters(message);
            accessToken = new AccessTokenImpl(URI.create(message.getParameter("oauth_token")), URI.create(message.getParameter("oauth_token_secret")));
            ATResponse atr = new ATResponse((AccessToken)accessToken);
            atr.setParameters((Map)m);
            return atr;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected AGResponse getAuthorizationGrant(AGRequest agRequest) {
        List params = MapUtilities.toList((Map)agRequest.getParameters());
        OAClient oac = (OAClient)agRequest.getClient();
        OAuthAccessor accessor = OAuthUtilities.createOAuthAccessor(this, oac);
        if (oac.getSignatureMethod().equals("RSA-SHA1")) {
            accessor.consumer.setProperty("RSA-SHA1.PrivateKey", (Object)oac.getSecret());
            accessor.setProperty("RSA-SHA1.PrivateKey", (Object)oac.getSecret());
        }
        try {
            OAuthClient client = OAuthUtilities.newOAuthClient(this.getAddress());
            OAuthMessage message = client.getRequestTokenResponse(accessor, "GET", (Collection)params);
            String rt = message.getParameter("oauth_token");
            if (rt == null || rt.length() == 0) {
                throw new IllegalArgumentException("Error: delegation server did not return a request token");
            }
            String rtss = message.getParameter("oauth_token_secret");
            if (!(((OAClient)agRequest.getClient()).getSignatureMethod().equals("RSA-SHA1") || rtss != null && rtss.length() != 0)) {
                throw new IllegalArgumentException("Error: delegation server did not return a shared secret");
            }
            AuthorizationGrantImpl agi = new AuthorizationGrantImpl(URI.create(rt), URI.create(rtss));
            AGResponse agr = new AGResponse((AuthorizationGrant)agi);
            HashMap m = OAuthUtilities.whittleParameters(message);
            agr.setParameters((Map)m);
            return agr;
        }
        catch (Throwable e) {
            this.handleException(e);
            return null;
        }
    }

    protected void handleException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof OAuthProblemException) {
            OAuthProblemException opx = (OAuthProblemException)t;
            int status = opx.getHttpStatusCode();
            if (status == 200 && opx.getParameters().containsKey("oauth_parameters_absent") || status == 302) {
                throw new GeneralException("Server attempted to redirect to another page. This is not permitted. Please contact the site administrator");
            }
            if (status == 404) {
                throw new GeneralException("Page not found");
            }
            if (500 <= status) {
                String message = "Server Error -- unknown cause";
                for (String key : opx.getParameters().keySet()) {
                    if (!key.toLowerCase().startsWith("<html>")) continue;
                    message = opx.getParameters().get(key).toString();
                    if (message.contains(UnknownClientException.class.getCanonicalName())) {
                        throw new UnknownClientException("Unknown client. Be sure to register your client.  Is your client id correct?");
                    }
                    if (!message.contains(UnapprovedClientException.class.getCanonicalName())) break;
                    throw new UnapprovedClientException("Your client has been registered, but the administrator has not approved it yet", null);
                }
                throw new GeneralException(message);
            }
            if (opx.getParameters().get("Location") != null) {
                String[] arrParameters;
                ServerSideException sse = new ServerSideException(t);
                String redirect = opx.getParameters().get("Location").toString();
                URI r = URI.create(redirect);
                String query = r.getQuery();
                HashMap<String, String> qparams = new HashMap<String, String>();
                for (String tempParameterString : arrParameters = query.split("&")) {
                    String[] arrTempParameter = tempParameterString.split("=");
                    if (arrTempParameter.length < 2) continue;
                    String parameterKey = arrTempParameter[0];
                    String parameterValue = arrTempParameter[1];
                    if (parameterKey.toLowerCase().equals(DEBUG_STACKTRACE_KEY)) {
                        try {
                            parameterValue = new String(Base64.decodeBase64((String)parameterValue));
                        }
                        catch (Throwable x) {
                            parameterValue = "(none)";
                        }
                    }
                    qparams.put(parameterKey, parameterValue);
                }
                sse.setQueryParameters(qparams);
                sse.setRedirect(r);
                throw sse;
            }
            Map parameters = opx.getParameters();
            if (opx.getHttpStatusCode() == 200 && parameters.containsKey("oauth_parameters_absent")) {
                ServerRedirectException sre = new ServerRedirectException("Server exception with redirect. The server is trying to redirect to an error page, but the OAuth 1.0a libraries cannot process this and fail.");
                for (String v : parameters.keySet()) {
                    if (!v.toLowerCase().startsWith("<html>")) continue;
                    String webpage = v;
                    Object value = parameters.get(v);
                    if (value != null) {
                        webpage = webpage + value.toString();
                    }
                    sre.setWebpage(webpage);
                    throw sre;
                }
                throw sre;
            }
        }
        if (t instanceof SSLPeerUnverifiedException) {
            throw new GeneralException("Error: could not connect to the server. Is your trusted roots store up to date?", t);
        }
        throw new GeneralException("Error invoking OAuth client", t);
    }

    public String toString() {
        return "AuthorizationServerImpl[address=" + this.getAddress() + "]";
    }
}

