/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.dataone.cn.indexer.XMLNamespaceConfig;
import org.dataone.cn.indexer.object.ObjectManager;
import org.dataone.cn.indexer.parser.BaseXPathDocumentSubprocessor;
import org.dataone.cn.indexer.parser.IDocumentDeleteSubprocessor;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.ISolrField;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementAdd;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.xml.sax.SAXException;

public class SolrIndex {
    public static final String ID = "id";
    private static final String IDQUERY = "id:*";
    private static final String VERSION_CONFLICT = "version conflict";
    private static final int VERSION_CONFLICT_MAX_ATTEMPTS = Settings.getConfiguration().getInt("index.solr.versionConflict.max.attempts", 25);
    private static final int VERSION_CONFICT_WAITING = Settings.getConfiguration().getInt("index.solr.versionConflict.waiting.time", 500);
    private static final List<String> resourceMapFormatIdList = Settings.getConfiguration().getList("index.resourcemap.namespace");
    private static List<IDocumentSubprocessor> subprocessors = null;
    private static List<IDocumentDeleteSubprocessor> deleteSubprocessors = null;
    private static SolrClient solrServer = null;
    private static List<String> copyFields = null;
    private static HTTPService httpService = null;
    private String solrQueryUri = Settings.getConfiguration().getString("solr.query.uri");
    private String solrIndexUri = Settings.getConfiguration().getString("solr.index.uri");
    private XMLNamespaceConfig xmlNamespaceConfig = null;
    private static BaseXPathDocumentSubprocessor systemMetadataProcessor = null;
    private List<ISolrField> sysmetaSolrFields = null;
    private static Log log = LogFactory.getLog(SolrIndex.class);

    public SolrIndex(XMLNamespaceConfig xmlNamespaceConfig, BaseXPathDocumentSubprocessor systemMetadataProcessor, HTTPService httpService) throws XPathExpressionException, ParserConfigurationException, IOException, SAXException {
        this.xmlNamespaceConfig = xmlNamespaceConfig;
        SolrIndex.systemMetadataProcessor = systemMetadataProcessor;
        SolrIndex.httpService = httpService;
        this.init();
    }

    private void init() throws ParserConfigurationException, XPathExpressionException {
        this.sysmetaSolrFields = systemMetadataProcessor.getFieldList();
        copyFields = httpService.getSolrCopyFields();
        if (copyFields != null) {
            log.info((Object)("SolrIndex.init - the size of the copy fields from the solr schema is : " + copyFields.size()));
            for (String copyField : copyFields) {
                log.debug((Object)("SolrIndex.init - the copy field from the solr schema: " + copyField));
            }
        } else {
            log.warn((Object)"SolrIndex.init - the size of the copy fields from the solr schema is 0.");
        }
    }

    public List<IDocumentSubprocessor> getSubprocessors() {
        return subprocessors;
    }

    public void setSubprocessors(List<IDocumentSubprocessor> subprocessorList) {
        for (IDocumentSubprocessor subprocessor : subprocessorList) {
            if (!(subprocessor instanceof BaseXPathDocumentSubprocessor)) continue;
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            xpath.setNamespaceContext(this.xmlNamespaceConfig);
            ((BaseXPathDocumentSubprocessor)subprocessor).initExpression(xpath);
        }
        subprocessors = subprocessorList;
    }

    public List<IDocumentDeleteSubprocessor> getDeleteSubprocessors() {
        return deleteSubprocessors;
    }

    public void setDeleteSubprocessors(List<IDocumentDeleteSubprocessor> deleteSubprocessors) {
        SolrIndex.deleteSubprocessors = deleteSubprocessors;
    }

    private Map<String, SolrDoc> process(String id, SystemMetadata systemMetadata, String objectPath, boolean isSysmetaChangeOnly) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, MarshallingException, EncoderException, SolrServerException, NotImplemented, NotFound, UnsupportedType {
        log.debug((Object)("SolrIndex.process - trying to generate the solr doc object for the pid " + id));
        long start = System.currentTimeMillis();
        Map<String, SolrDoc> docs = new HashMap<String, SolrDoc>();
        ByteArrayOutputStream systemMetadataOutputStream = new ByteArrayOutputStream();
        TypeMarshaller.marshalTypeToOutputStream((Object)systemMetadata, (OutputStream)systemMetadataOutputStream);
        ByteArrayInputStream systemMetadataStream = new ByteArrayInputStream(systemMetadataOutputStream.toByteArray());
        try {
            docs = systemMetadataProcessor.processDocument(id, docs, systemMetadataStream);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SolrServerException(e.getMessage());
        }
        long end = System.currentTimeMillis();
        String formatId = docs.get(id).getFirstFieldValue("formatId");
        boolean skipOtherProcessor = false;
        log.debug((Object)("SolrIndex.process - the object format id for the pid " + id + " is " + formatId));
        if (resourceMapFormatIdList.contains(formatId) && isSysmetaChangeOnly) {
            SolrDoc existingResourceMapSolrDoc = httpService.getSolrDocumentById(this.solrQueryUri, id);
            if (existingResourceMapSolrDoc != null) {
                log.info((Object)("SolrIndex.process - This is a systemmetadata-change-only event for the resource map " + id + ". So we only use the system metadata subprocessor"));
                skipOtherProcessor = true;
            } else {
                log.info((Object)("SolrIndex.process - There is no solr doc for the resource map " + id + ". Even though this is a systemmetadata-change-only event, we can NOT just reindex the systemmeta only."));
            }
        }
        log.debug((Object)("SolrIndex.process - the value of skipOtherProcessors is " + skipOtherProcessor + " and the object path is " + objectPath + " for the id " + id));
        if (!skipOtherProcessor && objectPath != null) {
            log.debug((Object)("SolrIndex.process - Start to use subprocessor list to process " + id));
            if (subprocessors != null) {
                for (IDocumentSubprocessor subprocessor : subprocessors) {
                    if (!subprocessor.canProcess(formatId)) continue;
                    try {
                        FileInputStream dataStream = new FileInputStream(objectPath);
                        if (!dataStream.getFD().valid()) {
                            log.error((Object)("SolrIndex.process - subprocessor " + subprocessor.getClass().getName() + " couldn't process since it could not load OBJECT file for ID,Path=" + id + ", " + objectPath));
                            continue;
                        }
                        start = System.currentTimeMillis();
                        docs = subprocessor.processDocument(id, docs, dataStream);
                        end = System.currentTimeMillis();
                        log.info((Object)("SolrIndex.process - the time for calling processDocument for the subprocessor " + subprocessor.getClass().getName() + " for the pid " + id + " is " + (end - start) + "milliseconds."));
                        log.debug((Object)("SolrIndex.process - subprocessor " + subprocessor.getClass().getName() + " generated solr doc for id " + id));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error((Object)e.getMessage(), (Throwable)e);
                        throw new SolrServerException(e.getMessage());
                    }
                }
            }
        }
        for (SolrDoc mergeDoc : docs.values()) {
            if (mergeDoc.isMerged()) continue;
            this.mergeWithIndexedDocument(mergeDoc);
        }
        return docs;
    }

    private SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException, SolrServerException, ParserConfigurationException, SAXException, NotImplemented, NotFound, UnsupportedType {
        SolrDoc indexedDocument = httpService.getSolrDocumentById(this.solrQueryUri, indexDocument.getIdentifier());
        if (indexedDocument == null || indexedDocument.getFieldList().size() <= 0) {
            return indexDocument;
        }
        Vector<SolrElementField> mergeNeededFields = new Vector<SolrElementField>();
        for (SolrElementField field : indexedDocument.getFieldList()) {
            if ((field.getName().equals("isDocumentedBy") || field.getName().equals("documents") || field.getName().equals("resourceMap")) && !indexDocument.hasFieldWithValue(field.getName(), field.getValue())) {
                indexDocument.addField(field);
                continue;
            }
            if (copyFields.contains(field.getName()) || indexDocument.hasField(field.getName()) || this.isSystemMetadataField(field.getName())) continue;
            log.debug((Object)("SolrIndex.mergeWithIndexedDocument - put the merge-needed existing solr field " + field.getName() + " with value " + field.getValue() + " from the solr server to a vector. We will merge it later."));
            mergeNeededFields.add(field);
        }
        if (mergeNeededFields != null) {
            for (SolrElementField field : mergeNeededFields) {
                log.debug((Object)("SolrIndex.mergeWithIndexedDocument - merge the existing solr field " + field.getName() + " with value " + field.getValue() + " from the solr server to the currently processing document of " + indexDocument.getIdentifier()));
                indexDocument.addField(field);
            }
        }
        indexDocument.setMerged(true);
        return indexDocument;
    }

    private boolean isSystemMetadataField(String fieldName) {
        boolean is = false;
        if (fieldName != null && !fieldName.trim().equals("") && this.sysmetaSolrFields != null) {
            for (ISolrField field : this.sysmetaSolrFields) {
                if (field == null || field.getName() == null || !field.getName().equals(fieldName)) continue;
                log.debug((Object)("SolrIndex.isSystemMetadataField - the field name " + fieldName + " matches one record of system metadata field list. It is a system metadata field."));
                is = true;
                break;
            }
        }
        return is;
    }

    private void checkParams(Identifier pid, SystemMetadata systemMetadata, String objectPath) throws InvalidRequest {
        if (pid == null || pid.getValue() == null || pid.getValue().trim().equals("")) {
            throw new InvalidRequest("0000", "The identifier of the indexed document should not be null or blank.");
        }
        if (systemMetadata == null) {
            throw new InvalidRequest("0000", "The system metadata of the indexed document " + pid.getValue() + " should not be null.");
        }
    }

    private void insert(Identifier pid, SystemMetadata systemMetadata, String objectPath, boolean isSysmetaChangeOnly) throws IOException, SAXException, ParserConfigurationException, InvalidRequest, XPathExpressionException, SolrServerException, MarshallingException, EncoderException, NotImplemented, NotFound, UnsupportedType {
        this.checkParams(pid, systemMetadata, objectPath);
        log.debug((Object)("SolrIndex.insert - trying to insert the solrDoc for object " + pid.getValue()));
        long start = System.currentTimeMillis();
        Map<String, SolrDoc> docs = this.process(pid.getValue(), systemMetadata, objectPath, isSysmetaChangeOnly);
        long end = System.currentTimeMillis();
        log.info((Object)("SolrIndex.insert - the subprocessor processing time of " + pid.getValue() + " is " + (end - start) + " milliseconds."));
        if (docs != null) {
            start = System.currentTimeMillis();
            Set<String> ids = docs.keySet();
            for (String id : ids) {
                if (id == null) continue;
                SolrDoc doc = docs.get(id);
                this.insertToIndex(doc);
                log.debug((Object)("SolrIndex.insert - inserted the solr-doc object of pid " + id + ", which relates to object " + pid.getValue() + ", into the solr server."));
            }
            end = System.currentTimeMillis();
            log.info((Object)("SolrIndex.insert - finished to insert the solrDoc to the solr server for object " + pid.getValue() + " and it took " + (end - start) + " milliseconds."));
        } else {
            log.debug((Object)("SolrIndex.insert - the genered solrDoc is null. So we will not index the object " + pid.getValue()));
        }
    }

    private void insertToIndex(SolrDoc doc) throws SolrServerException, IOException {
        Vector<SolrDoc> docs = new Vector<SolrDoc>();
        docs.add(doc);
        SolrElementAdd addCommand = new SolrElementAdd(docs);
        httpService.sendUpdate(this.solrIndexUri, addCommand, "UTF-8");
    }

    public void update(Identifier pid, String relativePath, boolean isSysmetaChangeOnly) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, XPathExpressionException, UnsupportedType, SAXException, ParserConfigurationException, SolrServerException, MarshallingException, EncoderException, InterruptedException, IOException, InvalidRequest, InstantiationException, IllegalAccessException {
        log.debug((Object)("SolrIndex.update - trying to update(insert or remove) solr index of object " + pid.getValue()));
        String objectPath = null;
        SystemMetadata systemMetadata = ObjectManager.getInstance().getSystemMetadata(pid.getValue(), relativePath);
        objectPath = ObjectManager.getInstance().getFilePath(relativePath, systemMetadata.getFormatId().getValue());
        try {
            this.insert(pid, systemMetadata, objectPath, isSysmetaChangeOnly);
        }
        catch (SolrServerException e) {
            if (e.getMessage().contains(VERSION_CONFLICT) && VERSION_CONFLICT_MAX_ATTEMPTS > 0) {
                log.info((Object)("SolrIndex.update - Indexer grabbed an older verion (version conflict) of the solr doc for object " + pid.getValue() + ". It will try " + VERSION_CONFLICT_MAX_ATTEMPTS + " to fix the issues"));
                for (int i = 0; i < VERSION_CONFLICT_MAX_ATTEMPTS; ++i) {
                    try {
                        Thread.sleep(VERSION_CONFICT_WAITING);
                        systemMetadata = ObjectManager.getInstance().getSystemMetadata(pid.getValue(), relativePath);
                        this.insert(pid, systemMetadata, objectPath, isSysmetaChangeOnly);
                    }
                    catch (SolrException ee) {
                        if (ee.getMessage().contains(VERSION_CONFLICT)) {
                            log.info((Object)("SolrIndex.update - Indexer grabbed an older verion (version conflict) of the solr doc for object " + pid.getValue() + ". It will process it again in oder to get the new solr doc copy. This is the " + (i + 1) + " time to re-try."));
                            if (i != VERSION_CONFLICT_MAX_ATTEMPTS - 1) continue;
                            log.warn((Object)("SolrIndex.update - Indexer grabbed an older verion of the solr doc for object " + pid.getValue() + ". However, Metacat already tried the max times and still can't fix the issue."));
                            throw ee;
                        }
                        throw ee;
                    }
                }
            }
            throw e;
        }
        log.info((Object)("SolrIndex.update - successfully inserted the solr index of the object " + pid.getValue()));
    }

    private boolean isDataPackage(String pid, String formatId) throws FileNotFoundException, ServiceFailure {
        boolean isDataPackage = false;
        if (formatId != null) {
            isDataPackage = resourceMapFormatIdList.contains(formatId);
        }
        return isDataPackage;
    }

    private boolean isPartOfDataPackage(String pid) throws XPathExpressionException, NotImplemented, NotFound, UnsupportedType, SolrServerException, IOException, ParserConfigurationException, SAXException, EncoderException {
        SolrDoc dataPackageIndexDoc = httpService.getSolrDocumentById(this.solrQueryUri, pid);
        if (dataPackageIndexDoc != null) {
            String resourceMapId = dataPackageIndexDoc.getFirstFieldValue("resourceMap");
            return StringUtils.isNotEmpty((String)resourceMapId);
        }
        return false;
    }

    public void remove(Identifier pid) throws XPathExpressionException, IOException, EncoderException, ServiceFailure, NotImplemented, NotFound, UnsupportedType, SolrServerException, ParserConfigurationException, SAXException {
        if (pid != null) {
            log.debug((Object)("SorIndex.remove - start to remove the solr index for the pid " + pid.getValue()));
            SolrDoc indexDoc = httpService.getSolrDocumentById(this.solrQueryUri, pid.getValue());
            if (indexDoc != null) {
                log.debug((Object)("SorIndex.remove - in the branch which the solr doc was found for " + pid.getValue()));
                String formatId = indexDoc.getFirstFieldValue("formatId");
                log.debug((Object)("SorIndex.remove - the format id for the object " + pid.getValue() + " is " + formatId));
                this.remove(pid.getValue(), formatId);
                log.info((Object)("SorIndex.remove - successfully removed the solr index for the pid " + pid.getValue()));
            }
        }
    }

    private void remove(String pid, String formatId) throws FileNotFoundException, ServiceFailure, XPathExpressionException, NotImplemented, NotFound, UnsupportedType, SolrServerException, IOException, ParserConfigurationException, SAXException, EncoderException {
        if (this.isDataPackage(pid, formatId)) {
            this.removeDataPackage(pid);
        } else if (this.isPartOfDataPackage(pid)) {
            this.removeFromDataPackage(pid);
        } else {
            this.deleteDocFromIndex(pid);
        }
    }

    private void removeDataPackage(String pid) throws IOException, UnsupportedType, NotFound, XPathExpressionException, SolrServerException, ParserConfigurationException, SAXException, EncoderException {
        this.deleteDocFromIndex(pid);
        for (int i = 0; i < VERSION_CONFLICT_MAX_ATTEMPTS; ++i) {
            try {
                List<SolrDoc> docsToUpdate = this.getUpdatedSolrDocsByRemovingResourceMap(pid);
                if (docsToUpdate == null || docsToUpdate.isEmpty()) break;
                for (SolrDoc doc : docsToUpdate) {
                    this.insertToIndex(doc);
                }
                break;
            }
            catch (SolrServerException e) {
                if (!e.getMessage().contains(VERSION_CONFLICT) || VERSION_CONFLICT_MAX_ATTEMPTS <= 0) {
                    throw e;
                }
                log.info((Object)("SolrIndex.removeDataPackage - Indexer grabbed an older verion (version conflict) of the solr doc for object. It will try " + (VERSION_CONFLICT_MAX_ATTEMPTS - i) + " to fix the issues"));
                continue;
            }
        }
    }

    private List<SolrDoc> getUpdatedSolrDocsByRemovingResourceMap(String resourceMapId) throws UnsupportedType, NotFound, SolrServerException, ParserConfigurationException, SAXException, MalformedURLException, IOException, XPathExpressionException, EncoderException {
        List<SolrDoc> updatedSolrDocs = null;
        if (resourceMapId != null && !resourceMapId.trim().equals("")) {
            List<SolrDoc> docsContainResourceMap = httpService.getDocumentsByResourceMap(this.solrQueryUri, resourceMapId);
            updatedSolrDocs = this.removeResourceMapRelationship(docsContainResourceMap, resourceMapId);
        }
        return updatedSolrDocs;
    }

    private List<SolrDoc> removeResourceMapRelationship(List<SolrDoc> docsContainResourceMap, String resourceMapId) throws XPathExpressionException, IOException {
        ArrayList<SolrDoc> totalUpdatedSolrDocs = new ArrayList<SolrDoc>();
        if (docsContainResourceMap != null && !docsContainResourceMap.isEmpty()) {
            for (SolrDoc doc : docsContainResourceMap) {
                List<SolrDoc> updatedSolrDocs = new ArrayList<SolrDoc>();
                List<String> resourceMapIdStrs = doc.getAllFieldValues("resourceMap");
                List<String> dataIdStrs = doc.getAllFieldValues("documents");
                List<String> metadataIdStrs = doc.getAllFieldValues("isDocumentedBy");
                if ((dataIdStrs == null || dataIdStrs.isEmpty()) && (metadataIdStrs == null || metadataIdStrs.isEmpty())) {
                    doc.removeFieldsWithValue("resourceMap", resourceMapId);
                    updatedSolrDocs.add(doc);
                } else if (dataIdStrs != null && !dataIdStrs.isEmpty() && (metadataIdStrs == null || metadataIdStrs.isEmpty())) {
                    updatedSolrDocs = this.removeAggregatedItems(resourceMapId, doc, resourceMapIdStrs, dataIdStrs, "documents");
                } else if ((dataIdStrs == null || dataIdStrs.isEmpty()) && metadataIdStrs != null && !metadataIdStrs.isEmpty()) {
                    updatedSolrDocs = this.removeAggregatedItems(resourceMapId, doc, resourceMapIdStrs, metadataIdStrs, "isDocumentedBy");
                } else if (dataIdStrs != null && !dataIdStrs.isEmpty() && metadataIdStrs != null && !metadataIdStrs.isEmpty()) {
                    List<SolrDoc> solrDocsRemovedDocuments = this.removeAggregatedItems(resourceMapId, doc, resourceMapIdStrs, dataIdStrs, "documents");
                    List<SolrDoc> solrDocsRemovedDocumentBy = this.removeAggregatedItems(resourceMapId, doc, resourceMapIdStrs, metadataIdStrs, "isDocumentedBy");
                    updatedSolrDocs = this.mergeUpdatedSolrDocs(solrDocsRemovedDocumentBy, solrDocsRemovedDocuments);
                }
                if (updatedSolrDocs == null) continue;
                for (SolrDoc updatedDoc : updatedSolrDocs) {
                    totalUpdatedSolrDocs.add(updatedDoc);
                }
            }
        }
        return totalUpdatedSolrDocs;
    }

    private List<SolrDoc> removeAggregatedItems(String targetResourceMapId, SolrDoc doc, List<String> resourceMapIdsInDoc, List<String> aggregatedItemsInDoc, String fieldNameRemoved) {
        ArrayList<SolrDoc> updatedSolrDocs = new ArrayList<SolrDoc>();
        if (doc != null && resourceMapIdsInDoc != null && aggregatedItemsInDoc != null && fieldNameRemoved != null) {
            if (resourceMapIdsInDoc.size() == 1) {
                doc.removeFieldsWithValue("resourceMap", targetResourceMapId);
                doc.removeAllFields(fieldNameRemoved);
                updatedSolrDocs.add(doc);
            } else if (resourceMapIdsInDoc.size() > 1) {
                Map<String, String> ids = this.matchResourceMapsAndItems(doc.getIdentifier(), targetResourceMapId, resourceMapIdsInDoc, aggregatedItemsInDoc, fieldNameRemoved);
                if (ids != null) {
                    for (String id : ids.keySet()) {
                        doc.removeFieldsWithValue(fieldNameRemoved, id);
                    }
                }
                doc.removeFieldsWithValue("resourceMap", targetResourceMapId);
                updatedSolrDocs.add(doc);
            }
        }
        return updatedSolrDocs;
    }

    private Map<String, String> matchResourceMapsAndItems(String targetId, String targetResourceMapId, List<String> originalResourceMaps, List<String> aggregatedItems, String fieldName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (targetId != null && targetResourceMapId != null && aggregatedItems != null && fieldName != null) {
            String newFieldName = null;
            if (fieldName.equals("isDocumentedBy")) {
                newFieldName = "documents";
            } else if (fieldName.equals("documents")) {
                newFieldName = "isDocumentedBy";
            }
            if (newFieldName != null) {
                for (String item : aggregatedItems) {
                    SolrDoc doc = null;
                    try {
                        doc = httpService.getSolrDocumentById(this.solrQueryUri, item);
                        List<String> fieldValues = doc.getAllFieldValues(newFieldName);
                        List<String> resourceMapIds = doc.getAllFieldValues("resourceMap");
                        if (fieldValues == null || !fieldValues.contains(targetId) || resourceMapIds == null || !resourceMapIds.contains(targetResourceMapId)) continue;
                        boolean hasDuplicateIds = false;
                        if (originalResourceMaps != null) {
                            for (String id : resourceMapIds) {
                                if (!originalResourceMaps.contains(id) || id.equals(targetResourceMapId)) continue;
                                hasDuplicateIds = true;
                                break;
                            }
                        }
                        if (hasDuplicateIds) continue;
                        map.put(item, targetResourceMapId);
                    }
                    catch (Exception e) {
                        log.warn((Object)("SolrIndex.matchResourceMapsAndItems - can't get the solrdoc for the id " + item + " since " + e.getMessage()));
                    }
                }
            }
        }
        return map;
    }

    private List<SolrDoc> mergeUpdatedSolrDocs(List<SolrDoc> removedDocumentBy, List<SolrDoc> removedDocuments) {
        List<Object> mergedDocuments = new ArrayList();
        if (removedDocumentBy == null || removedDocumentBy.isEmpty()) {
            mergedDocuments = removedDocuments;
        } else if (removedDocuments == null || removedDocuments.isEmpty()) {
            mergedDocuments = removedDocumentBy;
        } else {
            int sizeOfDocBy = removedDocumentBy.size();
            int sizeOfDocs = removedDocuments.size();
            block0: for (int i = sizeOfDocBy - 1; i >= 0; --i) {
                SolrDoc docInRemovedDocBy = removedDocumentBy.get(i);
                for (int j = sizeOfDocs - 1; j >= 0; --j) {
                    SolrDoc docInRemovedDocs = removedDocuments.get(j);
                    if (!docInRemovedDocBy.getIdentifier().equals(docInRemovedDocs.getIdentifier())) continue;
                    List<String> idsInDocuments = docInRemovedDocs.getAllFieldValues("documents");
                    docInRemovedDocBy.removeAllFields("documents");
                    if (idsInDocuments != null) {
                        for (String id : idsInDocuments) {
                            if (id == null || id.trim().equals("")) continue;
                            docInRemovedDocBy.addField(new SolrElementField("documents", id));
                        }
                    }
                    List<String> resourceMapIdsInWithDocs = docInRemovedDocs.getAllFieldValues("resourceMap");
                    List<String> resourceMapIdsInWithDocBy = docInRemovedDocBy.getAllFieldValues("resourceMap");
                    docInRemovedDocBy.removeAllFields("resourceMap");
                    Collection resourceMapIds = CollectionUtils.union(resourceMapIdsInWithDocs, resourceMapIdsInWithDocBy);
                    if (resourceMapIds != null) {
                        for (Object idObj : resourceMapIds) {
                            String id = (String)idObj;
                            docInRemovedDocBy.addField(new SolrElementField("resourceMap", id));
                        }
                    }
                    mergedDocuments.add(docInRemovedDocBy);
                    removedDocumentBy.remove(i);
                    removedDocuments.remove(j);
                    continue block0;
                }
            }
            for (SolrDoc doc : removedDocumentBy) {
                mergedDocuments.add(doc);
            }
            for (SolrDoc doc : removedDocuments) {
                mergedDocuments.add(doc);
            }
        }
        return mergedDocuments;
    }

    private void removeFromDataPackage(String pid) throws XPathExpressionException, IOException, EncoderException, SolrServerException {
        List<String> documentedBy;
        SolrDoc indexedDoc = httpService.getSolrDocumentById(this.solrQueryUri, pid);
        this.deleteDocFromIndex(pid);
        List<String> documents = indexedDoc.getAllFieldValues("documents");
        if (documents != null && !documents.isEmpty()) {
            block4: for (String documentsValue : documents) {
                for (int i = 0; i < VERSION_CONFLICT_MAX_ATTEMPTS; ++i) {
                    try {
                        SolrDoc solrDoc = httpService.getSolrDocumentById(this.solrQueryUri, documentsValue);
                        if (solrDoc == null) continue block4;
                        solrDoc.removeFieldsWithValue("isDocumentedBy", pid);
                        this.insertToIndex(solrDoc);
                        continue block4;
                    }
                    catch (SolrServerException e) {
                        if (!e.getMessage().contains(VERSION_CONFLICT) || VERSION_CONFLICT_MAX_ATTEMPTS <= 0) {
                            throw e;
                        }
                        log.info((Object)("SolrIndex.removeFromDataPackage - Indexer grabbed an older verion (version conflict) of the solr doc for object " + documentsValue + ". It will try " + (VERSION_CONFLICT_MAX_ATTEMPTS - i) + " to fix the issues"));
                        continue;
                    }
                }
            }
        }
        if ((documentedBy = indexedDoc.getAllFieldValues("isDocumentedBy")) != null && !documentedBy.isEmpty()) {
            block6: for (String documentedByValue : documentedBy) {
                for (int i = 0; i < VERSION_CONFLICT_MAX_ATTEMPTS; ++i) {
                    try {
                        SolrDoc solrDoc = httpService.getSolrDocumentById(this.solrQueryUri, documentedByValue);
                        if (solrDoc == null) continue block6;
                        solrDoc.removeFieldsWithValue("documents", pid);
                        this.insertToIndex(solrDoc);
                        continue block6;
                    }
                    catch (SolrServerException e) {
                        if (!e.getMessage().contains(VERSION_CONFLICT) || VERSION_CONFLICT_MAX_ATTEMPTS <= 0) {
                            throw e;
                        }
                        log.info((Object)("SolrIndex.removeFromDataPackage - Indexer grabbed an older verion (version conflict) of the solr doc for object " + documentedByValue + ". It will try " + (VERSION_CONFLICT_MAX_ATTEMPTS - i) + " to fix the issues"));
                        continue;
                    }
                }
            }
        }
    }

    private void deleteDocFromIndex(String pid) throws IOException {
        if (pid != null && !pid.trim().equals("")) {
            httpService.sendSolrDelete(pid, this.solrIndexUri);
        }
    }

    public void setHttpService(HTTPService service) {
        httpService = service;
    }

    public HTTPService getHttpService() {
        return httpService;
    }
}

