/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.eml;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EMLValidator {
    private Document doc = null;
    private List<String> errors = null;

    public EMLValidator(File file) {
        try {
            FileInputStream f = new FileInputStream(file);
            this.doc = this.parseDocument(new InputSource(f));
            this.errors = new ArrayList<String>();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public EMLValidator(String emltext) {
        try {
            StringReader reader = new StringReader(emltext);
            this.doc = this.parseDocument(new InputSource(reader));
            this.errors = new ArrayList<String>();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        String emlfile = args[0];
        File file = new File(emlfile);
        EMLValidator validator = new EMLValidator(file);
        boolean isValid = validator.validate();
        System.err.println("isValid: " + new Boolean(isValid).toString());
        if (!isValid) {
            for (String e : validator.getErrors()) {
                System.err.println(e);
            }
        }
    }

    public boolean validate() {
        NodeList both_id_ref;
        boolean isValid = true;
        NodeList root_not_eml = this.getXPathNodeList("/*[local-name() != 'eml']");
        int length = root_not_eml.getLength();
        if (length > 0) {
            this.errors.add("Invalid: root element is not eml.");
            isValid = false;
        }
        ArrayList packageId = this.getXPathValues("//*/@packageId");
        ArrayList ids = this.getXPathValues("//*[@id]/@id");
        ids.addAll(packageId);
        HashMap idmap = new HashMap();
        for (Object s : ids) {
            idmap.put((String)s, null);
        }
        if (ids.size() != idmap.size()) {
            this.errors.add("Invalid: ID attributes must be unique. Duplicates exist.");
            isValid = false;
        }
        ArrayList refs = this.getXPathValues("//annotation[@references]/@references|//references|//describes");
        for (String s : refs) {
            if (ids.contains(s)) continue;
            this.errors.add("Invalid: Reference missing from IDs: " + s);
            isValid = false;
        }
        NodeList missing_id_ref = this.getXPathNodeList("//*[annotation and not(@id) and not(annotation[@references]) and not(parent::*/describes)]");
        length = missing_id_ref.getLength();
        if (length > 0) {
            this.errors.add("Invalid: annotations lack id or references: " + length);
            isValid = false;
        }
        if ((length = (both_id_ref = this.getXPathNodeList("//*[references and @id]")).getLength()) > 0) {
            this.errors.add("Invalid: elements use both @id and references: " + length);
            isValid = false;
        }
        return isValid;
    }

    public String[] getErrors() {
        return this.errors.toArray(new String[0]);
    }

    private Document parseDocument(InputSource in) throws Exception {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(false);
        Document doc = dfactory.newDocumentBuilder().parse(in);
        return doc;
    }

    private ArrayList getXPathValues(String xpath) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            NodeList nl = XPathAPI.selectNodeList((Node)this.doc, (String)xpath);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                n.normalize();
                Node t = n.getFirstChild();
                values.add(t.getNodeValue());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return values;
    }

    private NodeList getXPathNodeList(String xpath, Node n) {
        NodeList nl = null;
        try {
            nl = XPathAPI.selectNodeList((Node)n, (String)xpath);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return nl;
    }

    private NodeList getXPathNodeList(String xpath) {
        return this.getXPathNodeList(xpath, this.doc);
    }

    private void debugNode(Node node, String spacer) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                String name = node.getNodeName();
                System.out.print(spacer + "<" + name);
                NamedNodeMap nnm = node.getAttributes();
                for (int i = 0; i < nnm.getLength(); ++i) {
                    Node current = nnm.item(i);
                    System.out.print(" " + current.getNodeName() + "= " + current.getNodeValue());
                }
                System.out.print(">");
                NodeList nl = node.getChildNodes();
                if (nl != null) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        this.debugNode(nl.item(i), "");
                    }
                }
                System.out.println(spacer + "</" + name + ">");
                break;
            }
            case 3: {
                System.out.print(node.getNodeValue());
                break;
            }
            case 4: {
                System.out.print("" + node.getNodeValue() + "");
                break;
            }
            case 5: {
                System.out.print("&" + node.getNodeName() + ";");
                break;
            }
            case 6: {
                System.out.print("<ENTITY: " + node.getNodeName() + "> </" + node.getNodeName() + "/>");
                break;
            }
            case 9: {
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    this.debugNode(nodes.item(i), "");
                }
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                System.out.print("<!DOCTYPE " + docType.getName());
                if (docType.getPublicId() != null) {
                    System.out.print(" PUBLIC " + docType.getPublicId() + " ");
                } else {
                    System.out.print(" SYSTEM ");
                }
                System.out.println(" " + docType.getSystemId() + ">");
                break;
            }
        }
    }
}

