/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.export;

import java.io.File;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.ecoinformatics.export.HtmlToPdf;

public class HtmlToPdfTest
extends TestCase {
    private static final String TEST_DIR = "./src/test/resources";

    public HtmlToPdfTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void initialize() {
        HtmlToPdfTest.assertTrue((boolean)true);
    }

    public void testExport() {
        try {
            String workingPath = "build/tests/";
            String emlFileName = "eml-sample";
            String emlFileExtension = ".xml";
            String emlFile = workingPath + emlFileName + emlFileExtension;
            String xslFile = "style/eml/eml.xsl";
            String htmlFile = workingPath + emlFileName + ".html";
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(new File(xslFile)));
            transformer.clearParameters();
            transformer.setParameter("href_path_extension", ".html");
            transformer.setParameter("package_id", "test.1.1");
            transformer.setParameter("package_index_name", "metadata");
            transformer.setParameter("qformat", "default");
            transformer.setParameter("entitystyle", "default");
            transformer.setParameter("stylePath", ".");
            transformer.setParameter("displaymodule", "printall");
            transformer.transform(new StreamSource(new File(emlFile)), new StreamResult(new File(htmlFile)));
            String pdfFile = workingPath + emlFileName + ".pdf";
            HtmlToPdf.export(htmlFile, pdfFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            HtmlToPdfTest.fail((String)e.getMessage());
        }
    }
}

