/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.ssl;

import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import javax.net.ssl.X509TrustManager;

public class MyTrustManager
implements X509TrustManager {
    boolean debugOn = false;
    boolean stackTracesOn = false;
    String serverDN = null;
    MyLoggingFacade logger;
    public final String DEFAULT_TRUST_ROOT_PATH = "/etc/grid-security/certificates";
    String trustRootPath = "/etc/grid-security/certificates";
    boolean requestTrustRoots;
    String host;

    public MyTrustManager(MyLoggingFacade logger, String trustRootPath) {
        this(logger, trustRootPath, null);
    }

    public MyTrustManager(MyLoggingFacade logger, String trustRootPath, String serverDN) {
        this.trustRootPath = trustRootPath;
        this.logger = logger;
        this.serverDN = serverDN;
    }

    public boolean hasServerDN() {
        return this.serverDN != null;
    }

    public String getServerDN() {
        return this.serverDN;
    }

    public void setServerDN(String serverDN) {
        this.serverDN = serverDN;
    }

    public MyLoggingFacade getLogger() {
        if (this.logger == null) {
            this.logger = new MyLoggingFacade(MyTrustManager.class.getName());
            this.logger.setDebugOn(this.debugOn);
        }
        return this.logger;
    }

    public String getTrustRootPath() {
        return this.trustRootPath;
    }

    public void setTrustRootPath(String trustRootPath) {
        this.trustRootPath = trustRootPath;
    }

    public boolean isRequestTrustRoots() {
        return this.requestTrustRoots;
    }

    public void setRequestTrustRoots(boolean requestTrustRoots) {
        this.requestTrustRoots = requestTrustRoots;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    void dbg(String x) {
        if (this.debugOn) {
            System.out.println(this.getClass().getName() + "(" + new Date() + "): " + x);
            this.getLogger().info(this.getClass().getName() + "(" + new Date() + "): " + x);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = null;
        String certDirPath = this.getTrustRootPath();
        if (certDirPath == null) {
            this.dbg("cert dir path null. Aborting");
            return null;
        }
        File dir = new File(certDirPath);
        if (!dir.isDirectory()) {
            this.dbg(" cert dir path is not a directory. Aborting.");
            return null;
        }
        String[] certFilenames = dir.list();
        String[] certData = new String[certFilenames.length];
        for (int i = 0; i < certFilenames.length; ++i) {
            try {
                FileInputStream fileStream = new FileInputStream(certDirPath + File.separator + certFilenames[i]);
                byte[] buffer = new byte[fileStream.available()];
                fileStream.read(buffer);
                certData[i] = new String(buffer);
                fileStream.close();
                continue;
            }
            catch (Exception e) {
                this.dbg("Exception Reading issues " + e.getMessage());
            }
        }
        try {
            issuers = CertUtil.getX509CertsFromStringList(certData, certFilenames);
            this.dbg("Got " + issuers.length + " issuers.");
        }
        catch (Exception e) {
            if (this.stackTracesOn) {
                e.printStackTrace();
            }
            this.dbg("Exception getting issuers. Returning null. " + e.getMessage());
        }
        return issuers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        throw new CertificateException("checkClientTrusted not implemented by " + this.getClass().getName());
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        this.checkServerCertPath(certs);
        this.checkServerDN(certs[0]);
    }

    protected void checkServerCertPath(X509Certificate[] certs) throws CertificateException {
        block10: {
            try {
                CertPathValidator validator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                CertPath certPath = certFactory.generateCertPath(Arrays.asList(certs));
                X509Certificate[] acceptedIssuers = this.getAcceptedIssuers();
                if (acceptedIssuers == null) {
                    String certDir = this.getTrustRootPath();
                    if (certDir != null) {
                        throw new CertificateException("no CA certificates found in " + certDir);
                    }
                    if (!this.isRequestTrustRoots()) {
                        throw new CertificateException("no CA certificates directory found");
                    }
                    this.getLogger().info("no trusted CAs configured -- bootstrapping trust from MyProxy server");
                    acceptedIssuers = new X509Certificate[]{certs[certs.length - 1]};
                }
                HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>(acceptedIssuers.length);
                for (int i = 0; i < acceptedIssuers.length; ++i) {
                    TrustAnchor ta = new TrustAnchor(acceptedIssuers[i], null);
                    trustAnchors.add(ta);
                }
                PKIXParameters pkixParameters = new PKIXParameters(trustAnchors);
                pkixParameters.setRevocationEnabled(false);
                validator.validate(certPath, pkixParameters);
            }
            catch (CertificateException e) {
                if (this.stackTracesOn) {
                    e.printStackTrace();
                }
                throw e;
            }
            catch (GeneralSecurityException e) {
                if (this.stackTracesOn) {
                    e.printStackTrace();
                }
                throw new CertificateException(e);
            }
            catch (Throwable t) {
                if (!this.stackTracesOn) break block10;
                t.printStackTrace();
            }
        }
    }

    private String getCommonName(String subject) throws CertificateException {
        int index = subject.indexOf("CN=");
        if (index == -1) {
            throw new CertificateException("Server certificate subject (" + subject + "does not contain a CN component.");
        }
        String CN = subject.substring(index + 3);
        if ((index = CN.indexOf(44)) >= 0) {
            CN = CN.substring(0, index);
        }
        if ((index = CN.indexOf(47)) >= 0) {
            String service = CN.substring(0, index);
            CN = CN.substring(index + 1);
            if (!service.equals("host") && !service.equals("myproxy")) {
                this.dbg("common name =\"" + CN + "\" has unknown server element \"" + subject + "\"");
                throw new CertificateException("Server certificate subject CN contains unknown server element: " + subject);
            }
        }
        return CN;
    }

    private void checkServerDN(X509Certificate cert) throws CertificateException {
        MyLoggingFacade ll = this.getLogger();
        String CN = this.getCommonName(cert.getSubjectX500Principal().getName());
        if (this.hasServerDN()) {
            String configuredCN = this.getCommonName(this.getServerDN());
            this.dbg(".checkServerDN: Configured serverDN has CN = " + configuredCN);
            if (CN.equals(configuredCN)) {
                return;
            }
            this.dbg(".checkServerDN: Configured serverDN check failed.");
        }
        this.dbg(".checkServerDN: Checking cert CN against hostname");
        if (this.getHost().equals("localhost")) {
            try {
                this.setHost(InetAddress.getLocalHost().getHostName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.dbg(".checkServerDN: Configured host = " + this.getHost());
        this.dbg(".checkServerDN: host=CN? " + CN.equals(this.getHost()));
        if (!CN.equals(this.getHost())) {
            this.dbg("common name =\"" + CN + "\" does not match host from reverse lookup = \"" + this.host + "\"");
            throw new CertificateException("Server certificate subject CN (" + CN + ") does not match server hostname (" + this.host + ").");
        }
        this.dbg("Success! common name =\"" + CN + "\" matches host = \"" + this.host + "\"");
    }
}

