/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink;

import edu.ucsb.nceas.osti_elink.OSTIElinkErrorAgent;
import edu.ucsb.nceas.osti_elink.OSTIElinkService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OSTIElinkServiceRequest
implements Runnable {
    public static final int SETMETADATA = 1;
    private OSTIElinkService service = null;
    private OSTIElinkErrorAgent errorAgent = null;
    private int method = 0;
    private String identifier = null;
    private String metadata = null;
    protected static Log log = LogFactory.getLog(OSTIElinkServiceRequest.class);

    protected OSTIElinkServiceRequest(OSTIElinkService service, int method, String identifier, OSTIElinkErrorAgent errorAgent) {
        if (service == null) {
            throw new IllegalArgumentException("EZIDService argument must not be null.");
        }
        if (method < 1 || method > 4) {
            throw new IllegalArgumentException("Service must be an interger value between 1 and 4.");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier must not be null.");
        }
        this.service = service;
        this.method = method;
        this.identifier = identifier;
        this.errorAgent = errorAgent;
    }

    protected OSTIElinkServiceRequest(OSTIElinkService service, int method, String identifier, OSTIElinkErrorAgent errorAgent, String metadata) {
        this(service, method, identifier, errorAgent);
        this.metadata = metadata;
    }

    @Override
    public void run() {
        block5: {
            log.debug((Object)("OSTIElinkServiceRequest - Service to execute: " + this.method + "/" + this.identifier + "/" + this.metadata));
            try {
                switch (this.method) {
                    case 1: {
                        String prefix = null;
                        this.service.setMetadata(this.identifier, prefix, this.metadata);
                        log.debug((Object)("Completed CREATE request for: " + this.identifier));
                        break;
                    }
                    default: {
                        log.warn((Object)("OSTIElinkServiceRequest - the request doesn't support this methdo: " + this.method));
                        break;
                    }
                }
            }
            catch (Exception e) {
                String error = "OSTIElinkServiceRequest.run - the request to OSTI for " + this.identifier + " failed:\n" + this.metadata + "\n *************************************************************\n The response from OSIT is:\n " + e.getMessage();
                log.error((Object)error);
                if (this.errorAgent == null) break block5;
                this.errorAgent.notify(error);
            }
        }
    }
}

