/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.export;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.tidy.Tidy;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class HtmlToPdf {
    public static void export(String inputFile, String outputFile) throws IOException, DocumentException {
        FileOutputStream os = new FileOutputStream(outputFile);
        File tidyFile = new File(inputFile + ".tidy");
        FileOutputStream tidyOut = new FileOutputStream(tidyFile);
        Tidy tidy = new Tidy();
        tidy.setXHTML(true);
        tidy.parse((InputStream)new FileInputStream(inputFile), (OutputStream)tidyOut);
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocument(tidyFile);
        renderer.layout();
        renderer.createPDF((OutputStream)os);
        ((OutputStream)os).close();
        tidyFile.delete();
    }

    public static void main(String[] args) {
        try {
            HtmlToPdf.export(args[0], args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

