/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.os.inspection;

import com.gc.iotools.stream.utils.StreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

public class StatsOutputStream
extends OutputStream {
    private boolean closeCalled;
    private final OutputStream innerOs;
    private long size = 0L;
    private long time = 0L;

    public StatsOutputStream(OutputStream destination) {
        this.innerOs = destination;
    }

    public void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            long start = System.currentTimeMillis();
            this.innerOs.close();
            this.time += System.currentTimeMillis() - start;
        }
    }

    public void flush() throws IOException {
        long start = System.currentTimeMillis();
        this.innerOs.flush();
        this.time += System.currentTimeMillis() - start;
    }

    public String getBitRateString() {
        return StreamUtils.getRateString(this.size, this.time);
    }

    public long getSize() {
        return this.size;
    }

    public long getTime(TimeUnit tu) {
        return tu.convert(this.time, TimeUnit.MILLISECONDS);
    }

    public void write(byte[] b) throws IOException {
        long start = System.currentTimeMillis();
        this.innerOs.write(b);
        this.time += System.currentTimeMillis() - start;
        this.size += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        long start = System.currentTimeMillis();
        this.innerOs.write(b, off, len);
        this.time += System.currentTimeMillis() - start;
        this.size += (long)len;
    }

    public void write(int b) throws IOException {
        long start = System.currentTimeMillis();
        this.innerOs.write(b);
        this.time += System.currentTimeMillis() - start;
        ++this.size;
    }
}

