/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.ssl;

import edu.uiuc.ncsa.security.core.Logable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.ssl.MyTrustManager;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class VerifyingHTTPClientFactory
implements Logable {
    boolean strictHostnames = true;
    public static int DEFAULT_CONNECTION_TIMEOUT = 10000;
    MyLoggingFacade logger;
    KeyStore keyStore;
    KeyManagerFactory keyManagerFactory;
    SSLConfiguration sslConfiguration;

    public VerifyingHTTPClientFactory(MyLoggingFacade logger, SSLConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
        this.logger = logger;
    }

    public boolean isStrictHostnames() {
        return this.strictHostnames;
    }

    public void setStrictHostnames(boolean strictHostnames) {
        this.strictHostnames = strictHostnames;
    }

    public void debug(String x) {
        this.getLogger().debug(x);
    }

    public boolean isDebugOn() {
        return this.getLogger().isDebugOn();
    }

    public void setDebugOn(boolean setOn) {
        this.getLogger().setDebugOn(setOn);
    }

    public void info(String x) {
        this.getLogger().info(x);
    }

    public void warn(String x) {
        this.getLogger().warn(x);
    }

    public void error(String x) {
        this.getLogger().error(x);
    }

    public MyLoggingFacade getLogger() {
        if (this.logger == null) {
            this.logger = new MyLoggingFacade(this.getClass().getName(), false);
        }
        return this.logger;
    }

    public HttpClient getClient(String host) throws IOException {
        return this.getClient(host, 0, 0);
    }

    public HttpClient getClient(String host, int connectionTimeout, int socketTimeout) throws IOException {
        MyTrustManager myTrustManager = this.newMyTrustManager();
        myTrustManager.setHost(host);
        this.debug("my trust manager: trust root path+" + myTrustManager.getTrustRootPath());
        myTrustManager.setTrustRootPath(this.getSSLConfiguration().getTrustrootPath());
        return this.getClient(myTrustManager, connectionTimeout, socketTimeout);
    }

    public HttpClient getClient(X509TrustManager x509TrustManager) {
        return this.getClient(x509TrustManager, 0, 0);
    }

    public HttpClient getClient(X509TrustManager x509TrustManager, int connectionTimeout, int socketTimeout) {
        DefaultHttpClient httpclient = null;
        try {
            if (0 < connectionTimeout && 0 < socketTimeout) {
                BasicHttpParams httpParams = new BasicHttpParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
                HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)socketTimeout);
                httpclient = new DefaultHttpClient((HttpParams)httpParams);
            } else {
                httpclient = new DefaultHttpClient();
            }
            httpclient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)this.getSocketFactory(x509TrustManager), 443));
            this.debug("done creating https client = " + httpclient);
            return httpclient;
        }
        catch (Throwable t) {
            this.error("could not create https client.");
            t.printStackTrace();
            throw new GeneralException("Error creating client", t);
        }
    }

    protected SSLSocketFactory getSocketFactory(X509TrustManager tm) throws IOException, GeneralSecurityException {
        this.debug("creating socket factory");
        SSLContext sc = SSLContext.getInstance("TLS");
        X509TrustManagerFacade tmf = new X509TrustManagerFacade();
        tmf.add(tm);
        this.debug("added trust manager = " + tm);
        TrustManager[] trustAllCerts = new X509TrustManager[]{tmf};
        if (this.hasKeyStore()) {
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(this.getSSLConfiguration().getKeyManagerFactory());
            tmfactory.init(this.getKeyStore());
            for (TrustManager tm0 : tmfactory.getTrustManagers()) {
                if (!(tm0 instanceof X509TrustManager)) continue;
                tmf.add((X509TrustManager)tm0);
            }
        }
        this.debug("Added other trust managers, #=" + tmf.getTrustManagers().size());
        sc.init(this.getKeyManagers(), trustAllCerts, new SecureRandom());
        SSLSocketFactory socketFactory = new SSLSocketFactory(sc);
        if (this.isStrictHostnames()) {
            socketFactory.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
        } else {
            socketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        this.debug("enabled strict hostname verification");
        return socketFactory;
    }

    public boolean hasKeyStore() {
        return this.getSSLConfiguration().getKeystore() != null;
    }

    public MyTrustManager newMyTrustManager() throws IOException {
        return new MyTrustManager(this.logger, this.getSSLConfiguration().getTrustrootPath());
    }

    protected KeyManagerFactory getKeyManagerFactory() throws IOException, GeneralSecurityException {
        if (this.keyManagerFactory == null) {
            this.keyManagerFactory = KeyManagerFactory.getInstance(this.getSSLConfiguration().getKeyManagerFactory());
            this.keyManagerFactory.init(this.getKeyStore(), this.getSSLConfiguration().getKeystorePasswordChars());
        }
        return this.keyManagerFactory;
    }

    protected KeyStore getKeyStore() throws IOException, GeneralSecurityException {
        if (this.keyStore == null) {
            if (this.getSSLConfiguration().getKeystore() == null) {
                this.warn("No keystore");
                return null;
            }
            this.keyStore = KeyStore.getInstance(this.getSSLConfiguration().getKeystoreType());
            File keystoreFile = new File(this.getSSLConfiguration().getKeystore());
            if (!keystoreFile.exists()) {
                throw new FileNotFoundException("Error: the keystore file \"" + keystoreFile + "\" does not exist");
            }
            FileInputStream fis = new FileInputStream(keystoreFile);
            this.keyStore.load(fis, this.getSSLConfiguration().getKeystorePasswordChars());
            fis.close();
        }
        return this.keyStore;
    }

    protected void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    protected void setKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
    }

    protected KeyManager[] getKeyManagers() throws IOException, GeneralSecurityException {
        if (!this.hasKeyStore() || this.getKeyManagerFactory() == null) {
            return null;
        }
        return this.getKeyManagerFactory().getKeyManagers();
    }

    public SSLConfiguration getSSLConfiguration() {
        return this.sslConfiguration;
    }

    public void setSSLConfiguration(SSLConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public static class X509TrustManagerFacade
    implements X509TrustManager {
        static boolean stackTracesOn = false;
        List<X509TrustManager> trustManagers;

        public List<X509TrustManager> getTrustManagers() {
            if (this.trustManagers == null) {
                this.trustManagers = new ArrayList<X509TrustManager>();
            }
            return this.trustManagers;
        }

        public void setTrustManagers(List<X509TrustManager> trustManagers) {
            this.trustManagers = trustManagers;
        }

        public void add(X509TrustManager x509TrustManager) {
            this.getTrustManagers().add(x509TrustManager);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            for (X509TrustManager tm : this.getTrustManagers()) {
                try {
                    tm.checkClientTrusted(x509Certificates, s);
                    return;
                }
                catch (Throwable t) {
                    if (!stackTracesOn) continue;
                    t.printStackTrace();
                }
            }
            throw new CertificateException("No trust manager accepted the client");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            for (X509TrustManager tm : this.getTrustManagers()) {
                try {
                    tm.checkServerTrusted(x509Certificates, s);
                    return;
                }
                catch (Throwable t) {
                    if (!stackTracesOn) continue;
                    t.printStackTrace();
                }
            }
            throw new CertificateException("No trust manager accepted the server");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

