/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import org.ecoinformatics.datamanager.database.ANDRelation;
import org.ecoinformatics.datamanager.database.ConditionInterface;
import org.ecoinformatics.datamanager.database.ORRelation;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;

public class WhereClause {
    private ConditionInterface condition = null;
    private ANDRelation and = null;
    private ORRelation or = null;
    private static final String WHERE = "where";

    public WhereClause(ConditionInterface condition) {
        this.condition = condition;
    }

    public WhereClause(ANDRelation and) {
        this.and = and;
    }

    public WhereClause(ORRelation or) {
        this.or = or;
    }

    public void setConditionInterface(ConditionInterface condition) {
        this.condition = condition;
        this.and = null;
        this.or = null;
    }

    public void setANDRelation(ANDRelation and) {
        this.and = and;
        this.condition = null;
        this.or = null;
    }

    public void setORRelation(ORRelation or) {
        this.or = or;
        this.condition = null;
        this.and = null;
    }

    public String toSQLString() throws UnWellFormedQueryException {
        if (this.condition == null && this.or == null && this.and == null) {
            throw new UnWellFormedQueryException("There is no component in the WHERE clause");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" ");
        sql.append(WHERE);
        sql.append(" ");
        if (this.condition != null) {
            sql.append(this.condition.toSQLString());
        } else if (this.and != null) {
            sql.append(this.and.toSQLString());
        } else if (this.or != null) {
            sql.append(this.or.toSQLString());
        }
        return sql.toString();
    }
}

