/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.quality;

import java.util.ArrayList;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.quality.QualityCheck;

public class EntityReport {
    private Entity entity;
    private ArrayList<QualityCheck> qualityChecks = null;

    public EntityReport(Entity entity) {
        this.entity = entity;
        this.qualityChecks = new ArrayList();
    }

    public void addQualityCheck(QualityCheck qualityCheck) {
        String identifier = qualityCheck.getIdentifier();
        if (identifier.equalsIgnoreCase("onlineURLs") && this.hasQualityCheck(qualityCheck)) {
            return;
        }
        this.qualityChecks.add(qualityCheck);
    }

    public ArrayList<QualityCheck> getQualityChecks() {
        return this.qualityChecks;
    }

    public boolean hasEntityQualityError() {
        boolean hasError = false;
        for (QualityCheck qualityCheck : this.qualityChecks) {
            if (!qualityCheck.hasErrorStatus()) continue;
            hasError = true;
        }
        return hasError;
    }

    private boolean hasQualityCheck(QualityCheck qualityCheck) {
        for (QualityCheck qc : this.qualityChecks) {
            if (!qualityCheck.equals(qc)) continue;
            return true;
        }
        return false;
    }

    public String toXML() {
        String xmlString = null;
        if (this.entity != null) {
            String entityName = this.entity.getName();
            String entityId = this.entity.getId();
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("  <entityReport>\n");
            stringBuffer.append("    <entityName>" + entityName + "</entityName>\n");
            if (entityId != null && !entityId.equals("")) {
                stringBuffer.append("    <entityId>" + entityId + "</entityId>\n");
            }
            if (this.qualityChecks != null && this.qualityChecks.size() > 0) {
                for (QualityCheck aQualityCheck : this.qualityChecks) {
                    String qualityCheckXML = aQualityCheck.toXML();
                    stringBuffer.append(qualityCheckXML);
                }
            }
            stringBuffer.append("  </entityReport>\n");
            xmlString = stringBuffer.toString();
        }
        return xmlString;
    }
}

