/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.parser;

import java.util.ArrayList;
import java.util.Vector;
import org.ecoinformatics.datamanager.parser.DataObjectDescription;
import org.ecoinformatics.datamanager.parser.Domain;
import org.ecoinformatics.datamanager.parser.StorageType;

public class Attribute
extends DataObjectDescription {
    public static String STANDARDUNIT = "STANDARDUNIT";
    public static String CUSTOMUNIT = "CUSTOMUNIT";
    private String dbFieldName = null;
    private String label;
    private String unit;
    private String unitType;
    private String measurementScale;
    private Domain domain;
    private Vector missingValueCode = new Vector();
    private ArrayList<StorageType> storageTypeArray = new ArrayList();
    private String attributeType;

    public Attribute(String id, String name, Domain dom) {
        this(id, name, null, null, dom);
    }

    public Attribute(String id, String name, String description, Domain dom) {
        this(id, name, description, null, dom);
    }

    public Attribute(String id, String name, String description, String unit, Domain dom) {
        this(id, name, null, description, unit, null, null, dom);
    }

    public Attribute(String id, String name, String label, String description, String unit, String unitType, String measurementScale, Domain dom) {
        super(id, name, description);
        this.label = label == null ? "" : label;
        this.unit = unit == null ? "" : unit;
        this.unitType = unitType == null ? "" : unitType;
        this.measurementScale = measurementScale == null ? "" : measurementScale;
        this.domain = dom;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public String getMeasurementScale() {
        return this.measurementScale;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void addMissingValueCode(String code) {
        if (code != null) {
            this.missingValueCode.add(code);
        }
    }

    public String[] getMissingValueCode() {
        if (this.missingValueCode == null || this.missingValueCode.size() == 0) {
            return null;
        }
        int size = this.missingValueCode.size();
        String[] list = new String[size];
        for (int i = 0; i < size; ++i) {
            list[i] = (String)this.missingValueCode.elementAt(i);
        }
        return list;
    }

    public String getDBFieldName() {
        return this.dbFieldName;
    }

    public void setAttributeType(String attributeType) {
        this.attributeType = attributeType;
    }

    public void setDBFieldName(String name) {
        this.dbFieldName = name;
    }

    public void addStorageType(StorageType storageType) {
        if (storageType != null) {
            this.storageTypeArray.add(storageType);
        }
    }

    public ArrayList<StorageType> getStorageTypeArray() {
        return this.storageTypeArray;
    }
}

