/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.lang.Parser;
import com.hp.hpl.jena.sparql.lang.arq.ARQParser;
import com.hp.hpl.jena.sparql.lang.arq.ParseException;
import com.hp.hpl.jena.sparql.lang.arq.TokenMgrError;
import com.hp.hpl.jena.sparql.util.ALog;
import java.io.StringReader;

class ParserARQ
extends Parser {
    ParserARQ() {
    }

    public Query parse(Query query, String queryString) {
        ARQParser parser = null;
        StringReader in = new StringReader(queryString);
        try {
            query.setStrict(true);
            parser = new ARQParser(in);
            parser.setQuery(query);
            parser.CompilationUnit();
            query.setSyntax(Syntax.syntaxARQ);
            this.validateParsedQuery(query);
            return query;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), err, -1, -1);
        }
        catch (Throwable th) {
            ALog.warn(ParserARQ.class, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

