/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class DeletedDupLNLogEntry
extends LNLogEntry {
    private Key dataAsKey;

    public DeletedDupLNLogEntry(boolean isTransactional) {
        super(LN.class, isTransactional);
    }

    public DeletedDupLNLogEntry(LogEntryType entryType, LN ln, DatabaseId dbId, Key key, Key dataAsKey, DbLsn abortLsn, boolean abortKnownDeleted, Txn txn) {
        super(entryType, ln, dbId, key, abortLsn, abortKnownDeleted, txn);
        this.dataAsKey = dataAsKey;
    }

    public void readEntry(ByteBuffer entryBuffer) throws DatabaseException {
        super.readEntry(entryBuffer);
        this.dataAsKey = new Key();
        this.dataAsKey.readFromLog(entryBuffer);
    }

    public StringBuffer dumpEntry(StringBuffer sb, boolean verbose) {
        super.dumpEntry(sb, verbose);
        this.dataAsKey.dumpLog(sb, verbose);
        return sb;
    }

    public int getLogSize() {
        return super.getLogSize() + this.dataAsKey.getLogSize();
    }

    public void writeToLog(ByteBuffer destBuffer) {
        super.writeToLog(destBuffer);
        this.dataAsKey.writeToLog(destBuffer);
    }

    public Key getDupKey() {
        return this.dataAsKey;
    }
}

