/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.tree.LN;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class FileSummaryLN
extends LN {
    private static final String BEGIN_TAG = "<fileSummaryLN>";
    private static final String END_TAG = "</fileSummaryLN>";
    private FileSummary baseSummary;
    private TrackedFileSummary trackedSummary;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileSummaryLN(FileSummary baseSummary) {
        super(new byte[0]);
        if (!$assertionsDisabled && baseSummary == null) {
            throw new AssertionError();
        }
        this.baseSummary = baseSummary;
    }

    public FileSummaryLN() throws DatabaseException {
        this.baseSummary = new FileSummary();
    }

    public void setTrackedSummary(TrackedFileSummary trackedSummary) {
        this.trackedSummary = trackedSummary;
    }

    public TrackedFileSummary getTrackedSummary() {
        return this.trackedSummary;
    }

    public FileSummary getBaseSummary() {
        return this.baseSummary;
    }

    public void postFetchInit(DatabaseImpl db) throws DatabaseException {
    }

    protected long computeInMemorySize() {
        return 0L;
    }

    public static long bytesToFileNumber(byte[] bytes) {
        try {
            return Long.valueOf(new String(bytes, "UTF-8"));
        }
        catch (UnsupportedEncodingException shouldNeverHappen) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)shouldNeverHappen);
            }
            return 0L;
        }
    }

    public static byte[] fileNumberToBytes(long fileNum) {
        try {
            return String.valueOf(fileNum).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException shouldNeverHappen) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)shouldNeverHappen);
            }
            return null;
        }
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        if (!this.isDeleted()) {
            sb.append(this.baseSummary.toString());
        }
        return sb.toString();
    }

    protected void dumpLogAdditional(StringBuffer sb) {
        sb.append(this.baseSummary.toString());
    }

    protected LogEntryType getTransactionalLogType() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Txnl access to UP db not allowed");
        }
        return LogEntryType.LOG_FILESUMMARYLN;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_FILESUMMARYLN;
    }

    public boolean marshallOutsideWriteLatch() {
        return false;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        if (!this.isDeleted()) {
            size += this.baseSummary.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        if (this.trackedSummary != null) {
            this.baseSummary.add(this.trackedSummary);
            this.trackedSummary.reset();
        }
        super.writeToLog(logBuffer);
        if (!this.isDeleted()) {
            this.baseSummary.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        super.readFromLog(itemBuffer);
        if (!this.isDeleted()) {
            this.baseSummary.readFromLog(itemBuffer);
        }
    }

    static {
        $assertionsDisabled = !FileSummaryLN.class.desiredAssertionStatus();
    }
}

