/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees.test;

import com.hp.hpl.jena.graph.query.regexptrees.Alternatives;
import com.hp.hpl.jena.graph.query.regexptrees.AnyOf;
import com.hp.hpl.jena.graph.query.regexptrees.AnySingle;
import com.hp.hpl.jena.graph.query.regexptrees.BackReference;
import com.hp.hpl.jena.graph.query.regexptrees.EndOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.NoneOf;
import com.hp.hpl.jena.graph.query.regexptrees.Nothing;
import com.hp.hpl.jena.graph.query.regexptrees.OneOrMore;
import com.hp.hpl.jena.graph.query.regexptrees.Optional;
import com.hp.hpl.jena.graph.query.regexptrees.Paren;
import com.hp.hpl.jena.graph.query.regexptrees.PerlPatternParser;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTreeGenerator;
import com.hp.hpl.jena.graph.query.regexptrees.Sequence;
import com.hp.hpl.jena.graph.query.regexptrees.SimpleGenerator;
import com.hp.hpl.jena.graph.query.regexptrees.StartOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.Text;
import com.hp.hpl.jena.graph.query.regexptrees.ZeroOrMore;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.Arrays;
import junit.framework.TestSuite;

public class TestPerlyParser
extends GraphTestBase {
    public TestPerlyParser(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPerlyParser.class);
    }

    public void testAlternateGenerator() {
        SimpleGenerator g = new SimpleGenerator(){

            public RegexpTree getAnySingle() {
                throw new FlagException();
            }
        };
        PerlPatternParser p = new PerlPatternParser(".", (RegexpTreeGenerator)g);
        try {
            p.parseAtom();
            TestPerlyParser.fail((String)"should be using supplied generator");
        }
        catch (FlagException e) {
            TestPerlyParser.pass();
        }
    }

    public void testLit() {
        TestPerlyParser.assertEquals((Object)Text.create((String)"a"), (Object)Text.create((String)"a"));
        TestPerlyParser.assertDiffer(Text.create((String)"a"), Text.create((String)"b"));
        TestPerlyParser.assertEquals((int)Text.create((String)"aga").hashCode(), (int)Text.create((String)"aga").hashCode());
    }

    public void testInitialParserState() {
        TestPerlyParser.assertEquals((int)0, (int)new PerlPatternParser("hello").getPointer());
        TestPerlyParser.assertEquals((String)"hello", (String)new PerlPatternParser("hello").getString());
    }

    public void testLetterAtoms() {
        for (char ch = '\u0000'; ch < '\u0100'; ch = (char)(ch + '\u0001')) {
            if (!Character.isLetter(ch)) continue;
            PerlPatternParser p = new PerlPatternParser("" + ch);
            TestPerlyParser.assertEquals((Object)Text.create((char)ch), (Object)p.parseAtom());
            TestPerlyParser.assertEquals((int)1, (int)p.getPointer());
        }
    }

    public void testEmptyExpression() {
        TestPerlyParser.assertEquals((Object)new Nothing(), (Object)this.element(""));
    }

    public void testDotAtom() {
        this.testSimpleSpecialAtom(RegexpTree.ANY, ".");
    }

    public void testHatAtom() {
        this.testSimpleSpecialAtom(RegexpTree.SOL, "^");
    }

    public void testDollarAtom() {
        this.testSimpleSpecialAtom(RegexpTree.EOL, "$");
    }

    public void testTerminatorsReturnNull() {
        TestPerlyParser.assertEquals((Object)new Nothing(), (Object)this.element("|"));
    }

    public void testSimpleBackslashEscapes() {
        for (char ch = '\u0000'; ch < '\u0100'; ch = (char)(ch + '\u0001')) {
            if ("bBAZnrtfdDwWSsxc0123456789".indexOf(ch) >= 0) continue;
            TestPerlyParser.assertEquals((Object)Text.create((char)ch), (Object)new PerlPatternParser("\\" + ch).parseAtom());
        }
    }

    public void testSpecialBackslashEscapes() {
        String specials = "bBAZ";
        for (int i = 0; i < specials.length(); ++i) {
            try {
                new PerlPatternParser("\\" + specials.charAt(i)).parseAtom();
                TestPerlyParser.fail((String)("backslash escape " + specials.charAt(i)));
                continue;
            }
            catch (PerlPatternParser.SyntaxException e) {
                TestPerlyParser.pass();
            }
        }
    }

    public void testWordEscapes() {
        String letters = "abcdefghijklmnopqrstuvwxyz";
        String wordChars = "0123456789" + letters + "_" + letters.toUpperCase();
        TestPerlyParser.assertEquals((Object)new AnyOf(wordChars), (Object)this.element("\\w"));
        TestPerlyParser.assertEquals((Object)new NoneOf(wordChars), (Object)this.element("\\W"));
    }

    public void testDigitEscapes() {
        TestPerlyParser.assertEquals((Object)new AnyOf("0123456789"), (Object)this.element("\\d"));
        TestPerlyParser.assertEquals((Object)new NoneOf("0123456789"), (Object)this.element("\\D"));
    }

    public void testWhitespaceEscapes() {
        TestPerlyParser.assertEquals((Object)Text.create((String)"\n"), (Object)this.element("\\n"));
        TestPerlyParser.assertEquals((Object)Text.create((String)"\t"), (Object)this.element("\\t"));
        TestPerlyParser.assertEquals((Object)Text.create((String)"\f"), (Object)this.element("\\f"));
        TestPerlyParser.assertEquals((Object)Text.create((String)"\r"), (Object)this.element("\\r"));
        TestPerlyParser.assertEquals((Object)new AnyOf(" \r\n\t\f"), (Object)this.element("\\s"));
        TestPerlyParser.assertEquals((Object)new NoneOf(" \r\n\t\f"), (Object)this.element("\\S"));
    }

    public void testHexEscapes() {
        this.assertParse((RegexpTree)Text.create((String)"\u00ac"), "\\xac");
        this.assertParse((RegexpTree)Text.create((String)"\u00ff"), "\\xff");
        this.assertParse((RegexpTree)Text.create((String)"\u0012"), "\\x12");
        this.assertParse((RegexpTree)Text.create((String)"\u00af"), "\\xAF");
    }

    public void testControlEscapes() {
        this.assertParse((RegexpTree)Text.create((String)"\u0001"), "\\cA");
        this.assertParse((RegexpTree)Text.create((String)"\u001a"), "\\cZ");
    }

    public void testNoQuantifier() {
        RegexpTree d = RegexpTree.ANY;
        TestPerlyParser.assertSame((Object)d, (Object)this.quantifier("", d));
        TestPerlyParser.assertSame((Object)d, (Object)this.quantifier("x", d));
        TestPerlyParser.assertSame((Object)d, (Object)this.quantifier("[", d));
        TestPerlyParser.assertSame((Object)d, (Object)this.quantifier("(", d));
        TestPerlyParser.assertSame((Object)d, (Object)this.quantifier(".", d));
        TestPerlyParser.assertSame((Object)d, (Object)this.quantifier("\\", d));
    }

    public void testStarQuantifier() {
        RegexpTree d = RegexpTree.EOL;
        TestPerlyParser.assertEquals((Object)new ZeroOrMore(d), (Object)this.quantifier("*", d));
    }

    public void testPlusQuantifier() {
        RegexpTree d = RegexpTree.SOL;
        TestPerlyParser.assertEquals((Object)new OneOrMore(d), (Object)this.quantifier("+", d));
    }

    public void testQueryQuantifier() {
        RegexpTree d = RegexpTree.ANY;
        TestPerlyParser.assertEquals((Object)new Optional(d), (Object)this.quantifier("?", d));
    }

    public void testUnboundQuantifiers() {
        this.testUnboundQuantifier("*");
        this.testUnboundQuantifier("+");
        this.testUnboundQuantifier("?");
        this.testUnboundQuantifier("{");
    }

    private void testUnboundQuantifier(String q) {
        PerlPatternParser p = new PerlPatternParser(q);
        try {
            p.parseElement();
            TestPerlyParser.fail((String)("must trap unbound quantifier " + q));
        }
        catch (PerlPatternParser.SyntaxException e) {
            TestPerlyParser.pass();
        }
    }

    public void testUnitSeq() {
        PerlPatternParser p = new PerlPatternParser("x");
        TestPerlyParser.assertEquals((Object)Text.create((String)"x"), (Object)p.parseSeq());
    }

    public void testSeq() {
        PerlPatternParser p = new PerlPatternParser("^.$");
        TestPerlyParser.assertEquals((Object)this.seq3((RegexpTree)new StartOfLine(), (RegexpTree)new AnySingle(), (RegexpTree)new EndOfLine()), (Object)p.parseSeq());
    }

    public void testBracketConstruction() {
        this.assertParse((RegexpTree)new Paren((RegexpTree)Text.create((String)"x")), "(x)");
    }

    public void testBracketClosure() {
        PerlPatternParser p = new PerlPatternParser("()y");
        TestPerlyParser.assertEquals((Object)this.seq2((RegexpTree)new Paren((RegexpTree)new Nothing()), (RegexpTree)Text.create((String)"y")), (Object)p.parseAlts());
    }

    public void testDetectsMissingClosingBracket() {
        PerlPatternParser p = new PerlPatternParser("(x");
        try {
            p.parseAlts();
            TestPerlyParser.fail((String)"should detect missing close bracket");
        }
        catch (PerlPatternParser.SyntaxException e) {
            TestPerlyParser.pass();
        }
    }

    public void testAlt() {
        PerlPatternParser L = new PerlPatternParser("abc");
        PerlPatternParser R = new PerlPatternParser("def");
        PerlPatternParser p = new PerlPatternParser("abc|def");
        TestPerlyParser.assertEquals((Object)this.alt(L.parseSeq(), R.parseSeq()), (Object)p.parseAlts());
    }

    public void testSimpleClass() {
        this.assertParse((RegexpTree)new AnyOf("x1B"), "[x1B]");
    }

    public void testSimpleClassNegated() {
        this.assertParse((RegexpTree)new NoneOf("b0#"), "[^b0#]");
    }

    public void testClassRangeAlphabet() {
        this.assertParse((RegexpTree)new AnyOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "[A-Z]");
    }

    public void testClassRangeSomeLetters() {
        this.assertParse((RegexpTree)new AnyOf("abcdef"), "[a-f]");
    }

    public void testClassRangeDigits() {
        this.assertParse((RegexpTree)new AnyOf("abc0123456789rst"), "[a-c0-9r-t]");
    }

    public void testClassHats() {
        this.assertParse((RegexpTree)new AnyOf("ab^cd"), "[ab^cd]");
    }

    public void testClassRange() {
        this.assertParse((RegexpTree)new AnyOf("-R"), "[-R]");
    }

    public void testClassBackslash() {
        this.assertParse((RegexpTree)new AnyOf("]"), "[\\]]");
    }

    public void testBackReference() {
        this.assertParse(this.seq2((RegexpTree)new Paren((RegexpTree)Text.create((String)"x")), (RegexpTree)new BackReference(1)), "(x)\\1");
    }

    public void testOctalNonBackReference() {
        this.assertParse(this.seq2((RegexpTree)new Paren((RegexpTree)Text.create((String)"x")), (RegexpTree)Text.create((String)"\b")), "(x)\\10");
    }

    protected RegexpTree seq2(RegexpTree a, RegexpTree b) {
        return Sequence.create(Arrays.asList(a, b));
    }

    protected RegexpTree seq3(RegexpTree a, RegexpTree b, RegexpTree c) {
        return Sequence.create(Arrays.asList(a, b, c));
    }

    protected RegexpTree alt(RegexpTree L, RegexpTree R) {
        return Alternatives.create(Arrays.asList(L, R));
    }

    public void testPerlParse() {
        TestPerlyParser.assertInstanceOf(Alternatives.class, PerlPatternParser.parse((String)"this is|a pattern"));
        TestPerlyParser.assertInstanceOf(Alternatives.class, PerlPatternParser.parse((String)"this is|a pattern", (RegexpTreeGenerator)new SimpleGenerator()));
    }

    public void testOldSeq() {
        PerlPatternParser p = new PerlPatternParser("hello");
        TestPerlyParser.assertEquals((Object)Text.create((String)"h"), (Object)p.parseAtom());
        TestPerlyParser.assertEquals((int)1, (int)p.getPointer());
        TestPerlyParser.assertEquals((Object)Text.create((String)"e"), (Object)p.parseAtom());
        TestPerlyParser.assertEquals((int)2, (int)p.getPointer());
        TestPerlyParser.assertEquals((Object)Text.create((String)"l"), (Object)p.parseAtom());
        TestPerlyParser.assertEquals((int)3, (int)p.getPointer());
        TestPerlyParser.assertEquals((Object)Text.create((String)"l"), (Object)p.parseAtom());
        TestPerlyParser.assertEquals((int)4, (int)p.getPointer());
        TestPerlyParser.assertEquals((Object)Text.create((String)"o"), (Object)p.parseAtom());
        TestPerlyParser.assertEquals((int)5, (int)p.getPointer());
        TestPerlyParser.assertEquals((Object)new Nothing(), (Object)p.parseAtom());
    }

    public void assertParse(RegexpTree wanted, String toParse) {
        TestPerlyParser.assertEquals((Object)wanted, (Object)new PerlPatternParser(toParse).parseAlts());
    }

    public void testSimpleSpecialAtom(Object wanted, String toParse) {
        PerlPatternParser p = new PerlPatternParser(toParse);
        TestPerlyParser.assertEquals((Object)wanted, (Object)p.parseAtom());
        TestPerlyParser.assertEquals((int)1, (int)p.getPointer());
    }

    protected RegexpTree quantifier(String toParse, RegexpTree x) {
        return new PerlPatternParser(toParse).parseQuantifier(x);
    }

    protected RegexpTree element(String toParse) {
        return new PerlPatternParser(toParse).parseElement();
    }

    protected static class FlagException
    extends RuntimeException {
        protected FlagException() {
        }
    }
}

