/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import java.io.IOException;
import java.io.Reader;
import org.noggit.CharArr;
import org.noggit.JSONUtil;
import org.noggit.NullCharArr;

public class JSONParser {
    public static final int STRING = 1;
    public static final int LONG = 2;
    public static final int NUMBER = 3;
    public static final int BIGNUMBER = 4;
    public static final int BOOLEAN = 5;
    public static final int NULL = 6;
    public static final int OBJECT_START = 7;
    public static final int OBJECT_END = 8;
    public static final int ARRAY_START = 9;
    public static final int ARRAY_END = 10;
    public static final int EOF = 11;
    private static final CharArr devNull = new NullCharArr();
    final char[] buf;
    int start;
    int end;
    final Reader in;
    boolean eof = false;
    long gpos;
    int event;
    private final CharArr out = new CharArr(64);
    private byte[] stack = new byte[16];
    private int ptr = 0;
    private byte state = 0;
    private static final byte DID_OBJSTART = 1;
    private static final byte DID_ARRSTART = 2;
    private static final byte DID_ARRELEM = 3;
    private static final byte DID_MEMNAME = 4;
    private static final byte DID_MEMVAL = 5;
    private int valstate;
    private boolean bool;
    private long lval;
    private int nstate;
    private static final int HAS_FRACTION = 1;
    private static final int HAS_EXPONENT = 2;
    private final CharArr tmp = new CharArr(null, 0, 0);

    public static String getEventString(int n) {
        switch (n) {
            case 1: {
                return "STRING";
            }
            case 2: {
                return "LONG";
            }
            case 3: {
                return "NUMBER";
            }
            case 4: {
                return "BIGNUMBER";
            }
            case 5: {
                return "BOOLEAN";
            }
            case 6: {
                return "NULL";
            }
            case 7: {
                return "OBJECT_START";
            }
            case 8: {
                return "OBJECT_END";
            }
            case 9: {
                return "ARRAY_START";
            }
            case 10: {
                return "ARRAY_END";
            }
            case 11: {
                return "EOF";
            }
        }
        return "Unknown: " + n;
    }

    public JSONParser(Reader reader) {
        this(reader, new char[8192]);
    }

    public JSONParser(Reader reader, char[] cArray) {
        this.in = reader;
        this.buf = cArray;
    }

    public JSONParser(char[] cArray, int n, int n2) {
        this.in = null;
        this.buf = cArray;
        this.start = n;
        this.end = n2;
    }

    public JSONParser(String string) {
        this(string, 0, string.length());
    }

    public JSONParser(String string, int n, int n2) {
        this.in = null;
        this.start = n;
        this.end = n2;
        this.buf = new char[n2 - n];
        string.getChars(n, n2, this.buf, 0);
    }

    private final void push() {
        if (this.ptr >= this.stack.length) {
            byte[] byArray = new byte[this.stack.length << 1];
            System.arraycopy(this.stack, 0, byArray, 0, this.stack.length);
            this.stack = byArray;
        }
        this.stack[this.ptr++] = this.state;
    }

    private final void pop() {
        if (--this.ptr < 0) {
            throw this.err("Unbalanced container");
        }
        this.state = this.stack[this.ptr];
    }

    protected void fill() throws IOException {
        if (this.in != null) {
            this.gpos += (long)this.end;
            this.start = 0;
            int n = this.in.read(this.buf, 0, this.buf.length);
            int n2 = this.end = n >= 0 ? n : 0;
        }
        if (this.start >= this.end) {
            this.eof = true;
        }
    }

    private void getMore() throws IOException {
        this.fill();
        if (this.start >= this.end) {
            throw this.err(null);
        }
    }

    protected int getChar() throws IOException {
        if (this.start >= this.end) {
            this.fill();
            if (this.start >= this.end) {
                return -1;
            }
        }
        return this.buf[this.start++];
    }

    private int getCharNWS() throws IOException {
        int n;
        while ((n = this.getChar()) == 32 || n == 9 || n == 10 || n == 13) {
        }
        return n;
    }

    private void expect(char[] cArray) throws IOException {
        for (int i = 1; i < cArray.length; ++i) {
            int n = this.getChar();
            if (n == cArray[i]) continue;
            throw this.err("Expected " + new String(cArray));
        }
    }

    private ParseException err(String string) {
        if (!this.eof && this.start > 0) {
            --this.start;
        }
        String string2 = "char=" + (this.start >= this.end ? "(EOF)" : "" + this.buf[this.start]);
        String string3 = "position=" + (this.gpos + (long)this.start);
        String string4 = string2 + ',' + string3 + this.getContext();
        if (string == null) {
            string = this.start >= this.end ? "Unexpected EOF" : "JSON Parse Error";
        }
        return new ParseException(string + ": " + string4);
    }

    private String getContext() {
        String string = "";
        if (this.start >= 0) {
            string = string + " BEFORE='" + this.errEscape(Math.max(this.start - 60, 0), this.start + 1) + "'";
        }
        if (this.start < this.end) {
            string = string + " AFTER='" + this.errEscape(this.start + 1, this.start + 40) + "'";
        }
        return string;
    }

    private String errEscape(int n, int n2) {
        if (n >= (n2 = Math.min(n2, this.end))) {
            return "";
        }
        return new String(this.buf, n, n2 - n).replaceAll("\\s+", " ");
    }

    private long readNumber(int n, boolean bl) throws IOException {
        long l;
        int n2;
        int n3;
        this.out.unsafeWrite(n);
        long l2 = 48 - n;
        block10: for (n3 = 0; n3 < 17; ++n3) {
            n2 = this.getChar();
            switch (n2) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    l2 = l2 * 10L - (long)(n2 - 48);
                    this.out.unsafeWrite(n2);
                    continue block10;
                }
                case 46: {
                    this.out.unsafeWrite('.');
                    this.valstate = this.readFrac(this.out, 22 - n3);
                    return 0L;
                }
                case 69: 
                case 101: {
                    this.out.unsafeWrite(n2);
                    this.nstate = 0;
                    this.valstate = this.readExp(this.out, 22 - n3);
                    return 0L;
                }
                default: {
                    if (n2 != -1) {
                        --this.start;
                    }
                    this.valstate = 2;
                    return bl ? l2 : -l2;
                }
            }
        }
        n2 = 0;
        long l3 = l = bl ? Long.MIN_VALUE : -9223372036854775807L;
        while (n3 < 22) {
            int n4 = this.getChar();
            switch (n4) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int n5;
                    if (l2 < -922337203685477580L) {
                        n2 = 1;
                    }
                    if ((l2 *= 10L) < l + (long)(n5 = n4 - 48)) {
                        n2 = 1;
                    }
                    l2 -= (long)n5;
                    this.out.unsafeWrite(n4);
                    break;
                }
                case 46: {
                    this.out.unsafeWrite('.');
                    this.valstate = this.readFrac(this.out, 22 - n3);
                    return 0L;
                }
                case 69: 
                case 101: {
                    this.out.unsafeWrite(n4);
                    this.nstate = 0;
                    this.valstate = this.readExp(this.out, 22 - n3);
                    return 0L;
                }
                default: {
                    if (n4 != -1) {
                        --this.start;
                    }
                    this.valstate = n2 != 0 ? 4 : 2;
                    return bl ? l2 : -l2;
                }
            }
            ++n3;
        }
        this.nstate = 0;
        this.valstate = 4;
        return 0L;
    }

    private int readFrac(CharArr charArr, int n) throws IOException {
        this.nstate = 1;
        while (--n >= 0) {
            int n2 = this.getChar();
            if (n2 >= 48 && n2 <= 57) {
                charArr.write(n2);
                continue;
            }
            if (n2 == 101 || n2 == 69) {
                charArr.write(n2);
                return this.readExp(charArr, n);
            }
            if (n2 != -1) {
                --this.start;
            }
            return 3;
        }
        return 4;
    }

    private int readExp(CharArr charArr, int n) throws IOException {
        this.nstate |= 2;
        int n2 = this.getChar();
        --n;
        if (n2 == 43 || n2 == 45) {
            charArr.write(n2);
            n2 = this.getChar();
            --n;
        }
        if (n2 < 48 || n2 > 57) {
            throw this.err("missing exponent number");
        }
        charArr.write(n2);
        return this.readExpDigits(charArr, n);
    }

    private int readExpDigits(CharArr charArr, int n) throws IOException {
        while (--n >= 0) {
            int n2 = this.getChar();
            if (n2 >= 48 && n2 <= 57) {
                charArr.write(n2);
                continue;
            }
            if (n2 != -1) {
                --this.start;
            }
            return 3;
        }
        return 4;
    }

    private void continueNumber(CharArr charArr) throws IOException {
        int n;
        if (charArr != this.out) {
            charArr.write(this.out);
        }
        if ((this.nstate & 2) != 0) {
            this.readExpDigits(charArr, Integer.MAX_VALUE);
            return;
        }
        if (this.nstate != 0) {
            this.readFrac(charArr, Integer.MAX_VALUE);
            return;
        }
        while ((n = this.getChar()) >= 48 && n <= 57) {
            charArr.write(n);
        }
        if (n == 46) {
            charArr.write(n);
            this.readFrac(charArr, Integer.MAX_VALUE);
            return;
        }
        if (n == 101 || n == 69) {
            charArr.write(n);
            this.readExp(charArr, Integer.MAX_VALUE);
            return;
        }
        if (n != -1) {
            --this.start;
        }
    }

    private int hexval(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 65 && n <= 70) {
            return n + -55;
        }
        if (n >= 97 && n <= 102) {
            return n + -87;
        }
        throw this.err("invalid hex digit");
    }

    private char readEscapedChar() throws IOException {
        switch (this.getChar()) {
            case 34: {
                return '\"';
            }
            case 92: {
                return '\\';
            }
            case 47: {
                return '/';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 102: {
                return '\f';
            }
            case 98: {
                return '\b';
            }
            case 117: {
                return (char)(this.hexval(this.getChar()) << 12 | this.hexval(this.getChar()) << 8 | this.hexval(this.getChar()) << 4 | this.hexval(this.getChar()));
            }
        }
        throw this.err("Invalid character escape in string");
    }

    private CharArr readStringChars() throws IOException {
        int n;
        char c = '\u0000';
        for (n = this.start; n < this.end; ++n) {
            c = this.buf[n];
            if (c == '\"') {
                this.tmp.set(this.buf, this.start, n);
                this.start = n + 1;
                return this.tmp;
            }
            if (c == '\\') break;
        }
        this.out.reset();
        this.readStringChars2(this.out, n);
        return this.out;
    }

    private void readStringChars2(CharArr charArr, int n) throws IOException {
        while (true) {
            int n2;
            char c;
            if (n >= this.end) {
                charArr.write(this.buf, this.start, n - this.start);
                this.start = n;
                this.getMore();
                n = this.start;
            }
            if ((c = this.buf[n++]) == '\"') {
                n2 = n - this.start - 1;
                if (n2 > 0) {
                    charArr.write(this.buf, this.start, n2);
                }
                this.start = n;
                return;
            }
            if (c != '\\') continue;
            n2 = n - this.start - 1;
            if (n2 > 0) {
                charArr.write(this.buf, this.start, n2);
            }
            this.start = n;
            charArr.write(this.readEscapedChar());
            n = this.start;
        }
    }

    private int next(int n) throws IOException {
        while (true) {
            switch (n) {
                case 9: 
                case 32: {
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
                case 34: {
                    this.valstate = 1;
                    return 1;
                }
                case 123: {
                    this.push();
                    this.state = 1;
                    return 7;
                }
                case 91: {
                    this.push();
                    this.state = (byte)2;
                    return 9;
                }
                case 48: {
                    this.out.reset();
                    n = this.getChar();
                    if (n == 46) {
                        --this.start;
                        n = 48;
                        this.readNumber(48, false);
                        return this.valstate;
                    }
                    if (n > 57 || n < 48) {
                        this.out.unsafeWrite('0');
                        if (n != -1) {
                            --this.start;
                        }
                        this.lval = 0L;
                        this.valstate = 2;
                        return 2;
                    }
                    throw this.err("Leading zeros not allowed");
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.out.reset();
                    this.lval = this.readNumber(n, false);
                    return this.valstate;
                }
                case 45: {
                    this.out.reset();
                    this.out.unsafeWrite('-');
                    n = this.getChar();
                    if (n < 48 || n > 57) {
                        throw this.err("expected digit after '-'");
                    }
                    this.lval = this.readNumber(n, true);
                    return this.valstate;
                }
                case 116: {
                    this.valstate = 5;
                    this.expect(JSONUtil.TRUE_CHARS);
                    this.bool = true;
                    return 5;
                }
                case 102: {
                    this.valstate = 5;
                    this.expect(JSONUtil.FALSE_CHARS);
                    this.bool = false;
                    return 5;
                }
                case 110: {
                    this.valstate = 6;
                    this.expect(JSONUtil.NULL_CHARS);
                    return 6;
                }
                case -1: {
                    if (this.getLevel() > 0) {
                        throw this.err("Premature EOF");
                    }
                    return 11;
                }
                default: {
                    throw this.err(null);
                }
            }
            n = this.getChar();
        }
    }

    public String toString() {
        return "start=" + this.start + ",end=" + this.end + ",state=" + this.state + "valstate=" + this.valstate;
    }

    public int nextEvent() throws IOException {
        if (this.valstate == 1) {
            this.readStringChars2(devNull, this.start);
        } else if (this.valstate == 4) {
            this.continueNumber(devNull);
        }
        this.valstate = 0;
        switch (this.state) {
            case 0: {
                this.event = this.next(this.getCharNWS());
                return this.event;
            }
            case 1: {
                int n = this.getCharNWS();
                if (n == 125) {
                    this.pop();
                    this.event = 8;
                    return 8;
                }
                if (n != 34) {
                    throw this.err("Expected string");
                }
                this.state = (byte)4;
                this.valstate = 1;
                this.event = 1;
                return 1;
            }
            case 4: {
                int n = this.getCharNWS();
                if (n != 58) {
                    throw this.err("Expected key,value separator ':'");
                }
                this.state = (byte)5;
                this.event = this.next(this.getChar());
                return this.event;
            }
            case 5: {
                int n = this.getCharNWS();
                if (n == 125) {
                    this.pop();
                    this.event = 8;
                    return 8;
                }
                if (n != 44) {
                    throw this.err("Expected ',' or '}'");
                }
                n = this.getCharNWS();
                if (n != 34) {
                    throw this.err("Expected string");
                }
                this.state = (byte)4;
                this.valstate = 1;
                this.event = 1;
                return 1;
            }
            case 2: {
                int n = this.getCharNWS();
                if (n == 93) {
                    this.pop();
                    this.event = 10;
                    return 10;
                }
                this.state = (byte)3;
                this.event = this.next(n);
                return this.event;
            }
            case 3: {
                int n = this.getCharNWS();
                if (n == 93) {
                    this.pop();
                    this.event = 10;
                    return 10;
                }
                if (n != 44) {
                    throw this.err("Expected ',' or ']'");
                }
                this.event = this.next(this.getChar());
                return this.event;
            }
        }
        return 0;
    }

    public int lastEvent() {
        return this.event;
    }

    public boolean wasKey() {
        return this.state == 4;
    }

    private void goTo(int n) throws IOException {
        if (this.valstate == n) {
            this.valstate = 0;
            return;
        }
        if (this.valstate == 0) {
            int n2 = this.nextEvent();
            if (this.valstate != n) {
                throw this.err("type mismatch");
            }
        } else {
            throw this.err("type mismatch");
        }
        this.valstate = 0;
    }

    public String getString() throws IOException {
        return this.getStringChars().toString();
    }

    public CharArr getStringChars() throws IOException {
        this.goTo(1);
        return this.readStringChars();
    }

    public void getString(CharArr charArr) throws IOException {
        this.goTo(1);
        this.readStringChars2(charArr, this.start);
    }

    public long getLong() throws IOException {
        this.goTo(2);
        return this.lval;
    }

    public double getDouble() throws IOException {
        return Double.parseDouble(this.getNumberChars().toString());
    }

    public CharArr getNumberChars() throws IOException {
        int n = 0;
        if (this.valstate == 0) {
            n = this.nextEvent();
        }
        if (this.valstate == 2 || this.valstate == 3) {
            this.valstate = 0;
            return this.out;
        }
        if (this.valstate == 4) {
            this.continueNumber(this.out);
            this.valstate = 0;
            return this.out;
        }
        throw this.err("Unexpected " + n);
    }

    public void getNumberChars(CharArr charArr) throws IOException {
        int n = 0;
        if (this.valstate == 0) {
            n = this.nextEvent();
        }
        if (this.valstate == 2 || this.valstate == 3) {
            charArr.write(this.out);
        } else if (this.valstate == 4) {
            this.continueNumber(charArr);
        } else {
            throw this.err("Unexpected " + n);
        }
        this.valstate = 0;
    }

    public boolean getBoolean() throws IOException {
        this.goTo(5);
        return this.bool;
    }

    public void getNull() throws IOException {
        this.goTo(6);
    }

    public int getLevel() {
        return this.ptr;
    }

    public long getPosition() {
        return this.gpos + (long)this.start;
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String string) {
            super(string);
        }
    }
}

