/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.noggit.CharArr;
import org.noggit.JSONUtil;

public class JSONWriter {
    protected int level;
    protected int indent;
    protected final CharArr out;

    public JSONWriter(CharArr charArr, int n) {
        this.out = charArr;
        this.indent = n;
    }

    public JSONWriter(CharArr charArr) {
        this(charArr, 2);
    }

    public void setIndentSize(int n) {
        this.indent = n;
    }

    public void indent() {
        if (this.indent >= 0) {
            this.out.write('\n');
            if (this.indent > 0) {
                int n = this.level * this.indent;
                this.out.reserve(n);
                for (int i = 0; i < n; ++i) {
                    this.out.unsafeWrite(' ');
                }
            }
        }
    }

    public void write(Object object) {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof CharSequence) {
            this.writeString((CharSequence)object);
        } else if (object instanceof Number) {
            if (object instanceof Integer || object instanceof Long) {
                this.write(((Number)object).longValue());
            } else if (object instanceof Float || object instanceof Double) {
                this.write(((Number)object).doubleValue());
            } else {
                CharArr charArr = new CharArr();
                charArr.write(object.toString());
                this.writeNumber(charArr);
            }
        } else if (object instanceof Map) {
            this.write((Map)object);
        } else if (object instanceof Collection) {
            this.write((Collection)object);
        } else if (object instanceof Object[]) {
            this.write(Arrays.asList((Object[])object));
        } else if (object instanceof Boolean) {
            this.write((Boolean)object);
        } else if (object instanceof Writable) {
            ((Writable)object).write(this);
        } else if (object instanceof int[]) {
            this.write((int[])object);
        } else if (object instanceof float[]) {
            this.write((float[])object);
        } else if (object instanceof long[]) {
            this.write((long[])object);
        } else if (object instanceof double[]) {
            this.write((double[])object);
        } else if (object instanceof short[]) {
            this.write((short[])object);
        } else if (object instanceof boolean[]) {
            this.write((boolean[])object);
        } else if (object instanceof char[]) {
            this.write((char[])object);
        } else if (object instanceof byte[]) {
            this.write((byte[])object);
        } else {
            this.handleUnknownClass(object);
        }
    }

    public void handleUnknownClass(Object object) {
        this.writeString(this.out.toString());
    }

    public void write(Map map) {
        this.startObject();
        int n = map.size();
        boolean bl = true;
        for (Map.Entry entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                this.writeValueSeparator();
            }
            if (n > 1) {
                this.indent();
            }
            this.writeString(entry.getKey().toString());
            this.writeNameSeparator();
            this.write(entry.getValue());
        }
        this.endObject();
    }

    public void write(Collection collection) {
        this.startArray();
        int n = collection.size();
        boolean bl = true;
        for (Object e : collection) {
            if (bl) {
                bl = false;
            } else {
                this.writeValueSeparator();
            }
            if (n > 1) {
                this.indent();
            }
            this.write(e);
        }
        this.endArray();
    }

    public void write(byte[] byArray) {
        this.startArray();
        boolean bl = true;
        byte[] byArray2 = byArray;
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            short s = byArray2[i];
            if (bl) {
                bl = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(s);
        }
        this.endArray();
    }

    public void write(short[] sArray) {
        this.startArray();
        boolean bl = true;
        for (short s : sArray) {
            if (bl) {
                bl = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(s);
        }
        this.endArray();
    }

    public void write(int[] nArray) {
        this.startArray();
        boolean bl = true;
        for (int n : nArray) {
            if (bl) {
                bl = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(n);
        }
        this.endArray();
    }

    public void write(long[] lArray) {
        this.startArray();
        boolean bl = true;
        for (long l : lArray) {
            if (bl) {
                bl = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(l);
        }
        this.endArray();
    }

    public void write(float[] fArray) {
        this.startArray();
        boolean bl = true;
        for (float f : fArray) {
            if (bl) {
                bl = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(f);
        }
        this.endArray();
    }

    public void write(double[] dArray) {
        this.startArray();
        boolean bl = true;
        for (double d : dArray) {
            if (bl) {
                bl = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(d);
        }
        this.endArray();
    }

    public void write(boolean[] blArray) {
        this.startArray();
        boolean bl = true;
        for (boolean bl2 : blArray) {
            if (bl) {
                bl = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(bl2);
        }
        this.endArray();
    }

    public void write(short s) {
        this.write((int)s);
    }

    public void write(byte by) {
        this.write((int)by);
    }

    public void writeNull() {
        JSONUtil.writeNull(this.out);
    }

    public void writeString(CharSequence charSequence) {
        JSONUtil.writeString(charSequence, 0, charSequence.length(), this.out);
    }

    public void writeString(CharArr charArr) {
        JSONUtil.writeString(charArr, this.out);
    }

    public void writeStringStart() {
        this.out.write('\"');
    }

    public void writeStringChars(CharArr charArr) {
        JSONUtil.writeStringPart(charArr.getArray(), charArr.getStart(), charArr.getEnd(), this.out);
    }

    public void writeStringEnd() {
        this.out.write('\"');
    }

    public void write(long l) {
        JSONUtil.writeNumber(l, this.out);
    }

    public void write(int n) {
        JSONUtil.writeNumber(n, this.out);
    }

    public void write(double d) {
        JSONUtil.writeNumber(d, this.out);
    }

    public void write(float f) {
        JSONUtil.writeNumber(f, this.out);
    }

    public void write(boolean bl) {
        JSONUtil.writeBoolean(bl, this.out);
    }

    public void write(char[] cArray) {
        JSONUtil.writeString(cArray, 0, cArray.length, this.out);
    }

    public void writeNumber(CharArr charArr) {
        this.out.write(charArr);
    }

    public void writePartialNumber(CharArr charArr) {
        this.out.write(charArr);
    }

    public void startObject() {
        this.out.write('{');
        ++this.level;
    }

    public void endObject() {
        this.out.write('}');
        --this.level;
    }

    public void startArray() {
        this.out.write('[');
        ++this.level;
    }

    public void endArray() {
        this.out.write(']');
        --this.level;
    }

    public void writeValueSeparator() {
        this.out.write(',');
    }

    public void writeNameSeparator() {
        this.out.write(':');
    }

    public static interface Writable {
        public void write(JSONWriter var1);
    }
}

