/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import java.io.IOException;
import java.nio.CharBuffer;

public class CharArr
implements CharSequence,
Appendable {
    protected char[] buf;
    protected int start;
    protected int end;

    public CharArr() {
        this(32);
    }

    public CharArr(int n) {
        this.buf = new char[n];
    }

    public CharArr(char[] cArray, int n, int n2) {
        this.set(cArray, n, n2);
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public void set(char[] cArray, int n, int n2) {
        this.buf = cArray;
        this.start = n;
        this.end = n2;
    }

    public char[] getArray() {
        return this.buf;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public int length() {
        return this.size();
    }

    public int capacity() {
        return this.buf.length;
    }

    @Override
    public char charAt(int n) {
        return this.buf[this.start + n];
    }

    @Override
    public CharArr subSequence(int n, int n2) {
        return new CharArr(this.buf, this.start + n, this.start + n2);
    }

    public int read() throws IOException {
        if (this.start >= this.end) {
            return -1;
        }
        return this.buf[this.start++];
    }

    public int read(char[] cArray, int n, int n2) {
        return 0;
    }

    public void unsafeWrite(char c) {
        this.buf[this.end++] = c;
    }

    public void unsafeWrite(int n) {
        this.unsafeWrite((char)n);
    }

    public void unsafeWrite(char[] cArray, int n, int n2) {
        System.arraycopy(cArray, n, this.buf, this.end, n2);
        this.end += n2;
    }

    protected void resize(int n) {
        char[] cArray = new char[Math.max(this.buf.length << 1, n)];
        System.arraycopy(this.buf, this.start, cArray, 0, this.size());
        this.buf = cArray;
    }

    public void reserve(int n) {
        if (this.end + n > this.buf.length) {
            this.resize(this.end + n);
        }
    }

    public void write(char c) {
        if (this.end >= this.buf.length) {
            this.resize(this.end + 1);
        }
        this.unsafeWrite(c);
    }

    public final void write(int n) {
        this.write((char)n);
    }

    public final void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) {
        this.reserve(n2);
        this.unsafeWrite(cArray, n, n2);
    }

    public final void write(CharArr charArr) {
        this.write(charArr.buf, this.start, this.end - this.start);
    }

    public final void write(String string) {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n, int n2) {
        this.reserve(n2);
        string.getChars(n, n2, this.buf, this.end);
        this.end += n2;
    }

    public void flush() {
    }

    public final void reset() {
        this.end = 0;
        this.start = 0;
    }

    public void close() {
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.size()];
        System.arraycopy(this.buf, this.start, cArray, 0, this.size());
        return cArray;
    }

    @Override
    public String toString() {
        return new String(this.buf, this.start, this.size());
    }

    public int read(CharBuffer charBuffer) throws IOException {
        int n = this.size();
        if (n > 0) {
            charBuffer.put(this.buf, this.start, n);
        }
        this.start = this.end;
        while (true) {
            this.fill();
            int n2 = this.size();
            if (n2 == 0) {
                return n == 0 ? -1 : n;
            }
            n += n2;
            charBuffer.put(this.buf, this.start, n2);
        }
    }

    public int fill() throws IOException {
        return 0;
    }

    @Override
    public final Appendable append(CharSequence charSequence) throws IOException {
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
        this.write(((Object)charSequence.subSequence(n, n2)).toString());
        return null;
    }

    @Override
    public final Appendable append(char c) throws IOException {
        this.write(c);
        return this;
    }
}

