/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class JSONUtil {
    public static final char[] TRUE_CHARS = new char[]{'t', 'r', 'u', 'e'};
    public static final char[] FALSE_CHARS = new char[]{'f', 'a', 'l', 's', 'e'};
    public static final char[] NULL_CHARS = new char[]{'n', 'u', 'l', 'l'};
    public static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char VALUE_SEPARATOR = ',';
    public static final char NAME_SEPARATOR = ':';
    public static final char OBJECT_START = '{';
    public static final char OBJECT_END = '}';
    public static final char ARRAY_START = '[';
    public static final char ARRAY_END = ']';

    public static String toJSON(Object object) {
        CharArr charArr = new CharArr();
        new JSONWriter(charArr).write(object);
        return charArr.toString();
    }

    public static String toJSON(Object object, int n) {
        CharArr charArr = new CharArr();
        new JSONWriter(charArr, n).write(object);
        return charArr.toString();
    }

    public static void writeNumber(int n, CharArr charArr) {
        charArr.write(Integer.toString(n));
    }

    public static void writeNumber(long l, CharArr charArr) {
        charArr.write(Long.toString(l));
    }

    public static void writeNumber(float f, CharArr charArr) {
        charArr.write(Float.toString(f));
    }

    public static void writeNumber(double d, CharArr charArr) {
        charArr.write(Double.toString(d));
    }

    public static void writeString(CharArr charArr, CharArr charArr2) {
        JSONUtil.writeString(charArr.getArray(), charArr.getStart(), charArr.getEnd(), charArr2);
    }

    public static void writeString(char[] cArray, int n, int n2, CharArr charArr) {
        charArr.write('\"');
        JSONUtil.writeStringPart(cArray, n, n2, charArr);
        charArr.write('\"');
    }

    public static void writeString(CharSequence charSequence, int n, int n2, CharArr charArr) {
        charArr.write('\"');
        JSONUtil.writeStringPart(charSequence, n, n2, charArr);
        charArr.write('\"');
    }

    public static void writeStringPart(char[] cArray, int n, int n2, CharArr charArr) {
        block8: for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\"': 
                case '\\': {
                    charArr.write('\\');
                    charArr.write(c);
                    continue block8;
                }
                case '\r': {
                    charArr.write('\\');
                    charArr.write('r');
                    continue block8;
                }
                case '\n': {
                    charArr.write('\\');
                    charArr.write('n');
                    continue block8;
                }
                case '\t': {
                    charArr.write('\\');
                    charArr.write('t');
                    continue block8;
                }
                case '\b': {
                    charArr.write('\\');
                    charArr.write('b');
                    continue block8;
                }
                case '\f': {
                    charArr.write('\\');
                    charArr.write('f');
                    continue block8;
                }
                default: {
                    if (c <= '\u001f') {
                        JSONUtil.unicodeEscape(c, charArr);
                        continue block8;
                    }
                    if (c == '\u2028' || c == '\u2029') {
                        JSONUtil.unicodeEscape(c, charArr);
                        continue block8;
                    }
                    charArr.write(c);
                }
            }
        }
    }

    public static void writeStringPart(CharSequence charSequence, int n, int n2, CharArr charArr) {
        block8: for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    charArr.write('\\');
                    charArr.write(c);
                    continue block8;
                }
                case '\r': {
                    charArr.write('\\');
                    charArr.write('r');
                    continue block8;
                }
                case '\n': {
                    charArr.write('\\');
                    charArr.write('n');
                    continue block8;
                }
                case '\t': {
                    charArr.write('\\');
                    charArr.write('t');
                    continue block8;
                }
                case '\b': {
                    charArr.write('\\');
                    charArr.write('b');
                    continue block8;
                }
                case '\f': {
                    charArr.write('\\');
                    charArr.write('f');
                    continue block8;
                }
                default: {
                    if (c <= '\u001f') {
                        JSONUtil.unicodeEscape(c, charArr);
                        continue block8;
                    }
                    if (c == '\u2028' || c == '\u2029') {
                        JSONUtil.unicodeEscape(c, charArr);
                        continue block8;
                    }
                    charArr.write(c);
                }
            }
        }
    }

    public static void unicodeEscape(int n, CharArr charArr) {
        charArr.write('\\');
        charArr.write('u');
        charArr.write(HEX_CHARS[n >>> 12]);
        charArr.write(HEX_CHARS[n >>> 8 & 0xF]);
        charArr.write(HEX_CHARS[n >>> 4 & 0xF]);
        charArr.write(HEX_CHARS[n & 0xF]);
    }

    public static void writeNull(CharArr charArr) {
        charArr.write(NULL_CHARS);
    }

    public static void writeBoolean(boolean bl, CharArr charArr) {
        charArr.write(bl ? TRUE_CHARS : FALSE_CHARS);
    }
}

