/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionTester {
    public Object valRoot;
    public Object val;
    public Object expectedRoot;
    public Object expected;
    public double delta;
    public List<Object> path;
    public String err;
    private static Set<String> reserved = new HashSet<String>(Arrays.asList("_SKIP_", "_MATCH_", "_ORDERED_", "_UNORDERED_"));

    public CollectionTester(Object val, double delta) {
        this.val = val;
        this.valRoot = val;
        this.delta = delta;
        this.path = new ArrayList<Object>();
    }

    public CollectionTester(Object val) {
        this(val, 1.0E-5);
    }

    public String getPath() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object seg : this.path) {
            if (seg == null) break;
            if (!first) {
                sb.append('/');
            } else {
                first = false;
            }
            if (seg instanceof Integer) {
                sb.append('[');
                sb.append(seg);
                sb.append(']');
                continue;
            }
            sb.append(seg.toString());
        }
        return sb.toString();
    }

    void setPath(Object lastSeg) {
        this.path.set(this.path.size() - 1, lastSeg);
    }

    Object popPath() {
        return this.path.remove(this.path.size() - 1);
    }

    void pushPath(Object lastSeg) {
        this.path.add(lastSeg);
    }

    void setErr(String msg) {
        this.err = msg;
    }

    public boolean match(Object expected) {
        this.expectedRoot = expected;
        this.expected = expected;
        return this.match();
    }

    boolean match() {
        if (this.expected == null && this.val == null) {
            return true;
        }
        if (this.expected instanceof List) {
            return this.matchList();
        }
        if (this.expected instanceof Map) {
            return this.matchMap();
        }
        if (!this.expected.equals(this.val)) {
            if ((this.expected instanceof Integer && this.val instanceof Long || this.expected instanceof Long && this.val instanceof Integer) && ((Number)this.expected).longValue() == ((Number)this.val).longValue()) {
                return true;
            }
            if (this.expected instanceof Float && this.val instanceof Double || this.expected instanceof Double && this.val instanceof Float) {
                double b;
                double a = ((Number)this.expected).doubleValue();
                if (Double.compare(a, b = ((Number)this.val).doubleValue()) == 0) {
                    return true;
                }
                return Math.abs(a - b) < this.delta;
            }
            this.setErr("mismatch: '" + this.expected + "'!='" + this.val + "'");
            return false;
        }
        return true;
    }

    boolean matchList() {
        List expectedList = (List)this.expected;
        List v = this.asList();
        if (v == null) {
            return false;
        }
        int a = 0;
        this.pushPath(null);
        for (int b = 0; a < expectedList.size() || b < v.size(); ++a, ++b) {
            if (a >= expectedList.size() || b >= v.size()) {
                this.popPath();
                this.setErr("List size mismatch");
                return false;
            }
            this.expected = expectedList.get(a);
            this.val = v.get(b);
            this.setPath(b);
            if (this.match()) continue;
            return false;
        }
        this.popPath();
        return true;
    }

    boolean matchMap() {
        Map expectedMap = (Map)this.expected;
        Map<String, Object> v = this.asMap();
        if (v == null) {
            return false;
        }
        boolean ordered = false;
        String skipList = (String)expectedMap.get("_SKIP_");
        String matchList = (String)expectedMap.get("_MATCH_");
        Object orderedStr = expectedMap.get("_ORDERED_");
        Object unorderedStr = expectedMap.get("_UNORDERED_");
        if (orderedStr != null) {
            ordered = true;
        }
        if (unorderedStr != null) {
            ordered = false;
        }
        HashSet match = null;
        if (matchList != null) {
            match = new HashSet(StrUtils.splitSmart((String)matchList, (String)",", (boolean)false));
        }
        HashSet skips = null;
        if (skipList != null) {
            skips = new HashSet(StrUtils.splitSmart((String)skipList, (String)",", (boolean)false));
        }
        Set<Object> keys = match != null ? match : expectedMap.keySet();
        HashSet visited = new HashSet();
        Iterator<Map.Entry<String, Object>> iter = ordered ? v.entrySet().iterator() : null;
        int numExpected = 0;
        this.pushPath(null);
        for (String string : keys) {
            if (reserved.contains(string)) continue;
            ++numExpected;
            this.setPath(string);
            if (!v.containsKey(string)) {
                this.popPath();
                this.setErr("expected key '" + string + "'");
                return false;
            }
            this.expected = expectedMap.get(string);
            if (ordered) {
                Map.Entry<String, Object> entry;
                String foundKey;
                do {
                    if (!iter.hasNext()) {
                        this.popPath();
                        this.setErr("expected key '" + string + "' in ordered map");
                        return false;
                    }
                    entry = iter.next();
                    foundKey = entry.getKey();
                } while (skips != null && skips.contains(foundKey) || match != null && !match.contains(foundKey));
                if (!entry.getKey().equals(string)) {
                    this.popPath();
                    this.setErr("expected key '" + string + "' instead of '" + entry.getKey() + "' in ordered map");
                    return false;
                }
                this.val = entry.getValue();
            } else {
                if (skips != null && skips.contains(string)) continue;
                this.val = v.get(string);
            }
            if (this.match()) continue;
            return false;
        }
        this.popPath();
        if (match == null) {
            int skipped = 0;
            if (skips != null) {
                for (String skipStr : skips) {
                    if (!v.containsKey(skipStr)) continue;
                    ++skipped;
                }
            }
            if (numExpected != v.size() - skipped) {
                HashSet<String> hashSet = new HashSet<String>(v.keySet());
                hashSet.removeAll(expectedMap.keySet());
                this.setErr("unexpected map keys " + hashSet);
                return false;
            }
        }
        return true;
    }

    public boolean seek(String seekPath) {
        if (this.path == null) {
            return true;
        }
        if (seekPath.startsWith("/")) {
            seekPath = seekPath.substring(1);
        }
        if (seekPath.endsWith("/")) {
            seekPath = seekPath.substring(0, seekPath.length() - 1);
        }
        List pathList = StrUtils.splitSmart((String)seekPath, (String)"/", (boolean)false);
        return this.seek(pathList);
    }

    List asList() {
        if (this.val instanceof List) {
            return (List)this.val;
        }
        this.setErr("expected List");
        return null;
    }

    Map<String, Object> asMap() {
        if (this.val instanceof Map) {
            return (Map)this.val;
        }
        this.setErr("expected Map");
        return null;
    }

    public boolean seek(List<String> seekPath) {
        if (seekPath.size() == 0) {
            return true;
        }
        String seg = seekPath.get(0);
        if (seg.charAt(0) == '[') {
            List listVal = this.asList();
            if (listVal == null) {
                return false;
            }
            int arrIdx = Integer.parseInt(seg.substring(1, seg.length() - 1));
            if (arrIdx >= listVal.size()) {
                return false;
            }
            this.val = listVal.get(arrIdx);
            this.pushPath(arrIdx);
        } else {
            Map<String, Object> mapVal = this.asMap();
            if (mapVal == null) {
                return false;
            }
            if (!mapVal.containsKey(seg)) {
                return false;
            }
            this.val = mapVal.get(seg);
            this.pushPath(seg);
        }
        return this.seek(seekPath.subList(1, seekPath.size()));
    }
}

