/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;

public class ExternalPaths {
    private static final String SOURCE_HOME = ExternalPaths.determineSourceHome();
    public static String WEBAPP_HOME = new File(SOURCE_HOME, "webapp/web").getAbsolutePath();
    public static String EXAMPLE_HOME = new File(SOURCE_HOME, "example/solr").getAbsolutePath();
    public static String EXAMPLE_MULTICORE_HOME = new File(SOURCE_HOME, "example/multicore").getAbsolutePath();
    public static String EXAMPLE_SCHEMA = EXAMPLE_HOME + "/conf/schema.xml";
    public static String EXAMPLE_CONFIG = EXAMPLE_HOME + "/conf/solrconfig.xml";

    static String determineSourceHome() {
        File file;
        try {
            file = new File("solr/conf");
            if (!file.exists()) {
                file = new File(Thread.currentThread().getContextClassLoader().getResource("solr/conf").toURI());
            }
        }
        catch (Exception e) {
            file = new File(".");
        }
        File base = file.getAbsoluteFile();
        while (!new File(base, "solr/CHANGES.txt").exists()) {
            base = base.getParentFile();
        }
        return new File(base, "solr/").getAbsolutePath();
    }
}

