/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noggit.CharArr;
import org.noggit.JSONParser;

public class ObjectBuilder {
    final JSONParser parser;

    public static Object fromJSON(String string) throws IOException {
        JSONParser jSONParser = new JSONParser(string);
        return ObjectBuilder.getVal(jSONParser);
    }

    public static Object getVal(JSONParser jSONParser) throws IOException {
        return new ObjectBuilder(jSONParser).getVal();
    }

    public ObjectBuilder(JSONParser jSONParser) throws IOException {
        this.parser = jSONParser;
        if (jSONParser.lastEvent() == 0) {
            jSONParser.nextEvent();
        }
    }

    public Object getVal() throws IOException {
        int n = this.parser.lastEvent();
        switch (n) {
            case 1: {
                return this.getString();
            }
            case 2: {
                return this.getLong();
            }
            case 3: {
                return this.getNumber();
            }
            case 4: {
                return this.getBigNumber();
            }
            case 5: {
                return this.getBoolean();
            }
            case 6: {
                return this.getNull();
            }
            case 7: {
                return this.getObject();
            }
            case 8: {
                return null;
            }
            case 9: {
                return this.getArray();
            }
            case 10: {
                return null;
            }
            case 11: {
                return null;
            }
        }
        return null;
    }

    public Object getString() throws IOException {
        return this.parser.getString();
    }

    public Object getLong() throws IOException {
        return this.parser.getLong();
    }

    public Object getNumber() throws IOException {
        CharArr charArr = this.parser.getNumberChars();
        String string = charArr.toString();
        double d = Double.parseDouble(string);
        if (!Double.isInfinite(d)) {
            return d;
        }
        return new BigDecimal(string);
    }

    public Object getBigNumber() throws IOException {
        int n;
        CharArr charArr = this.parser.getNumberChars();
        String string = charArr.toString();
        while ((n = charArr.read()) != -1) {
            if (n != 46 && n != 101 && n != 69) continue;
            return new BigDecimal(string);
        }
        return new BigInteger(string);
    }

    public Object getBoolean() throws IOException {
        return this.parser.getBoolean();
    }

    public Object getNull() throws IOException {
        this.parser.getNull();
        return null;
    }

    public Object newObject() throws IOException {
        return new LinkedHashMap();
    }

    public Object getKey() throws IOException {
        return this.parser.getString();
    }

    public void addKeyVal(Object object, Object object2, Object object3) throws IOException {
        Object object4 = ((Map)object).put(object2, object3);
    }

    public Object objectEnd(Object object) {
        return object;
    }

    public Object getObject() throws IOException {
        Object object = this.newObject();
        int n;
        while ((n = this.parser.nextEvent()) != 8) {
            Object object2 = this.getKey();
            n = this.parser.nextEvent();
            Object object3 = this.getVal();
            this.addKeyVal(object, object2, object3);
        }
        return this.objectEnd(object);
    }

    public Object newArray() {
        return new ArrayList();
    }

    public void addArrayVal(Object object, Object object2) throws IOException {
        ((List)object).add(object2);
    }

    public Object endArray(Object object) {
        return object;
    }

    public Object getArray() throws IOException {
        Object object = this.newArray();
        int n;
        while ((n = this.parser.nextEvent()) != 10) {
            Object object2 = this.getVal();
            this.addArrayVal(object, object2);
        }
        return this.endArray(object);
    }
}

