/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.store.Directory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.IndexReaderFactory;
import org.apache.solr.core.JmxMonitoredMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrDeletionPolicy;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.StandardDirectoryFactory;
import org.apache.solr.core.StandardIndexReaderFactory;
import org.apache.solr.handler.admin.ShowFileRequestHandler;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.MoreLikeThisComponent;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.StatsComponent;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.CSVResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.PHPResponseWriter;
import org.apache.solr.response.PHPSerializedResponseWriter;
import org.apache.solr.response.PythonResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.RawResponseWriter;
import org.apache.solr.response.RubyResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.VelocityResponseWriter;
import org.apache.solr.response.XMLResponseWriter;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrFieldCacheMBean;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.RunUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SolrCore
implements SolrInfoMBean {
    public static final String version = "1.0";
    public static Logger log = LoggerFactory.getLogger(SolrCore.class);
    private String name;
    private String logid;
    private final CoreDescriptor coreDescriptor;
    private final SolrConfig solrConfig;
    private final SolrResourceLoader resourceLoader;
    private final IndexSchema schema;
    private final String dataDir;
    private final UpdateHandler updateHandler;
    private final long startTime;
    private final RequestHandlers reqHandlers;
    private final Map<String, SearchComponent> searchComponents;
    private final Map<String, UpdateRequestProcessorChain> updateProcessorChains;
    private final Map<String, SolrInfoMBean> infoRegistry;
    private IndexDeletionPolicyWrapper solrDelPolicy;
    private DirectoryFactory directoryFactory;
    private IndexReaderFactory indexReaderFactory;
    @Deprecated
    private static SolrCore instance;
    static int boolean_query_max_clause_count;
    final List<SolrEventListener> firstSearcherListeners = new ArrayList<SolrEventListener>();
    final List<SolrEventListener> newSearcherListeners = new ArrayList<SolrEventListener>();
    private static Set<String> dirs;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private Collection<CloseHook> closeHooks = null;
    private RefCounted<SolrIndexSearcher> _searcher;
    private final LinkedList<RefCounted<SolrIndexSearcher>> _searchers = new LinkedList();
    final ExecutorService searcherExecutor = Executors.newSingleThreadExecutor();
    private int onDeckSearchers;
    private Object searcherLock = new Object();
    private final int maxWarmingSearchers;
    private QueryResponseWriter defaultResponseWriter;
    private final Map<String, QueryResponseWriter> responseWriters = new HashMap<String, QueryResponseWriter>();
    public static final Map<String, QueryResponseWriter> DEFAULT_RESPONSE_WRITERS;
    private final Map<String, QParserPlugin> qParserPlugins = new HashMap<String, QParserPlugin>();
    private final HashMap<String, ValueSourceParser> valueSourceParsers = new HashMap();

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void booleanQueryMaxClauseCount() {
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            if (boolean_query_max_clause_count == Integer.MIN_VALUE) {
                boolean_query_max_clause_count = this.solrConfig.booleanQueryMaxClauseCount;
                BooleanQuery.setMaxClauseCount((int)boolean_query_max_clause_count);
            } else if (boolean_query_max_clause_count != this.solrConfig.booleanQueryMaxClauseCount) {
                log.debug("BooleanQuery.maxClauseCount= " + boolean_query_max_clause_count + ", ignoring " + this.solrConfig.booleanQueryMaxClauseCount);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public SolrResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getConfigResource() {
        return this.solrConfig.getResourceName();
    }

    @Deprecated
    public String getConfigFile() {
        return this.solrConfig.getResourceName();
    }

    public SolrConfig getSolrConfig() {
        return this.solrConfig;
    }

    public String getSchemaResource() {
        return this.schema.getResourceName();
    }

    @Deprecated
    public String getSchemaFile() {
        return this.schema.getResourceName();
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getIndexDir() {
        if (this._searcher == null) {
            return this.dataDir + "index/";
        }
        SolrIndexSearcher searcher = this._searcher.get();
        return searcher.getIndexDir() == null ? this.dataDir + "index/" : searcher.getIndexDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getNewIndexDir() {
        String result;
        block5: {
            File tmp;
            result = this.dataDir + "index/";
            File propsFile = new File(this.dataDir + "index.properties");
            if (!propsFile.exists()) break block5;
            Properties p = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(propsFile);
                p.load(is);
            }
            catch (IOException e) {
                IOUtils.closeQuietly((InputStream)is);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            String s = p.getProperty("index");
            if (s != null && s.trim().length() > 0 && (tmp = new File(this.dataDir + s)).exists() && tmp.isDirectory()) {
                result = this.dataDir + s;
            }
        }
        return result;
    }

    public DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    public IndexReaderFactory getIndexReaderFactory() {
        return this.indexReaderFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
        this.logid = v == null ? "" : "[" + v + "] ";
    }

    public String getLogId() {
        return this.logid;
    }

    public Map<String, SolrInfoMBean> getInfoRegistry() {
        return this.infoRegistry;
    }

    private void initDeletionPolicy() {
        PluginInfo info = this.solrConfig.getPluginInfo(IndexDeletionPolicy.class.getName());
        SolrDeletionPolicy delPolicy = null;
        if (info != null) {
            delPolicy = this.createInstance(info.className, IndexDeletionPolicy.class, "Deletion Policy for SOLR");
            if (delPolicy instanceof NamedListInitializedPlugin) {
                ((NamedListInitializedPlugin)delPolicy).init(info.initArgs);
            }
        } else {
            delPolicy = new SolrDeletionPolicy();
        }
        this.solrDelPolicy = new IndexDeletionPolicyWrapper(delPolicy);
    }

    private void initListeners() {
        Class<SolrEventListener> clazz = SolrEventListener.class;
        String label = "Event Listener";
        for (PluginInfo info : this.solrConfig.getPluginInfos(SolrEventListener.class.getName())) {
            SolrEventListener obj;
            String event = info.attributes.get("event");
            if ("firstSearcher".equals(event)) {
                obj = this.createInitInstance(info, clazz, "Event Listener", null);
                this.firstSearcherListeners.add(obj);
                log.info(this.logid + "Added SolrEventListener for firstSearcher: " + obj);
                continue;
            }
            if (!"newSearcher".equals(event)) continue;
            obj = this.createInitInstance(info, clazz, "Event Listener", null);
            this.newSearcherListeners.add(obj);
            log.info(this.logid + "Added SolrEventListener for newSearcher: " + obj);
        }
    }

    public void registerFirstSearcherListener(SolrEventListener listener) {
        this.firstSearcherListeners.add(listener);
    }

    public void registerNewSearcherListener(SolrEventListener listener) {
        this.newSearcherListeners.add(listener);
    }

    public void registerResponseWriter(String name, QueryResponseWriter responseWriter) {
        this.responseWriters.put(name, responseWriter);
    }

    public SolrIndexSearcher newSearcher(String name) throws IOException {
        return this.newSearcher(name, false);
    }

    public SolrIndexSearcher newSearcher(String name, boolean readOnly) throws IOException {
        return new SolrIndexSearcher(this, this.schema, name, this.directoryFactory.open(this.getIndexDir()), readOnly, false);
    }

    private void initDirectoryFactory() {
        DirectoryFactory dirFactory;
        PluginInfo info = this.solrConfig.getPluginInfo(DirectoryFactory.class.getName());
        if (info != null) {
            dirFactory = (DirectoryFactory)this.getResourceLoader().newInstance(info.className, new String[0]);
            dirFactory.init(info.initArgs);
        } else {
            dirFactory = new StandardDirectoryFactory();
        }
        this.directoryFactory = dirFactory;
    }

    private void initIndexReaderFactory() {
        IndexReaderFactory indexReaderFactory;
        PluginInfo info = this.solrConfig.getPluginInfo(IndexReaderFactory.class.getName());
        if (info != null) {
            indexReaderFactory = (IndexReaderFactory)this.resourceLoader.newInstance(info.className, new String[0]);
            indexReaderFactory.init(info.initArgs);
        } else {
            indexReaderFactory = new StandardIndexReaderFactory();
        }
        this.indexReaderFactory = indexReaderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initIndex() {
        try {
            System.setProperty("org.apache.lucene.lockDir", this.dataDir);
            this.initDirectoryFactory();
            String indexDir = this.getNewIndexDir();
            boolean indexExists = this.getDirectoryFactory().exists(indexDir);
            Class<SolrCore> clazz = SolrCore.class;
            synchronized (SolrCore.class) {
                Directory dir;
                boolean firstTime = dirs.add(new File(indexDir).getCanonicalPath());
                // ** MonitorExit[var4_4] (shouldn't be in output)
                boolean removeLocks = this.solrConfig.unlockOnStartup;
                this.initIndexReaderFactory();
                if (indexExists && firstTime && removeLocks && (dir = SolrIndexWriter.getDirectory(indexDir, this.getDirectoryFactory(), this.solrConfig.mainIndexConfig)) != null) {
                    if (IndexWriter.isLocked((Directory)dir)) {
                        log.warn(this.logid + "WARNING: Solr index directory '" + indexDir + "' is locked.  Unlocking...");
                        IndexWriter.unlock((Directory)dir);
                    }
                    dir.close();
                }
                if (!indexExists) {
                    log.warn(this.logid + "Solr index directory '" + new File(indexDir) + "' doesn't exist." + " Creating new index...");
                    SolrIndexWriter writer = new SolrIndexWriter("SolrCore.initIndex", indexDir, this.getDirectoryFactory(), true, this.schema, this.solrConfig.mainIndexConfig, this.solrDelPolicy);
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T createInstance(String className, Class<T> cast, String msg) {
        Class clazz = null;
        if (msg == null) {
            msg = "SolrCore Object";
        }
        try {
            Constructor<?>[] cons;
            clazz = this.getResourceLoader().findClass(className, new String[0]);
            if (cast != null && !cast.isAssignableFrom(clazz)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " is not a " + cast.getName());
            }
            for (Constructor<?> con : cons = clazz.getConstructors()) {
                Class<?>[] types = con.getParameterTypes();
                if (types.length != 1 || types[0] != SolrCore.class) continue;
                return (T)con.newInstance(this);
            }
            return (T)this.getResourceLoader().newInstance(className, new String[0]);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " failed to instantiate " + cast.getName(), (Throwable)e);
        }
    }

    public <T> T createInitInstance(PluginInfo info, Class<T> cast, String msg, String defClassName) {
        if (info == null) {
            return null;
        }
        T o = this.createInstance(info.className == null ? defClassName : info.className, cast, msg);
        if (o instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)o).init(info);
        } else if (o instanceof NamedListInitializedPlugin) {
            ((NamedListInitializedPlugin)o).init(info.initArgs);
        }
        return o;
    }

    public SolrEventListener createEventListener(String className) {
        return this.createInstance(className, SolrEventListener.class, "Event Listener");
    }

    public SolrRequestHandler createRequestHandler(String className) {
        return this.createInstance(className, SolrRequestHandler.class, "Request Handler");
    }

    private UpdateHandler createUpdateHandler(String className) {
        return this.createInstance(className, UpdateHandler.class, "Update Handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static SolrCore getSolrCore() {
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            if (instance == null) {
                try {
                    CoreContainer.Initializer init = new CoreContainer.Initializer();
                    instance = init.initialize().getCore("");
                }
                catch (Exception xany) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "error creating core", (Throwable)xany);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SolrCore(String dataDir, IndexSchema schema) throws ParserConfigurationException, IOException, SAXException {
        this(null, dataDir, new SolrConfig(), schema, null);
    }

    public SolrCore(String name, String dataDir, SolrConfig config, IndexSchema schema, CoreDescriptor cd) {
        this.coreDescriptor = cd;
        this.setName(name);
        this.resourceLoader = config.getResourceLoader();
        if (dataDir == null && (dataDir = config.getDataDir()) == null) {
            dataDir = cd.getDataDir();
        }
        dataDir = SolrResourceLoader.normalizeDir(dataDir);
        log.info(this.logid + "Opening new SolrCore at " + this.resourceLoader.getInstanceDir() + ", dataDir=" + dataDir);
        if (schema == null) {
            schema = new IndexSchema(config, "schema.xml", null);
        }
        if (config.jmxConfig.enabled) {
            this.infoRegistry = new JmxMonitoredMap(name, String.valueOf(this.hashCode()), config.jmxConfig);
        } else {
            log.info("JMX monitoring not detected for core: " + name);
            this.infoRegistry = new ConcurrentHashMap<String, SolrInfoMBean>();
        }
        this.infoRegistry.put("fieldCache", new SolrFieldCacheMBean());
        this.schema = schema;
        this.dataDir = dataDir;
        this.solrConfig = config;
        this.startTime = System.currentTimeMillis();
        this.maxWarmingSearchers = config.maxWarmingSearchers;
        this.booleanQueryMaxClauseCount();
        this.initListeners();
        this.initDeletionPolicy();
        this.initIndex();
        this.initWriters();
        this.initQParsers();
        this.initValueSourceParsers();
        this.searchComponents = this.loadSearchComponents();
        this.updateProcessorChains = this.loadUpdateProcessorChains();
        this.reqHandlers = new RequestHandlers(this);
        this.reqHandlers.initHandlersFromConfig(this.solrConfig);
        this.initDeprecatedSupport();
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            this.searcherExecutor.submit(new Callable(){

                public Object call() throws Exception {
                    latch.await();
                    return null;
                }
            });
            this.getSearcher(false, false, null);
            String updateHandlerClass = this.solrConfig.getUpdateHandlerInfo().className;
            this.updateHandler = this.createUpdateHandler(updateHandlerClass == null ? DirectUpdateHandler2.class.getName() : updateHandlerClass);
            this.infoRegistry.put("updateHandler", this.updateHandler);
            this.resourceLoader.inform(this.resourceLoader);
            this.resourceLoader.inform(this);
            instance = this;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            latch.countDown();
        }
        this.infoRegistry.put("core", this);
        this.resourceLoader.inform(this.infoRegistry);
    }

    private Map<String, UpdateRequestProcessorChain> loadUpdateProcessorChains() {
        HashMap<String, UpdateRequestProcessorChain> map = new HashMap<String, UpdateRequestProcessorChain>();
        UpdateRequestProcessorChain def = this.initPlugins(map, UpdateRequestProcessorChain.class, UpdateRequestProcessorChain.class.getName());
        if (def == null) {
            def = (UpdateRequestProcessorChain)map.get(null);
        }
        if (def == null) {
            UpdateRequestProcessorFactory[] factories = new UpdateRequestProcessorFactory[]{new LogUpdateProcessorFactory(), new RunUpdateProcessorFactory()};
            def = new UpdateRequestProcessorChain(factories, this);
        }
        map.put(null, def);
        map.put("", def);
        return map;
    }

    public UpdateRequestProcessorChain getUpdateProcessingChain(String name) {
        UpdateRequestProcessorChain chain = this.updateProcessorChains.get(name);
        if (chain == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown UpdateRequestProcessorChain: " + name);
        }
        return chain;
    }

    final void open() {
        this.refCount.incrementAndGet();
    }

    public void close() {
        int count = this.refCount.decrementAndGet();
        if (count > 0) {
            return;
        }
        if (count < 0) {
            log.error("Too many close [count:{}] on {}. Please report this exception to solr-user@lucene.apache.org", (Object)count, (Object)this);
            return;
        }
        log.info(this.logid + " CLOSING SolrCore " + this);
        if (this.closeHooks != null) {
            for (CloseHook hook : this.closeHooks) {
                try {
                    hook.preClose(this);
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (Throwable)e);
                }
            }
        }
        try {
            this.infoRegistry.clear();
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        try {
            this.updateHandler.close();
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        try {
            this.searcherExecutor.shutdown();
            if (!this.searcherExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.error("Timeout waiting for searchExecutor to terminate");
            }
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        try {
            this.closeSearcher();
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        if (this.closeHooks != null) {
            for (CloseHook hook : this.closeHooks) {
                try {
                    hook.postClose(this);
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (Throwable)e);
                }
            }
        }
    }

    public int getOpenCount() {
        return this.refCount.get();
    }

    public boolean isClosed() {
        return this.refCount.get() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.getOpenCount() != 0) {
                log.error("REFCOUNT ERROR: unreferenced " + this + " (" + this.getName() + ") has a reference count of " + this.getOpenCount());
            }
        }
        finally {
            super.finalize();
        }
    }

    public void addCloseHook(CloseHook hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new ArrayList<CloseHook>();
        }
        this.closeHooks.add(hook);
    }

    @Deprecated
    public SolrQueryRequest getPingQueryRequest() {
        return this.solrConfig.getPingQueryRequest(this);
    }

    public SolrRequestHandler getRequestHandler(String handlerName) {
        return this.reqHandlers.get(handlerName);
    }

    public Map<String, SolrRequestHandler> getRequestHandlers(Class clazz) {
        return this.reqHandlers.getAll(clazz);
    }

    public Map<String, SolrRequestHandler> getRequestHandlers() {
        return this.reqHandlers.getRequestHandlers();
    }

    @Deprecated
    public SolrHighlighter getHighlighter() {
        HighlightComponent hl = (HighlightComponent)this.searchComponents.get("highlight");
        return hl == null ? null : hl.getHighlighter();
    }

    public SolrRequestHandler registerRequestHandler(String handlerName, SolrRequestHandler handler) {
        return this.reqHandlers.register(handlerName, handler);
    }

    private Map<String, SearchComponent> loadSearchComponents() {
        HashMap<String, SearchComponent> components = new HashMap<String, SearchComponent>();
        this.initPlugins(components, SearchComponent.class);
        for (Map.Entry e : components.entrySet()) {
            SearchComponent c = (SearchComponent)e.getValue();
            if (!(c instanceof HighlightComponent)) continue;
            HighlightComponent hl = (HighlightComponent)c;
            if ("highlight".equals(e.getKey())) break;
            components.put("highlight", hl);
            break;
        }
        this.addIfNotPresent(components, "highlight", HighlightComponent.class);
        this.addIfNotPresent(components, "query", QueryComponent.class);
        this.addIfNotPresent(components, "facet", FacetComponent.class);
        this.addIfNotPresent(components, "mlt", MoreLikeThisComponent.class);
        this.addIfNotPresent(components, "stats", StatsComponent.class);
        this.addIfNotPresent(components, "debug", DebugComponent.class);
        return components;
    }

    private <T> void addIfNotPresent(Map<String, T> registry, String name, Class<? extends T> c) {
        if (!registry.containsKey(name)) {
            Object searchComp = this.resourceLoader.newInstance(c.getName(), new String[0]);
            registry.put(name, searchComp);
            if (searchComp instanceof SolrInfoMBean) {
                this.infoRegistry.put(((SolrInfoMBean)searchComp).getName(), (SolrInfoMBean)searchComp);
            }
        }
    }

    public SearchComponent getSearchComponent(String name) {
        SearchComponent component = this.searchComponents.get(name);
        if (component == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Search Component: " + name);
        }
        return component;
    }

    public Map<String, SearchComponent> getSearchComponents() {
        return Collections.unmodifiableMap(this.searchComponents);
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public RefCounted<SolrIndexSearcher> getSearcher() {
        try {
            return this.getSearcher(false, true, null);
        }
        catch (IOException e) {
            SolrException.log((Logger)log, null, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getNewestSearcher(boolean openNew) {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searchers.isEmpty()) {
                if (!openNew) {
                    return null;
                }
                throw new UnsupportedOperationException();
            }
            RefCounted<SolrIndexSearcher> newest = this._searchers.getLast();
            newest.incref();
            return newest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getSearcher(boolean forceNew, boolean returnSearcher, Future[] waitSearcher) throws IOException {
        SolrIndexSearcher tmp;
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            if (this.onDeckSearchers > 0 && !forceNew && this._searcher == null) {
                try {
                    this.searcherLock.wait();
                }
                catch (InterruptedException e) {
                    log.info(SolrException.toStr((Throwable)e));
                }
            }
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            ++this.onDeckSearchers;
            if (this.onDeckSearchers < 1) {
                log.error(this.logid + "ERROR!!! onDeckSearchers is " + this.onDeckSearchers);
                this.onDeckSearchers = 1;
            } else {
                if (this.onDeckSearchers > this.maxWarmingSearchers) {
                    --this.onDeckSearchers;
                    String msg = "Error opening new searcher. exceeded limit of maxWarmingSearchers=" + this.maxWarmingSearchers + ", try again later.";
                    log.warn(this.logid + "" + msg);
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, msg, true);
                }
                if (this.onDeckSearchers > 1) {
                    log.info(this.logid + "PERFORMANCE WARNING: Overlapping onDeckSearchers=" + this.onDeckSearchers);
                }
            }
        }
        RefCounted<SolrIndexSearcher> newestSearcher = null;
        try {
            newestSearcher = this.getNewestSearcher(false);
            String newIndexDir = this.getNewIndexDir();
            File indexDirFile = new File(this.getIndexDir()).getCanonicalFile();
            File newIndexDirFile = new File(newIndexDir).getCanonicalFile();
            if (newestSearcher != null && this.solrConfig.reopenReaders && indexDirFile.equals(newIndexDirFile)) {
                SolrIndexReader currentReader = newestSearcher.get().getReader();
                IndexReader newReader = currentReader.reopen();
                if (newReader == currentReader) {
                    currentReader.incRef();
                }
                tmp = new SolrIndexSearcher(this, this.schema, "main", newReader, true, true);
            } else {
                IndexReader reader = this.getIndexReaderFactory().newReader(this.getDirectoryFactory().open(newIndexDir), true);
                tmp = new SolrIndexSearcher(this, this.schema, "main", reader, true, true);
            }
        }
        catch (Throwable th) {
            Object indexDirFile = this.searcherLock;
            synchronized (indexDirFile) {
                --this.onDeckSearchers;
                this.searcherLock.notify();
            }
            throw new RuntimeException(th);
        }
        finally {
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
        final SolrIndexSearcher newSearcher = tmp;
        RefCounted<SolrIndexSearcher> currSearcherHolder = null;
        final RefCounted<SolrIndexSearcher> newSearchHolder = this.newHolder(newSearcher);
        if (returnSearcher) {
            newSearchHolder.incref();
        }
        final boolean[] decrementOnDeckCount = new boolean[]{true};
        try {
            boolean alreadyRegistered = false;
            Object object2 = this.searcherLock;
            synchronized (object2) {
                this._searchers.add(newSearchHolder);
                if (this._searcher == null) {
                    if (this.solrConfig.useColdSearcher) {
                        this.registerSearcher(newSearchHolder);
                        decrementOnDeckCount[0] = false;
                        alreadyRegistered = true;
                    }
                } else {
                    currSearcherHolder = this._searcher;
                    currSearcherHolder.incref();
                }
            }
            final SolrIndexSearcher currSearcher = currSearcherHolder == null ? null : currSearcherHolder.get();
            Future future = null;
            if (currSearcher != null) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            newSearcher.warm(currSearcher);
                        }
                        catch (Throwable e) {
                            SolrException.logOnce((Logger)log, null, (Throwable)e);
                        }
                        return null;
                    }
                });
            }
            if (currSearcher == null && this.firstSearcherListeners.size() > 0) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            for (SolrEventListener listener : SolrCore.this.firstSearcherListeners) {
                                listener.newSearcher(newSearcher, null);
                            }
                        }
                        catch (Throwable e) {
                            SolrException.logOnce((Logger)log, null, (Throwable)e);
                        }
                        return null;
                    }
                });
            }
            if (currSearcher != null && this.newSearcherListeners.size() > 0) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            for (SolrEventListener listener : SolrCore.this.newSearcherListeners) {
                                listener.newSearcher(newSearcher, currSearcher);
                            }
                        }
                        catch (Throwable e) {
                            SolrException.logOnce((Logger)log, null, (Throwable)e);
                        }
                        return null;
                    }
                });
            }
            final RefCounted<SolrIndexSearcher> currSearcherHolderF = currSearcherHolder;
            if (!alreadyRegistered) {
                future = this.searcherExecutor.submit(new Callable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call() throws Exception {
                        try {
                            decrementOnDeckCount[0] = false;
                            SolrCore.this.registerSearcher(newSearchHolder);
                        }
                        catch (Throwable e) {
                            SolrException.logOnce((Logger)log, null, (Throwable)e);
                        }
                        finally {
                            if (currSearcherHolderF != null) {
                                currSearcherHolderF.decref();
                            }
                        }
                        return null;
                    }
                });
            }
            if (waitSearcher != null) {
                waitSearcher[0] = future;
            }
            return returnSearcher ? newSearchHolder : null;
        }
        catch (Exception e) {
            SolrException.logOnce((Logger)log, null, (Throwable)e);
            if (currSearcherHolder != null) {
                currSearcherHolder.decref();
            }
            Object object3 = this.searcherLock;
            synchronized (object3) {
                if (decrementOnDeckCount[0]) {
                    --this.onDeckSearchers;
                }
                if (this.onDeckSearchers < 0) {
                    log.error(this.logid + "ERROR!!! onDeckSearchers after decrement=" + this.onDeckSearchers);
                    this.onDeckSearchers = 0;
                }
                this.searcherLock.notify();
            }
            return returnSearcher ? newSearchHolder : null;
        }
    }

    private RefCounted<SolrIndexSearcher> newHolder(SolrIndexSearcher newSearcher) {
        RefCounted<SolrIndexSearcher> holder = new RefCounted<SolrIndexSearcher>(newSearcher){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    Object object = SolrCore.this.searcherLock;
                    synchronized (object) {
                        if (this.refcount.get() > 0) {
                            return;
                        }
                        SolrCore.this._searchers.remove(this);
                    }
                    ((SolrIndexSearcher)this.resource).close();
                }
                catch (IOException e) {
                    log.error("Error closing searcher:" + SolrException.toStr((Throwable)e));
                }
            }
        };
        holder.incref();
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSearcher(RefCounted<SolrIndexSearcher> newSearcherHolder) throws IOException {
        Object object = this.searcherLock;
        synchronized (object) {
            try {
                if (this._searcher != null) {
                    this._searcher.decref();
                    this._searcher = null;
                }
                this._searcher = newSearcherHolder;
                SolrIndexSearcher newSearcher = newSearcherHolder.get();
                newSearcher.register();
                log.info(this.logid + "Registered new searcher " + newSearcher);
            }
            catch (Throwable e) {
                SolrCore.log(e);
            }
            finally {
                --this.onDeckSearchers;
                this.searcherLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSearcher() {
        log.info(this.logid + "Closing main searcher on request.");
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null) {
                this._searcher.decref();
                this._searcher = null;
                this.infoRegistry.remove("currentSearcher");
            }
        }
    }

    public void execute(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        if (handler == null) {
            String msg = "Null Request Handler '" + req.getParams().get("qt") + "'";
            if (log.isWarnEnabled()) {
                log.warn(this.logid + msg + ":" + req);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg, true);
        }
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        rsp.add("responseHeader", responseHeader);
        NamedList toLog = rsp.getToLog();
        toLog.add("webapp", req.getContext().get("webapp"));
        toLog.add("path", req.getContext().get("path"));
        toLog.add("params", (Object)("{" + req.getParamString() + "}"));
        handler.handleRequest(req, rsp);
        SolrCore.setResponseHeaderValues(handler, req, rsp);
        if (log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(this.logid);
            for (int i = 0; i < toLog.size(); ++i) {
                String name = toLog.getName(i);
                Object val = toLog.getVal(i);
                sb.append(name).append("=").append(val).append(" ");
            }
            log.info(sb.toString());
        }
    }

    @Deprecated
    public void execute(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrRequestHandler handler = this.getRequestHandler(req.getQueryType());
        if (handler == null) {
            log.warn(this.logid + "Unknown Request Handler '" + req.getQueryType() + "' :" + req);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Request Handler '" + req.getQueryType() + "'", true);
        }
        this.execute(handler, req, rsp);
    }

    public static void setResponseHeaderValues(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        String ep;
        NamedList responseHeader = rsp.getResponseHeader();
        int qtime = (int)(rsp.getEndTime() - req.getStartTime());
        int status = 0;
        Exception exception = rsp.getException();
        if (exception != null) {
            status = exception instanceof SolrException ? ((SolrException)((Object)exception)).code() : 500;
        }
        responseHeader.add("status", (Object)status);
        responseHeader.add("QTime", (Object)qtime);
        rsp.getToLog().add("status", (Object)status);
        rsp.getToLog().add("QTime", (Object)qtime);
        SolrParams params = req.getParams();
        if (params.getBool("echoHandler", false)) {
            responseHeader.add("handler", (Object)handler.getName());
        }
        if ((ep = params.get("echoParams", null)) != null) {
            CommonParams.EchoParamStyle echoParams = CommonParams.EchoParamStyle.get((String)ep);
            if (echoParams == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid value '" + ep + "' for " + "echoParams" + " parameter, use '" + CommonParams.EchoParamStyle.EXPLICIT + "' or '" + CommonParams.EchoParamStyle.ALL + "'");
            }
            if (echoParams == CommonParams.EchoParamStyle.EXPLICIT) {
                responseHeader.add("params", (Object)req.getOriginalParams().toNamedList());
            } else if (echoParams == CommonParams.EchoParamStyle.ALL) {
                responseHeader.add("params", (Object)req.getParams().toNamedList());
            }
        }
    }

    public static final void log(Throwable e) {
        SolrException.logOnce((Logger)log, null, (Throwable)e);
    }

    private void initWriters() {
        this.defaultResponseWriter = this.initPlugins(this.responseWriters, QueryResponseWriter.class);
        for (Map.Entry<String, QueryResponseWriter> entry : DEFAULT_RESPONSE_WRITERS.entrySet()) {
            if (this.responseWriters.get(entry.getKey()) != null) continue;
            this.responseWriters.put(entry.getKey(), entry.getValue());
        }
        if (this.defaultResponseWriter == null) {
            this.defaultResponseWriter = this.responseWriters.get("standard");
        }
    }

    public final QueryResponseWriter getQueryResponseWriter(String writerName) {
        QueryResponseWriter writer;
        if (writerName != null && (writer = this.responseWriters.get(writerName)) != null) {
            return writer;
        }
        return this.defaultResponseWriter;
    }

    public final QueryResponseWriter getQueryResponseWriter(SolrQueryRequest request) {
        return this.getQueryResponseWriter(request.getParams().get("wt"));
    }

    private void initQParsers() {
        this.initPlugins(this.qParserPlugins, QParserPlugin.class);
        for (int i = 0; i < QParserPlugin.standardPlugins.length; i += 2) {
            try {
                String name = (String)QParserPlugin.standardPlugins[i];
                if (null != this.qParserPlugins.get(name)) continue;
                Class clazz = (Class)QParserPlugin.standardPlugins[i + 1];
                QParserPlugin plugin = (QParserPlugin)clazz.newInstance();
                this.qParserPlugins.put(name, plugin);
                plugin.init(null);
                continue;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    public QParserPlugin getQueryPlugin(String parserName) {
        QParserPlugin plugin = this.qParserPlugins.get(parserName);
        if (plugin != null) {
            return plugin;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown query type '" + parserName + "'");
    }

    private void initValueSourceParsers() {
        this.initPlugins(this.valueSourceParsers, ValueSourceParser.class);
        for (Map.Entry<String, ValueSourceParser> entry : ValueSourceParser.standardValueSourceParsers.entrySet()) {
            try {
                String name = entry.getKey();
                if (null != this.valueSourceParsers.get(name)) continue;
                ValueSourceParser valueSourceParser = entry.getValue();
                this.valueSourceParsers.put(name, valueSourceParser);
                valueSourceParser.init(null);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    public <T> T initPlugins(Map<String, T> registry, Class<T> type, String defClassName) {
        return this.initPlugins(this.solrConfig.getPluginInfos(type.getName()), registry, type, defClassName);
    }

    public <T> T initPlugins(List<PluginInfo> pluginInfos, Map<String, T> registry, Class<T> type, String defClassName) {
        T def = null;
        for (PluginInfo info : pluginInfos) {
            T o = this.createInitInstance(info, type, type.getSimpleName(), defClassName);
            registry.put(info.name, o);
            if (!info.isDefault()) continue;
            def = o;
        }
        return def;
    }

    public <T> List<T> initPlugins(List<PluginInfo> pluginInfos, Class<T> type, String defClassName) {
        if (pluginInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (PluginInfo info : pluginInfos) {
            result.add(this.createInitInstance(info, type, type.getSimpleName(), defClassName));
        }
        return result;
    }

    public <T> T initPlugins(Map<String, T> registry, Class<T> type) {
        return this.initPlugins(registry, type, null);
    }

    public ValueSourceParser getValueSourceParser(String parserName) {
        return this.valueSourceParsers.get(parserName);
    }

    private void initDeprecatedSupport() {
        String facetSort;
        String gettable = this.solrConfig.get("admin/gettableFiles", null);
        if (gettable != null) {
            log.warn("solrconfig.xml uses deprecated <admin/gettableFiles>, Please update your config to use the ShowFileRequestHandler.");
            if (this.getRequestHandler("/admin/file") == null) {
                NamedList invariants = new NamedList();
                HashSet<String> hide = new HashSet<String>();
                File configdir = new File(this.solrConfig.getResourceLoader().getConfigDir());
                if (configdir.exists() && configdir.isDirectory()) {
                    for (String file : configdir.list()) {
                        hide.add(file.toUpperCase(Locale.ENGLISH));
                    }
                }
                StringTokenizer st = new StringTokenizer(gettable);
                while (st.hasMoreTokens()) {
                    hide.remove(st.nextToken().toUpperCase(Locale.ENGLISH));
                }
                for (String s : hide) {
                    invariants.add("hidden", (Object)s);
                }
                NamedList args = new NamedList();
                args.add("invariants", (Object)invariants);
                ShowFileRequestHandler handler = new ShowFileRequestHandler();
                handler.init(args);
                this.reqHandlers.register("/admin/file", handler);
                log.warn("adding ShowFileRequestHandler with hidden files: " + hide);
            }
        }
        if ((facetSort = this.solrConfig.get("//bool[@name='facet.sort']", null)) != null) {
            log.warn("solrconfig.xml uses deprecated <bool name='facet.sort'>. Please update your config to use <string name='facet.sort'>.");
        }
    }

    public CoreDescriptor getCoreDescriptor() {
        return this.coreDescriptor;
    }

    public IndexDeletionPolicyWrapper getDeletionPolicy() {
        return this.solrDelPolicy;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public String getDescription() {
        return "SolrCore";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CORE;
    }

    @Override
    public String getSourceId() {
        return "$Id: SolrCore.java 1145527 2011-07-12 10:27:45Z shalin $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_4/solr/core/src/java/org/apache/solr/core/SolrCore.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("coreName", (Object)(this.name == null ? "(null)" : this.name));
        lst.add("startTime", (Object)new Date(this.startTime));
        lst.add("refCount", (Object)this.getOpenCount());
        lst.add("aliases", this.getCoreDescriptor().getCoreContainer().getCoreNames(this));
        return lst;
    }

    static {
        boolean_query_max_clause_count = Integer.MIN_VALUE;
        dirs = new HashSet<String>();
        HashMap<String, QueryResponseWriter> m = new HashMap<String, QueryResponseWriter>();
        m.put("xml", new XMLResponseWriter());
        m.put("standard", (QueryResponseWriter)m.get("xml"));
        m.put("json", new JSONResponseWriter());
        m.put("python", new PythonResponseWriter());
        m.put("php", new PHPResponseWriter());
        m.put("phps", new PHPSerializedResponseWriter());
        m.put("ruby", new RubyResponseWriter());
        m.put("raw", new RawResponseWriter());
        m.put("javabin", new BinaryResponseWriter());
        m.put("velocity", new VelocityResponseWriter());
        m.put("csv", new CSVResponseWriter());
        DEFAULT_RESPONSE_WRITERS = Collections.unmodifiableMap(m);
    }
}

