/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.XmlUpdateRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentStreamHandlerBase
extends RequestHandlerBase {
    public static Logger log = LoggerFactory.getLogger(XmlUpdateRequestHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        String updateChainName = null;
        if (params.get("update.processor") != null) {
            log.warn("Use of deprecated update request parameter update.processor detected. Please use the new parameter update.chain instead, as support for update.processor will be removed in a later version.");
            updateChainName = params.get("update.processor");
        } else {
            updateChainName = params.get("update.chain");
        }
        UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessingChain(updateChainName);
        UpdateRequestProcessor processor = processorChain.createProcessor(req, rsp);
        try {
            ContentStreamLoader documentLoader = this.newLoader(req, processor);
            Iterable<ContentStream> streams = req.getContentStreams();
            if (streams == null) {
                if (!RequestHandlerUtils.handleCommit(processor, params, false) && !RequestHandlerUtils.handleRollback(processor, params, false)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing content stream");
                }
            } else {
                for (ContentStream stream : streams) {
                    documentLoader.load(req, rsp, stream);
                }
                RequestHandlerUtils.handleCommit(processor, params, false);
                RequestHandlerUtils.handleRollback(processor, params, false);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            processor.finish();
            throw throwable;
        }
        processor.finish();
    }

    protected abstract ContentStreamLoader newLoader(SolrQueryRequest var1, UpdateRequestProcessor var2);
}

